import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This file stores the matrices for the
   kite compactification*/


public class Torus {

    /**zero matrix**/

    public static Matrix zero(int s) {
	Matrix m=new Matrix();
	m.size=s;
	for(int i=0;i<s;++i) {
	    for(int j=0;j<s;++j) {
		m.a[i][j]=0;
	    }
	}
	return(m);
    }


    /**This matrix is the basic linear map**/

    public static Matrix L(double a) {
	Matrix m=zero(5);
	m.a[0][0]=0;
	m.a[0][1]=-1;
	m.a[0][2]=(-1-a)/2;
	m.a[0][3]=0;
	m.a[0][4]=0;

	m.a[1][0]=(a-1)/(a+1);
        m.a[1][1]=2*a/(1+a);
        m.a[1][2]=(a-1)/2;
	m.a[1][3]=0;
	m.a[1][4]=0;

	m.a[2][0]=-4*a/((1+a)*(1+a));
	m.a[2][1]=-4*a/((1+a)*(1+a));
	m.a[2][2]=(1-a)/(1+a);
	m.a[2][3]=0;
	m.a[2][4]=0;

	m.a[3][0]=(a-1)/(a+1);
	m.a[3][1]=(a-1)/(a+1);
	m.a[3][2]=(a-1)/2;
	m.a[3][3]=1;
	m.a[3][4]=0;

	m.a[4][0]=1;
	m.a[4][1]=0;
	m.a[4][2]=(-1-a)/2;
	m.a[4][3]=-1;
	m.a[4][4]=-1;
	return(m);

    }


    /**The rows of the returned matrix M are the dual vectors to the
       walls of the parallelopiped X1.  Here X1 consists of
       those vectors V such that M.V is contained in the unit
       cube centered at the origin. Put another way, M maps the
       parallelopiped to the unit cube **/

    public static Matrix X1(double a) {
	Matrix m=zero(5);
	m.a[0][0]=1;
	m.a[1][0]=2*a/(1+a);
	m.a[1][1]=1;
	m.a[1][4]=(1-a)/(1+a);
	m.a[2][0]=-2*a/(1+a);
	m.a[2][1]=(1-a)/(1+a);
	m.a[2][2]=1;
	m.a[2][4]=1;
	m.a[3][0]=-1;
	m.a[3][2]=(1+a)/2;
	m.a[3][3]=1;
	m.a[3][4]=1;
	m.a[4][4]=1;
	return(m);
    }

    /**The rows of this matrix are the dual vectors to the
       walls of the parallelopiped X2**/

    public static Matrix X2(double a) {

	Matrix m=zero(5);

	m.a[0][1]=-1;
	m.a[0][2]=(-1-a)/2;

	m.a[1][2]=-1;
	m.a[1][3]=(a-1)/(a+1);
	m.a[1][4]=(a-1)/(a+1);

	m.a[2][3]=-1;
	m.a[2][4]=-1;

	m.a[3][4]=-1;

	m.a[4][0]=1;
	m.a[4][2]=(-1-a)/2;
	m.a[4][3]=-1;
	m.a[4][4]=-1;

	return(m);
    }

    /**This maps a vector into the unit cube by suitably
       subtracting integers.**/

    public static Vector toCube(Vector V) {
	Vector W=new Vector(V.size);
	for(int i=0;i<V.size;++i) {
	    W.x[i]=fp(V.x[i]);
	}
	return(W);
    }

    /**This routine tests whether W lies in the fundamental domain X1**/


    public static boolean testDomain1(double a,Vector W) {
	Matrix M=X1(a);
	Vector X=Matrix.act(M,W);
	return(testCube(X));
    }

    public static boolean testDomain2(double a,Vector W) {
	Matrix M=X2(a);
	Vector X=Matrix.act(M,W);
	return(testCube(X));
    }

    /**This routine tests whether a vector X lies in the
       unit cube centered at the origin.*/

    public static boolean testCube(Vector X) {
	for(int i=0;i<X.size;++i) {
	    if(X.x[i]<-.5) return(false);
	    if(X.x[i]>+.5) return(false);
	}
	return(true);
    }

    /**This routine adds integers to the coordinates of a
       vector until it lies in the fundamental domain X1.**/


    public static Vector toDomain1(double a,Vector V) {
	boolean test=false;
	int count=0;
	Vector W=new Vector(V);
	while((test==false)&&(count<20)) {
	    W=improve(a,W);
	    test=testDomain1(a,W);
	    ++count;
	}
	if(test==true) return(W);
	return(null);
    }


    public static Vector toDomain2(double a, Vector V) {
	Vector W=Matrix.act(L(a),V);
	W=toDomain1(a,W);
	W=Matrix.act(L(a),W);
	return(W);
    }

    public static Vector improve(double a,Vector V) {
	Matrix M=X1(a);
	Vector X=Matrix.act(M,V);
	Vector W=new Vector(V);
	for(int i=0;i<5;++i) {
	    if(X.x[i]>+.5) W.x[i]=W.x[i]-1;
	}

	for(int i=0;i<5;++i) {
	    if(X.x[i]<-.5) W.x[i]=W.x[i]+1;
	}

	return(W);
    }

    /**This is the affine PET from the unit cube to itself*/

    public static Vector map(double a,Vector V) {
	Vector V1=toDomain1(a,V);
	Vector V2=Matrix.act(L(a),V1);
	Vector V3=toCube(V2);
	return(V3);
    }


    /**This is the PET from the first parallelotope to itself. 
       It is the square of the affine PET.**/

     public static Vector map2(double a,Vector V) {
	  Vector W=new Vector(V);
	  W=toDomain2(a,W);
	  W=toDomain1(a,W);
	  return(W);
     }

    /**the fractional part**/

    public static double fp(double x) {
	return(x-Math.floor(.5+x));
    }


    /**Here is the map to the torus**/

    public static Vector psiTorus(int[] q,double a,Complex z) {
	double[] r=QTCKite.getR(a,a);
	Vector V=new Vector(5);
	for(int i=0;i<4;++i) V.x[i]=fp(z.x/r[i]-q[i]/2.0);
	V.x[4]=fp(z.y);
	return(V);
    }


    /**Here is the map to the fundamental domain**/

    public static Vector psiDomain(int[] q,double a,Complex z) {
	Vector V=psiTorus(q,a,z);
	V=toDomain1(a,V);
	return(V);
    }





}




