import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class AGCompute implements Runnable {
    Manager M;
    Complex SOURCE;
    int LEVEL;
    int halt;
    double A;
    int CLOSED=0;

    public AGCompute() {}

    public AGCompute(Complex z,Manager MM) {
	int p=MM.p();
	int q=MM.q();
	this.SOURCE=AGTransforms.map(p,q,z);
	LEVEL=(int)(Math.floor(z.x));
	this.M=MM;
    }


    public void run() {
	int mode=M.C.GRAPH.AG.mode;
	int p=M.p();
	int q=M.q();
	if((p*q)%2==1) {
	    System.out.println("odd rational: nothing plotted");
	    mode=-1;
	}
	if(mode==0)  fundamental();  
	if(mode==1)  modularPlot();           //all even predecessors	
        if(mode==2)  orbitPlot(0);    
        if(mode==3)  blockPlot(p,q);          //block plot
    }

    public void sendMessage(int c) {
           if((c>0)&&(c%100==0)) {
	      Integer COUNT=new Integer(c);
	      M.C.PROGRESS=COUNT.toString();
	      M.C.repaint();
	   }
    }


    /***********plotting routines**********/

    public void orbitPlot(int direction) {
	int m=(int)(Math.floor(SOURCE.x+.5));
	int n=(int)(Math.floor(SOURCE.y+.5));
	int p=M.p();
	int q=M.q();
	int parity=(direction+m+n+100000)%2;
	periodPlot(p,q,m,n,parity,0);
    }

    /*STOP=1 -- plot 1 period in the unstable case.
      STOP=0 -- no constraints */

    public GeneralPath periodPlot(int pp,int qq,int m,int n,int dir,int STOP) {
        GeneralPath gp=new GeneralPath();
	A=1.0*pp/qq;
	AGPoint P1=new AGPoint(m,n,-1);
	AGPoint P2=new AGPoint(m,n,-1);
	double LIM=M.C.GRAPH.getLimit();
	int count=0;
	int closed=0;	
        int p=M.p();
	int q=M.q();

	halt=1;
        gp.moveTo(P1.m,P1.n);
       	while((halt==1)&&(count<LIM)) {
	    P2=AGLocal.firstReturn(P1,A,dir);
	    gp.lineTo(P2.m,P2.n);
	    if((P2.m==m)&&(P2.n==n)) closed=1;
	    if((STOP==1)&&(P2.m-m==qq)&&(P2.n-n==-pp)) closed=1;
	    if((STOP==1)&&(P2.m-m==-qq)&&(P2.n-n==pp)) closed=1;
	    if(closed==1) halt=0;
            P1=new AGPoint(P2);
	    sendMessage(count);
	    ++count;
	}
	halt=0;
	CLOSED=closed; 
        int style=M.C.GRAPH.STYLE.mode;
	if(CLOSED==0) style=0;
	M.P.nextOrbit(gp,style,p,q,pp,qq);
	M.P.repaint();
	
	return(gp);
    }



    public void fundamental() {
	int p=M.p();
	int q=M.q();
	if((p*q)%2==1) return;
        periodPlot(p,q,0,0,0,1);
    }

    public void modularPlot() {
	int p=M.p();
	int q=M.q();
	Color[] C={new Color(0,0,255),new Color(200,0,100),new Color(0,200,0)};
	int parity=0;
	int test=(p*q)%2;
        M.C.CS.C=C[0];
	if(test==0) {
	   while(q>1) {
  	      M.C.CS.C=C[parity];
	      periodPlot(p,q,0,0,0,1);
	      int[] x=MathRational.evenPredecessor(p,q);
	      p=x[0];
	      q=x[1];
	      parity=(parity+1)%3;
	  }
	}
    }

    /**These are the block plotting routines, where a whole
       array is plotted.*/

    public void blockPlot(int p,int q) {
 	double A=1.0*M.p()/M.q();
 	AGLocal L;
  	int i2=(int)(Math.floor(SOURCE.x+.5));
  	int j2=(int)(Math.floor(SOURCE.y+.5));
 	GeneralPath gp=new GeneralPath();
 	int LIM1=M.C.GRAPH.getWidthLimit();
 	int LIM2=M.C.GRAPH.getHeightLimit();
 	int i,j;
  	i=-LIM1;
 	j=-LIM2;
	halt=1;
	GeneralPath BOX=Displays.periodBox(LEVEL);
	BOX=AGTransforms.map(p,q,BOX);

	while((j<LIM2)&&(halt==1)) {
	    if(BOX.contains(i+i2,j+j2)==true) {
	      L=AGLocal.doLocal(i+i2,j+j2,A);
              M.P.nextBlock(L.gp,p,q);
	    }
	      if(i<LIM1) ++i;
	      if(i==LIM1) {
                   Integer JJ=new Integer(j);
	           M.C.PROGRESS=JJ.toString();
	           M.C.repaint(); 
                   ++j;
		   i=-LIM1;
	      }
	}

	halt=0;
	M.P.repaint();   
    }

}

