import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class AGPinwheel {
    double[][] h=new double[5][3];
    Complex[] v=new Complex[10];
    double A;

    public AGPinwheel(double AA) {
	this.A=AA;

	v[1]=new Complex(0,4);
	v[2]=new Complex(-2,2);
	v[3]=new Complex(-2-2*A,0);
	v[0]=new Complex(-2,-2);

	h[1][0]=-1;
	h[1][1]=+1;
	h[1][2]=+3;

	h[2][0]=  -2/(1+A);
	h[2][1]= 2*A/(1+A);
	h[2][2]= 2*A/(1+A);

	h[3][0]=  -2/(1+A);
	h[3][1]=-2*A/(1+A);
	h[3][2]= 2*A/(1+A);

	h[0][0]=-1;
	h[0][1]=-1;
	h[0][2]=+3;

	for(int i=0;i<4;++i) {
	    for(int j=0;j<3;++j) {
		h[i][j]=.25*h[i][j];
	    }
	}
    }


    /**This is the basics of the pinwheel map*/

    public double evaluate(int j,Complex z) {
	Complex V=new Complex(v[j]);
	double d=h[j][0]*z.x+h[j][1]*z.y+h[j][2];
	return(d);
    }

    public int getDepth(int j,Complex z) {
	double d=evaluate(j,z);
	int n=-(int)(Math.floor(d));
	return(n);
    }

    public Complex doMap(int j,Complex z) {
	int d=getDepth(j,z);
	Complex V=new Complex(d*v[j].x,d*v[j].y);
	Complex w=Complex.plus(V,z);
	return(w);
    }

    /**This computes all the integer parts of the basic octagon*/

    public int[] mapSpectrum(Complex zz) {
	int[] n=new int[10];
	Complex z=new Complex(zz);
	for(int j=1;j<=8;++j) {
	    n[j]=getDepth(j%4,z);
	    z=doMap(j%4,z);
	}
	return(n);
    }

    public int[] doReturnIntegral(Complex zz) {
	int[] n=mapSpectrum(zz);
	int[] s=new int[3];
	s[0]=-n[7]-n[3];
	s[1]=-n[2]-n[3]-n[4]-n[6]-n[7]-n[8];
        int parity=(s[0]+s[1]+4)%2;
	s[2]=(int)(zz.y);
	s[2]=1;
	if(zz.y<0) s[2]=-1;
	if(parity==1) s[2]=-s[2];
	return(s);
    }



}

