import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class AGTransforms {
    public static boolean ON;
    public static int P;
    public static int Q;

    /**This defines the map from the unit square to the
       lowest chamber of the period box.  The whole period
       box is the image of the square [0,1]x[0,2(p+q)].*/

    public static double[] map(int p,int q,double[] Z) {
	double[] X=periodBoxCorner(p,q);
	double[] V=vectorV(p,q);
	double[] W=vectorW(p,q);
	W[0]=2*W[0];
	W[1]=2*W[1];
	double x=X[0]+Z[1]*V[0]+Z[0]*W[0];
	double y=X[1]+Z[1]*V[1]+Z[0]*W[1];
	double[] ZZ={x,y};
	return(ZZ);
    }

    public static Complex map(int p,int q,Complex z) {
	double[] Z={z.x,z.y};
	Z=map(p,q,Z);
	Complex w=new Complex (Z[0],Z[1]);
	return(w);
    }

    public static GeneralPath inverseMap(int p,int q,GeneralPath gp) {
	AffineTransform AFF=inverseMap(p,q);
	GeneralPath gp2=new GeneralPath(gp);
	gp2.transform(AFF);
	return(gp2);
    }

    public static AffineTransform directMap(int p,int q) {
	double[] X=periodBoxCorner(p,q);
	double[] V=vectorV(p,q);
	double[] W=vectorW(p,q);
	float v0=(float)(V[0]);
	float v1=(float)(V[1]);
	float w0=(float)(2*W[0]);
	float w1=(float)(2*W[1]);
	float x0=(float)(X[0]);
	float x1=(float)(X[1]);
	AffineTransform AFF=new AffineTransform(w0,w1,v0,v1,x0,x1);
	return(AFF);
    }

    public static GeneralPath map(int p,int q,GeneralPath gp0) {
	AffineTransform AFF=directMap(p,q);
	GeneralPath gp1=new GeneralPath(gp0);
	gp1.transform(AFF);
	return(gp1);
    }

    public static AffineTransform inverseMap(int p,int q) {
	AffineTransform AFF=directMap(p,q);
	try {AFF=AFF.createInverse();}
	catch(Exception e) {}
	return(AFF);
    }




    /**Here is the bottom left period box corner*/

    public static double[] periodBoxCorner(int p,int q) {
	 int[] x=MathRational.evenPredecessor(p,q);
	 double a0=(q-x[1])/2.0;
	 double a1=-a0*p/q;
	 if(1.0*x[0]/x[1]>1.0*p/q) {
	     a0=-a0;
	     a1=-a1;
	 }
	 if(a0>0) {
	     a0=a0-q;
	     a1=a1+p;
	 }
	 double[] A={a0,a1};
	 return(A);
    }


    /**This defines the bilateral symmetry which is
       adapted to the directions of the arithmetic grid*/

    public static GeneralPath reflect(int p,int q,GeneralPath gp1) {
	GeneralPath gp2=new GeneralPath(gp1);
	gp2.transform(AFF2(p,q));
	gp2.transform(AFF1(p,q));
	gp2.transform(AFF3(p,q));
	return(gp2);
    }

    /**These vectors also appear in the arithmetic grid class.*/
    public static double[] vectorV(int p,int q) {
	double[] X=new double[2];
	X[0]=1.0*q;
	X[1]=-1.0*p;
	return(X);
    }

    public static double[] vectorW(int p,int q) {
	double[] X=new double[2];
        X[0]=1.0*(p*q)/(p+q);
	X[1]=X[0]+(q-p)/2.0;
	return(X);
    }

    public static AffineTransform AFF1(int p,int q) {
	double[] m1=vectorV(p,q);
	double[] m2=vectorW(p,q);
	double a=m1[0];
	double b=m1[1];
	double c=m2[0];
	double d=m2[1];
	AffineTransform A=new AffineTransform(a,b,c,d,0,0);
	return(A);
    }

    public static AffineTransform AFF2(int p,int q) {
	double[] m1=vectorV(p,q);
	double[] m2=vectorW(p,q);
	double a=-m1[0];
	double b=-m1[1];
	double c=m2[0];
	double d=m2[1];
	AffineTransform A=new AffineTransform(a,b,c,d,0,0);
	try {A=A.createInverse();}
	catch(Exception e) {}
	return(A);
    }

    public static AffineTransform AFF3(int p,int q) {
         int[] x=MathRational.RPLUS(p,q); 
	 double x0=1.0*x[0];
	 double x1=1.0*x[1];
	 x0=x1*p/q;
         AffineTransform A=AffineTransform.getTranslateInstance(x1,-x0);
	 return(A);
     }


}







