import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;



public class BoxCombinatorics {



    /**This computes the interacton of two indices. These
       indices are attached to a pair of lines.*/

    public static boolean interact(int m,int n) {
	int k=interactionMatrix(m,n);
	if(k==0) return(false);
	return(true);
    }

    public static int interactionMatrix(int m,int n) {
	if(n==-1) return(1/0);
	int[][] a={{0,1,0,1,1,0,1,0},
                   {1,0,1,0,0,1,0,1},
                   {1,0,1,0,1,0,1,0},
                   {0,1,0,1,0,1,0,1}};
	return(a[m][n]);
    }


    /**In the model, it usually happens that a pair of
       slanting (oct) lines cross the arithmetic graph
       lines (ari) in pairs.  These routines start with
       the oct-label of one of the lines, and find the
       oct-label of the other one.*/

    public static int partner(boolean test,int ari,int oct) {
	if(test==false) return(partner0(ari,oct));
	return(partner1(ari,oct));
    }



    public static int partner0(int ari,int oct) {
	if(oct==-1) return(1/0);

	if(ari<2) {
	    int[] t={6,7,4,5,2,3,0,1};
	    return(t[oct]);
	}

	if(ari>1) {
	    int[] t={5,4,7,6,1,0,3,2};
	    return(t[oct]);
	}

	return(1/0);
    }

    public static int partner1(int ari,int oct) {

	if(ari==0) {
	    if(oct==1) return(6);
	    if(oct==6) return(1);
	    if(oct==3) return(4);
	    if(oct==4) return(3);
	}
	if(ari==1) {
	    if(oct==2) return(5);
	    if(oct==5) return(2);
	    if(oct==0) return(7);
	    if(oct==7) return(0);
	}

	if(ari==2) {
	    if(oct==0) return(4);
	    if(oct==4) return(0);
	    if(oct==2) return(6);
	    if(oct==6) return(2);
	}

	if(ari==3) {
	    if(oct==1) return(5);
	    if(oct==5) return(1);
	    if(oct==3) return(7);
	    if(oct==7) return(3);
	}
	return(1/0);

    }


}


