import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class BoxCompute implements Runnable {
    Manager M;
    int LEVEL;
    int halt;

    public BoxCompute() {}

    public BoxCompute(Complex z,Manager MM) {  
	LEVEL=(int)(Math.floor(z.x));
	this.M=MM;
    }


    public void run() {	
	//long s0=Time.time();
      int p=M.p();
      int q=M.q();
      int test=(p+q)%2;
      if(test==0) {
	  System.out.println("odd rational");
	  return;
      }
      int local=M.C.GRAPH.LOCAL.mode;
      int mode=M.C.GRAPH.ACTION.mode;   
      int depth=M.C.GRID.DEPTH1.val;
      int n=(p+q-1)/2;
       if(mode==0)  basic(depth); 
       if(mode==1)  plaid(depth);   
       if(mode==2)  recursive(depth);
       if(mode==3)  recurAndHide(depth);
       if(mode==4)  basic(n);   
       //long s1=Time.time()-s0;
       //Time.print(s1);
    }



    public void basic(int depth) {
	int mode=M.C.GRAPH.LOCAL.mode;
	BoxModel[] B={};
	if(mode==0) B=getModels(depth);
	if(mode==1) B=getModelsNew(depth);

	halt=1;
	int i=0;
	while((halt==1)&&(i<B.length)) {
	    BoxProcess.assignPoints(B[i]);
            M.P.nextBox(B[i]);
            M.P.repaint();
	    M.C.repaint();
	    ++i;
	}
	halt=0;
	M.C.repaint();
    }


    public void recursive(int depth) {
	halt=1;
	int mode=M.C.GRAPH.LOCAL.mode;
	int sub=M.C.BOX.SUB.mode;
	BoxModel[] B={};
	if(mode==0) B=getModels(depth);
	if(mode==1) B=getModelsNew(depth);
        while((halt==1)&&(B.length>0)) {
	   int L=B.length-1;
	   BoxProcess.assignPoints(B[L]);
	   if(B[L].COMPLETE==true) {
              M.P.nextBox(B[L]);	
              M.P.repaint();
              B=BoxSubdivision.chop(B);
	   }
           else B=BoxSubdivision.subdivideDFS(sub,B);
	}
	halt=0;
	M.C.repaint();
    }

    public void plaid(int depth) {
	halt=1;
	int mode=M.C.GRAPH.LOCAL.mode;
 	int sub=M.C.BOX.SUB.mode;
	BoxModel[] B={};
	if(mode==0) B=getModels(depth);
	if(mode==1) B=getModelsNew(depth);
        while((halt==1)&&(B.length>0)) {
	   int L=B.length-1;
	   BoxProcess.assignPoints(B[L]);
	
	   boolean test1=false;
	   if(B[L].COMPLETE==true) test1=true;
	   if(B[L].AGE==0) {
	       if(B[L].POINTS>4) test1=true;
	       if((B[L].POINTS==4)&&(BoxProcess.isCross(B[L])!=1)) test1=true;
	   } 
	   if(test1==true) {
              M.P.nextBox(B[L]);	
              M.P.repaint();
              B=BoxSubdivision.chop(B);
	   }
           else B=BoxSubdivision.subdivideDFS(sub,B);
	}
	halt=0;
	M.C.repaint();
    }




    public void recurAndHide(int depth) {
	halt=1;	
        int mode=M.C.GRAPH.LOCAL.mode;
	int sub=M.C.BOX.SUB.mode;
	BoxModel[] B={};
	if(mode==0) B=getModels(depth);
	if(mode==1) B=getModelsNew(depth);
        while((halt==1)&&(B.length>0)) {
	   B=BoxSubdivision.expose(B);
	   B=BoxMerge.compress(B);
	   int L=B.length-1;

	   if((B[L].COMPLETE==true)&&(B[L].AGE==0)) {
	       M.P.nextBox(B[L]);
               M.P.repaint();
	       B=BoxSubdivision.chop(B);
	   }

	   else {   
	       BoxProcess.assignPoints(B[L]);
	       if(B[L].COMPLETE==false) 
		   B=BoxSubdivision.subdivideDFS(0,B);
	   }
	}
	halt=0;
	M.P.repaint();
	M.C.repaint();
    }


    public BoxModel[] getModels(int depth) {
      int level=(int)(Math.floor(M.P.SOURCE.x));
      int p=M.p();
      int q=M.q();
      if(2*depth>p+q) return null;
      BoxModel[] B=BoxGenerate.getBoxModels(level,depth,p,q);
      for(int i=0;i<B.length;++i) B[i].COMPLETE=false;
      return(B);
    }

    public BoxModel[] getModelsNew(int depth) {
	BoxModel B=getLocalNew();
	System.out.println(B.INDEX[0]+" "+B.INDEX[1]);
	return BoxGenerate.getBoxModels(depth,B);
    }

    public BoxModel getLocalNew() {
        int depth=M.C.GRID.DEPTH1.val;
	Complex z=M.P.SOURCE;
	BoxModel[] B=getModels(depth);
	for(int i=0;i<B.length;++i) {
	    boolean test=B[i].containsWeak(z);
	    if(test==true) return(B[i]);
	}
	return(null);
    }
}

