import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;



public class BoxCross {



    public static int[][] surveySingle(int mode,int gap0,int gap1,int depth,Manager M) {
	int[] rat=GridGenerator.inverse(mode,gap0,gap1,depth,10000);
	if(rat==null) return null;
	int p=rat[0];
	int q=rat[1];
	MathContinuedFractions.printCFE(p,q);
	int[] target=findBox(p,q,gap1,depth);
	if(target==null) {
	    int[][] A={{9,9}};
	    return(A);
	}
	int t=target[0];
	int k=target[1];
        int J=MathRational.getInverse(p,q);
	t=(t-J*gap1+(p+q)*(p+q))%(p+q);
	int count=0;
	int[][] A=new int[gap1][2];
	int t0=0;
	for(int i=0;i<2*gap1;++i) {
	    BoxModel[] B=BoxGenerate.getBoxModels(t,depth,p,q);
            BoxProcess.assignPoints(B[k]);
	    int[] a=type(B[k]);
	    if((a.length>1)&&(a[1]<=gap1/2)) {
		A[count][0]=a[1];
		A[count][1]=a[2];
		t0=t;
		++count;
	    }
            t=(t+J)%(p+q);
	}
	if(A==null) return null;
	A=ListHelp.trimList(A,count);
	if(A!=null) {
	    M.C.SES.acceptFraction(rat);
	    M.C.SES.GRID.val=depth;
	    M.C.GRID.DEPTH1.val=depth;
	    M.P.toOrigin();
	    if(t0!=0) M.P.jump(1,t0);
	    double d=1.0*rat[0]/rat[1];
	    int test=hasCross(rat[0],rat[1],gap1,depth);
	    if(test==1) System.out.print("* ");
	    if(test==2) System.out.print("** ");
	}
	return(A);
    }


    public static int[][] surveySingleZero(int mode,int gap0,int gap1,int depth,Manager M) {
	int[] rat=GridGenerator.inverse(mode,gap0,gap1,depth,10000);
	if(rat==null) return null;
	int p=rat[0];
	int q=rat[1];
	MathContinuedFractions.printCFE(p,q);
	int[] target=findBoxZero(p,q,gap1,depth);
	if(target==null) return(null);
	M.C.SES.acceptFraction(rat);
	M.C.SES.GRID.val=depth;
	M.C.GRID.DEPTH1.val=depth;
	M.P.toOrigin();
	int[][] A={target};
	return(A);
    }



    public static int[] findBox(int p,int q,int h,int depth) {
	for(int level=0;level<(p+q)/2;++level) {
           BoxModel[] B=BoxGenerate.getBoxModels(level,depth,p,q);
	   for(int i=0;i<B.length;++i) {  
	       if(isBox(B[i],h)==true) {
                 BoxProcess.assignPoints(B[i]);
	         int[] a=typeWeak(B[i]);
	         if((a[0]==h)&&(a[1]<=a[0]/2)) {
		   int[] b={level,i};
		   return(b);
		 }
	       }
	   }
	}
	return null;
    }

    public static int[] findBoxZero(int p,int q,int h,int depth) {
        BoxModel[] B=BoxGenerate.getBoxModels(0,depth,p,q);
	for(int i=0;i<B.length;++i) {  
	   if(isBox(B[i],h)==true) {
             BoxProcess.assignPoints(B[i]);
	     int[] a=typeWeak(B[i]);
	     if(a[0]==h) {
		 int[] A={0,i};
		 return(A);
	     }
	   }
	}
	return(null);
    }




    public static int hasCross(int p,int q,int h,int depth) {
       BoxModel[] B=BoxGenerate.getBoxModels(0,depth,p,q);
       for(int i=0;i<B.length;++i) {  
	  if(isBox(B[i],h)==true) {
            BoxProcess.assignPoints(B[i]);
	    int[] a=typeWeak(B[i]);
	    if(a.length>1) {
		if((a[1]>1)&&(a[1]<h-1)&&(a[0]==h)) {
		    int[] b=type(B[i]); 
		    if((b[2]==1)&&(a[1]<h/2)) return(2);
		    if((b[2]==0)&&(a[1]>h/2)) return(2);
		    return(1);
		}
	    }
	  }
       }
       return(0);
    }




    public static boolean isBox(BoxModel B,int h) {
	if(width(B)!=h) return(false);
	if(height(B)!=h) return(false);
	return(true);
    }

    public static int[] type(BoxModel B) {
	int[] A=typeWeak(B);
	if(A.length<3) return(A);
	if(leftCross(B)==true) A[2]=1;
	return(A);
    }

    public static int[] typeWeak(BoxModel B) {
	int[] A=new int[3];
	if(BoxProcess.isCross(B)!=1) {
	    A=ListHelp.trimList(A,1);
	    return(A);
	}
	boolean test=isTopCross(B);
	if(test==false) {
	    A=ListHelp.trimList(A,1);
	    return(A);
	}
	A[0]=width(B);
	A[1]=getTop(B);
	A[2]=0;
	return(A);
    }




    /**Gets the position of the top of the box*/

    public static int width(BoxModel B) {
	Complex w=B.H0[0];
	Complex z=B.H0[1];
	int n=(int)(Math.floor((B.P+B.Q)*(z.x-w.x)+.5));
	return(n);
    }

    public static int height(BoxModel B) {
	Complex w=B.V0[0];
	Complex z=B.V0[1];
	int n=(int)(Math.floor((B.P+B.Q)*(z.y-w.y)+.5));
	return(n);
    }

    /**Gets the position of the top of the box*/

    public static int getTop(BoxModel B) {
	int n=-1;
	Complex w=B.H0[0];
	for(int i=0;i<4;++i) {
	    Complex z=B.Z[i];
	    if(z.SIDE==3) n=(int)(Math.floor((B.P+B.Q)*(z.x-w.x)));
	}
	return(n+1);
    }



    /**Assumes that we have a cross*/
    public static boolean isTopCross(BoxModel B) {
	Complex z1=B.center();
	double y1=z1.y;
	Complex z2=new Complex();
	for(int i=0;i<4;++i) {
	    z2=Complex.plus(z2,B.Z[i]);
	}
	double y2=z2.y/4;
	if(y2>y1) return(true);
	return(false);
    }


    /**This is the most important function.  It tells
       whether we have a left cross or a right cross.*/

    public static boolean leftCross(BoxModel B) {
	BoxModel B2=complete(B);
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		if(i!=j) {
		    if(B2.Z[i].SIDE==3) {
			if(B2.Z[j].SIDE==1) {
			    if(B2.partner[i]==j) return(true);
			}
		    }
		}
	    }
	}
	return(false);
    }

    public static BoxModel complete(BoxModel INIT) {
	BoxModel[] B={INIT};
        while(B.length>0) {
	   B=BoxSubdivision.expose(B);
	   B=BoxMerge.compress(B);
	   int L=B.length-1;

	   if((B[L].COMPLETE==true)&&(B[L].AGE==0)) {
	       return(B[L]);
	   }

	   else {   
	       BoxProcess.assignPoints(B[L]);
	       if(B[L].COMPLETE==false) 
		   B=BoxSubdivision.subdivideDFS(0,B);
	   }
	}
	return(INIT);
    }

}
