import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

/**This class generates the initial boxes for the
   algorithms*/

public class BoxGenerate {

    public static double[][] getOffsets(int p,int q,int depth) {
	return getOffsets(p,q,depth,0,1);
    }

    /**Gets the positions of the lines, and their tags*/

    public static double[][] getOffsets(int p,int q,int depth,double lim1,double lim2) {
	double s0=MathRational.gap(p,q);
	double[][] d0=new double[2*depth+2][3];
	int count=0;
	double tol=.0000000001;
	for(int i=0;i<depth+1;++i) {
	    double s1=i*s0-Math.floor(i*s0);
	    double s2=1-s1;
	    if((s1>lim1-tol)&&(s1<lim2+tol)) {
		d0[count][0]=s1;
		d0[count][1]=i;
		d0[count][2]=0;
		++count;
	    } 
            if((s2>lim1-tol)&&(s2<lim2+tol)) {
		d0[count][0]=s2;
		d0[count][1]=i;
		d0[count][2]=1;
		++count;
	    }
	}
	double[][] d=new double[count][3];
	for(int i=0;i<count;++i) {
	    for(int j=0;j<3;++j) {
		d[i][j]=d0[i][j];
	    }
	}

	double[] e=new double[count];
	for(int i=0;i<count;++i) e[i]=d[i][0];
	Arrays.sort(e);
	double[][] f=new double[count][3];
	for(int i=0;i<count;++i) {
           f[i][0]=e[i];
	   for(int j=0;j<count;++j) {
	       if(Math.abs(d[j][0]-f[i][0])<.000000001) {
		f[i][1]=d[j][1];
		f[i][2]=d[j][2];
	     }
	   }
	}
	return(f);
    }

    public static BoxModel[] getBoxModels(int level,int depth,int p,int q,double[] X,double[] Y) {
	double[][] d0=getOffsets(p,q,depth,X[0],X[1]);
	double[][] d1=getOffsets(p,q,depth,Y[0],Y[1]);
	int count=0;
	int l0=d0.length-1;
	int l1=d1.length-1;
	BoxModel[] B=new BoxModel[l0*l1];
	for(int i0=0;i0<l0;++i0) {
	    for(int i1=0;i1<l1;++i1) {
		BoxModel A=new BoxModel();
	        A.P=p;
	        A.Q=q;	
                A.V0[0]=new Complex(level+d0[i0+0][0],d1[i1+0][0]);
	        A.V0[1]=new Complex(level+d0[i0+0][0],d1[i1+1][0]);
	        A.V1[0]=new Complex(level+d0[i0+1][0],d1[i1+0][0]);
	        A.V1[1]=new Complex(level+d0[i0+1][0],d1[i1+1][0]);
	        A.H0[0]=new Complex(level+d0[i0+0][0],d1[i1+0][0]);
	        A.H0[1]=new Complex(level+d0[i0+1][0],d1[i1+0][0]);
	        A.H1[0]=new Complex(level+d0[i0+0][0],d1[i1+1][0]);
	        A.H1[1]=new Complex(level+d0[i0+1][0],d1[i1+1][0]);

	        A.H0[0].MASS=(int)(d1[i1+0][1]);
	        A.H0[0].ARI=(int)(d1[i1+0][2])+2;
	        A.H1[0].MASS=(int)(d1[i1+1][1]);
	        A.H1[0].ARI=(int)(d1[i1+1][2])+2;
	        A.V0[0].MASS=(int)(d0[i0+0][1]);
	        A.V0[0].ARI=(int)(d0[i0+0][2])+0;
	        A.V1[0].MASS=(int)(d0[i0+1][1]);
	        A.V1[0].ARI=(int)(d0[i0+1][2])+0;

	        A.LEVEL=level;
	        int[] D={A.H0[0].MASS,A.H1[0].MASS,A.V0[0].MASS,A.V1[0].MASS};
	        int dd=0;
	        for(int ii=0;ii<4;++ii) if(dd<D[ii]) dd=D[ii];
	        A.DEPTH=dd;
		A.INDEX[0]=i0;
		A.INDEX[1]=i1;
	        A.COMPLETE=false;
		B[count]=new BoxModel(A);
		++count;
	    }
	}
	return(B);
    }

    public static BoxModel[] getBoxModels(int level,int depth,int p,int q) {
	double[] X={0,1};
	double[] Y={0,1};
	return getBoxModels(level,depth,p,q,X,Y);
    }

    public static BoxModel[] getBoxModels(int depth,BoxModel B) {
	double[] X={B.H0[0].x,B.H0[1].x};
	double[] Y={B.V0[0].y,B.V0[1].y};
	for(int i=0;i<2;++i) X[i]=X[i]-B.LEVEL;
	Arrays.sort(X);
	Arrays.sort(Y);
	return getBoxModels(B.LEVEL,depth,B.P,B.Q,X,Y);
    }

}