import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;



public class BoxMerge {




    public static BoxModel[] compress(BoxModel[] B) {
	int L=B.length;
	if(L<2) return(B);
	BoxModel C1=new BoxModel(B[L-1]);
	BoxModel C2=new BoxModel(B[L-2]);
	if(C1.COMPLETE==false) return(B);
	if(C2.COMPLETE==false) return(B);
	int mat=BoxMerge.match(C1,C2);
	if(mat==-1) return(B);
	BoxModel CC=BoxMerge.amalgamate(C1,C2);
	CC.COMPLETE=true;
	BoxModel[] C=BoxMerge.insert(B,CC);
	return(C);
    }



    public static BoxModel[] trim(BoxModel[] B,int COUNT) {
	BoxModel[] C=new BoxModel[COUNT];
	for(int i=0;i<COUNT;++i) C[i]=new BoxModel(B[i]);
	return(C);
    }


    public static BoxModel[] insert(BoxModel[] B,BoxModel BB) {
	BoxModel[] C=new BoxModel[B.length-1];
	int count=0;
	for(int i=0;i<C.length-1;++i) {
	       C[i]=new BoxModel(B[i]);
	}
	C[C.length-1]=new BoxModel(BB);
	return(C);
    }


    public static int match(BoxModel[] B,int number) {
	for(int i=0;i<B.length;++i) {
	    if(i!=number) {
		int test=match(B[number],B[i]);
		if(test!=-1) return(i);
	    }
	}
	return(-1);
    }


    public static int match(BoxModel B1,BoxModel B2) {
	if(B1.AGE==0) return(-1);
	if(B1.AGE!=B2.AGE) return(-1);
	if(B1.INDEX[0]!=B2.INDEX[0]) return(-1);
	if(B1.INDEX[1]!=B2.INDEX[1]) return(-1);
	for(int i=0;i<B1.AGE-1;++i) {
	    if(B1.TREE[i]!=B2.TREE[i]) return(-1);
	}
	return(B1.TREE[B1.AGE-1]);
    }



    /**This only works when the boxes match*/

    public static BoxModel amalgamate(BoxModel B1,BoxModel B2) {
	BoxModel C=new BoxModel();
	int n=match(B1,B2);
	if(n==0) C=amalgamate0(B1,B2);
	if(n==1) C=amalgamate0(B2,B1);
	if(n==2) C=amalgamate1(B1,B2);
	if(n==3) C=amalgamate1(B2,B1);
	if(n==-1) return(null);
	C.AGE=B1.AGE-1;
	for(int i=0;i<C.AGE;++i) C.TREE[i]=B1.TREE[i];
	C.INDEX[0]=B1.INDEX[0];
	C.INDEX[1]=B1.INDEX[1];
	return(C);
    }


    public static BoxModel amalgamate0(BoxModel B1,BoxModel B2) {
	BoxModel C=new BoxModel(B1);
	C.H0[0]=new Complex(B1.H0[0]);
	C.H0[1]=new Complex(B2.H0[1]);
	C.H1[0]=new Complex(B1.H1[0]);
	C.H1[1]=new Complex(B2.H1[1]);
	C.V0[0]=new Complex(B1.V0[0]);
	C.V0[1]=new Complex(B1.V0[1]);
	C.V1[0]=new Complex(B2.V1[0]);
	C.V1[1]=new Complex(B2.V1[1]);
	int[] t=new int[100];
	int count=0;
	for(int i=0;i<B1.POINTS;++i) {
	    if(Complex.onSegment(B1.Z[i],B1.V1[0],B1.V1[1])==false) {
		C.Z[count]=new Complex(B1.Z[i]);
		t[count]=0;
		++count;
	    }
	}
	for(int i=0;i<B2.POINTS;++i) {
	    if(Complex.onSegment(B2.Z[i],B2.V0[0],B2.V0[1])==false) {
		C.Z[count]=new Complex(B2.Z[i]);
		t[count]=1;
		++count;
	    }
	}
	C.POINTS=count;
	C.partner=assignPartners(B1,B2,C,t);
	C.COMPLETE=true;
	return(C);
    }


    public static BoxModel amalgamate1(BoxModel B1,BoxModel B2) {
	BoxModel C=new BoxModel(B1);
	C.H0[0]=new Complex(B1.H0[0]);
	C.H0[1]=new Complex(B1.H0[1]);
	C.H1[0]=new Complex(B2.H1[0]);
	C.H1[1]=new Complex(B2.H1[1]);
	C.V0[0]=new Complex(B1.V0[0]);
	C.V0[1]=new Complex(B2.V0[1]);
	C.V1[0]=new Complex(B1.V1[0]);
	C.V1[1]=new Complex(B2.V1[1]);
	int[] t=new int[100];
	int count=0;
	for(int i=0;i<B1.POINTS;++i) {
	    if(Complex.onSegment(B1.Z[i],B1.H1[0],B1.H1[1])==false) {
		C.Z[count]=new Complex(B1.Z[i]);
		t[count]=0;
		++count;
	    }
	}
	for(int i=0;i<B2.POINTS;++i) {
	    if(Complex.onSegment(B2.Z[i],B2.H0[0],B2.H0[1])==false) {
		C.Z[count]=new Complex(B2.Z[i]);
		t[count]=1;
		++count;
	    }
	}
	C.POINTS=count;
	C.partner=assignPartners(B1,B2,C,t);
	C.COMPLETE=true;
	return(C);
    }


    public static int[] assignPartners(BoxModel B1,BoxModel B2,BoxModel C,int[] t) {
	BoxModel[] B={B1,B2};
	int[] partner=new int[100];

	for(int i=0;i<C.POINTS;++i) {
	    int parity=t[i];
	    int j1=index(B[parity],C.Z[i]);
	    int j2=B[parity].partner[j1];
	    boolean test=false;
	    while(test==false) {
		Complex z=B[parity].Z[j2];
	        int j3=index(C,z);
	        if(j3!=-1) {
                  partner[i]=j3;
		  test=true;
		}
		if(test==false) {
	          parity=1-parity;
	          j2=index(B[parity],z);
	          j2=B[parity].partner[j2];
		}
	    }
	}
	return(partner);
    }

    public static int index(BoxModel B,Complex z) {
	for(int i=0;i<B.POINTS;++i) {
	    if(Complex.dist(z,B.Z[i])<.00000001) return(i);
	}
	return(-1);
    }

}