import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;



public class BoxModel {
    Complex[] H0=new Complex[2]; //top horizontal edge
    Complex[] H1=new Complex[2]; //bottom horizontal edge
    Complex[] V0=new Complex[2]; //left vertical edge
    Complex[] V1=new Complex[2]; //right vertical edge
    Complex[] Z=new Complex[400]; //crossing points
    int POINTS;//number of crossing points  
    int LEVEL; //dynamical position
    int DEPTH; //maximum line number
    int P,Q;   //The box parameter is P/Q
    int[] INDEX=new int[2]; //index of ancestor
    int[] TREE=new int[400]; //subdivision history
    int AGE; //number of subdivisions away from parent
    int[] HIGHLIGHT=new int[400];
    boolean COMPLETE;  //are the crossings determined
    int[] partner=new int[400];

    public BoxModel() {}

    public BoxModel(BoxModel A) {
	H0[0]=new Complex(A.H0[0]);
	H1[0]=new Complex(A.H1[0]);
	V0[0]=new Complex(A.V0[0]);
	V1[0]=new Complex(A.V1[0]);
	H0[1]=new Complex(A.H0[1]);
	H1[1]=new Complex(A.H1[1]);
	V0[1]=new Complex(A.V0[1]);
	V1[1]=new Complex(A.V1[1]);
	LEVEL=A.LEVEL;
	DEPTH=A.DEPTH;
	P=A.P;
	Q=A.Q;
	INDEX[0]=A.INDEX[0];
	INDEX[1]=A.INDEX[1];
	POINTS=A.POINTS;
	AGE=A.AGE;
	for(int i=0;i<AGE;++i) TREE[i]=A.TREE[i];
	for(int i=0;i<POINTS;++i) {
             partner[i]=A.partner[i];
	     HIGHLIGHT[i]=A.HIGHLIGHT[i];
	     Z[i]=new Complex(A.Z[i]);
	}
	COMPLETE=A.COMPLETE;
    }



    /**Gets the center of the box*/
    public Complex center() {
	Complex c=new Complex();
	c=Complex.plus(c,H0[0]);
	c=Complex.plus(c,H0[1]);
	c=Complex.plus(c,H1[0]);
	c=Complex.plus(c,H1[1]);
	c.x=c.x/4.0;
	c.y=c.y/4.0;
	return(c);
    }

    /**The smallest box is a square of sidelength 1/(P+Q).
       The routine tests if the given box is such a smallest box.*/

    public boolean isSmall() {
	double d1=Complex.dist(H0[0],H0[1]);
	if(d1>1.5/(P+Q)) return(false);
	double d2=Complex.dist(V0[0],V0[1]);
	if(d2>1.5/(P+Q)) return(false);
	return(true);
    }

    /**makes a general path bounded by the sides of the box.*/

    public GeneralPath makeBox() {
	Complex z1=new Complex(H0[0]);
	Complex z2=new Complex(H1[1]);
	double[] x={z1.x,z2.x};
	double[] y={z1.y,z2.y};
	GeneralPath gp=new GeneralPath();
        gp.moveTo((float)(x[0]),(float)(y[0]));
	gp.lineTo((float)(x[0]),(float)(y[1]));
	gp.lineTo((float)(x[1]),(float)(y[1]));
	gp.lineTo((float)(x[1]),(float)(y[0]));	
	gp.closePath();
	return(gp);
    }

    /**Tests whether the box contains the point, and
       finds the point closest to it. returns -2 if
       the answer is no, and -1 if the answer is yes
       but the box is empty.*/

    public int contains(Complex z) {
	GeneralPath gp=makeBox();
	if(gp.contains(z.x,z.y)==false) return(-2);
	if(POINTS==0) return(-1);
	int index=0;
	double min=1;
	for(int i=0;i<POINTS;++i) {
	    double test=Complex.dist(z,Z[i]);
	    if(min>test) {
		min=test;
		index=i;
	    }
	}
	return(index);
    }

    /**This tests if the box contains the point*/
    public boolean containsWeak(Complex z) {
	GeneralPath gp=makeBox();
	return gp.contains(z.x,z.y);
    }

    /**tests if the box is a square*/

    public boolean isSquare() {
	double d1=Complex.dist(H0[0],H0[1]);
	double d2=Complex.dist(V0[0],V0[1]);
	double d3=Math.abs(d2-d1);
	double e=0.5/(P+Q);
	if(d3<e) return(true);
	return(false);
    }


    public boolean isLit() {
	for(int i=0;i<POINTS;++i) {
	    if(HIGHLIGHT[i]!=0) return(true);
	}
	return(false);
    }


    public void printLineage() {
	System.out.print(INDEX[0]+" "+INDEX[1]+"  ");
	for(int j=0;j<AGE;++j) System.out.print(TREE[j]);
	System.out.println("");
    }


    /**gets points on a specified side of a box. 
       Here is the geometric layout of the labelings:
     
        --3--
        -   -
        0   1
        -   -
        --2--
    */

    public Complex[] sidePoints(int side) {
	int count=0;
	Complex[] Z0=new Complex[POINTS];
	for(int i=0;i<POINTS;++i) {
	    if(Z[i].SIDE==side) {
		Z0[count]=new Complex(Z[i]);
		++count;
	    }
	}
	Z0=ListHelp.trimList(Z0,count);
	return(Z0);
    }


    public boolean isPoint(Complex z) {
	for(int i=0;i<POINTS;++i) {
	    if(Complex.dist(z,Z[i])<.0000001) return(true);
	}
	return(false);
    }



    public int getAri(int side) {
	if(side==0) return(V0[0].ARI);
	if(side==1) return(V1[0].ARI);
	if(side==2) return(H0[0].ARI);
	if(side==3) return(H1[0].ARI);
	return(1/0);
    }




}