import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;



public class BoxProcess {


    /**This routine gets all the crossing points for a BoxModel*/

    public static Complex[] getCross(BoxModel B) {
	return(getCross(B,true));
    }

    public static Complex[] getCross(BoxModel B,boolean cancel) {
	Complex[][] Z={B.V0,B.V1,B.H0,B.H1};  
	for(int i=0;i<4;++i) Z[i][0].SIDE=i;
        Complex[][] W=CrossingModel.getOct(B.LEVEL,0,B.DEPTH,B.P,B.Q);
	Complex[] X=CrossingModel.getCross(Z,W,B.P,B.Q,cancel);
	return(X);
    }

    public static void assignPoints(BoxModel B) {
	if(B.COMPLETE==true) return;
        Complex[] Y=getCross(B);
	for(int u=0;u<Y.length;++u) B.Z[u]=new Complex(Y[u]);
	B.POINTS=Y.length;
	if(B.POINTS<2) B.COMPLETE=true;
	if(B.POINTS==2) {
	    if(checkDouble(B)==false) B.COMPLETE=true;
	}

	if(B.POINTS==2) {
	    B.partner[0]=1;
	    B.partner[1]=0;
	}
	if(B.POINTS>2) {
            B.COMPLETE=false;
	    recognizeCorner(B);
	    if(B.COMPLETE==false) recognizeOrientedCross(B);
	}
    }


    public static boolean checkDouble(BoxModel B) {
	for(int i=0;i<2;++i) {
	if((Math.abs(B.Z[0].x-B.H0[i].x)<.000001)&&
	   (Math.abs(B.Z[1].x-B.H0[i].x)<.000001))
	    return(true);
	}
	for(int i=0;i<2;++i) {
	if((Math.abs(B.Z[0].y-B.V0[i].y)<.000001)&&
	   (Math.abs(B.Z[1].y-B.V0[i].y)<.000001))
	    return(true);
	}
	return(false);
    }


    public static void assignPointsUncharged(BoxModel B) {
        Complex[] Y=getCross(B,false);
	for(int u=0;u<Y.length;++u) B.Z[u]=new Complex(Y[u]);
	B.POINTS=Y.length;
    }

    /**special cases*/

    public static void recognizeCorner(BoxModel B) {
	int n=B.POINTS;
	if(n<4) return;
	int[] x=new int[n];
	int count=0;
	for(int i=0;i<n;++i) {
	    for(int j=i+1;j<n;++j) {
		Complex z1=CrossingModel.discretize(B.Z[i],B.P+B.Q);
		Complex z2=CrossingModel.discretize(B.Z[j],B.P+B.Q);
		double d=Complex.dist(z1,z2);
		if(d<0.99/(B.P+B.Q)) {
		    B.partner[i]=j;
		    B.partner[j]=i;
		    x[i]=1;
		    x[j]=1;
		    count=count+2;
		}
	    }
	}
	if(count<n-2) return;
	B.COMPLETE=true;
	if(count==n) return;
	count=0;
	int[] b=new int[2];
	for(int i=0;i<n;++i) {
	    if(x[i]==0) {
		b[count]=i;
		++count;
	    }
	}
	B.partner[b[0]]=b[1];
	B.partner[b[1]]=b[0];
	return;
    }

    public static int flux(Complex z) {
	int a=z.CROSS;
	int b=z.SIDE;
	int[] t={1,0,0,1};
	for(int i=0;i<4;++i) {
	    if((a==t[i])&&(b==i)) return 0;
	}
	return(1);
    }

    public static boolean adjacent(BoxModel B,int i,int j) {
	Complex z1=B.Z[i];
	Complex z2=B.Z[j]; 
        int[] a=missingIndices(i,j);
	Complex z3=B.Z[a[0]];
	Complex z4=B.Z[a[1]];
	return Vector.checkCross(z1,z2,z3,z4);
    }

    /**only works when there are 4 points in the box*/

    public static int[] adjacentList(BoxModel B) {
	int count=0;
	int[] A=new int[2];
	for(int i=1;i<4;++i) {
	    if(adjacent(B,0,i)==false) {
		A[count]=i;
		++count;
	    }
	}
	return(A);
    }

    public static void recognizeOrientedCross(BoxModel B) {
	if(B.POINTS!=4) return;
	if(fourInRow(B)==true) return;


	int[] A=adjacentList(B); 
        if(A[0]+A[1]<3) return;
	int f0=flux(B.Z[0]);
	int f1=flux(B.Z[A[0]]);
	int f2=flux(B.Z[A[1]]);
	if((f0==f1)&&(f0!=f2)) {
	    B.partner[0]=A[1];
	    B.partner[A[1]]=0;
	    int k=6-A[0]-A[1];
	    B.partner[k]=A[0];
	    B.partner[A[0]]=k;
	    B.COMPLETE=true;   
	    return;
	}
	if((f0!=f1)&&(f0==f2)) {
	    B.partner[0]=A[0];
	    B.partner[A[0]]=0;
	    int k=6-A[0]-A[1];
	    B.partner[k]=A[1];
	    B.partner[A[1]]=k;
	    B.COMPLETE=true;
	    return;
	}
	return;
    }






    public static int[] missingIndices(int i,int j) {
	int count=0;
	int[] a=new int[2];
	for(int k=0;k<4;++k) {
	    if((k!=i)&&(k!=j)) {
		a[count]=k;
		++count;
	    }
	}
	return(a);
    }


    public static int isCross(BoxModel B) {
	if(B.POINTS!=4) return(0);
	boolean coherent=true;
	for(int i=0;i<4;++i) {
	    for(int j=i+1;j<4;++j) {
		Complex z1=B.Z[i];
		Complex z2=B.Z[j];
		if((z1.MASS==z2.MASS)&&(z1.ARI==z2.ARI)) return(0);
		if(z1.CHARGE!=z2.CHARGE) coherent=false;
	    }
	}
	if(coherent==true) return(1);
	return(2);
    }

    public static boolean fourInRow(BoxModel B) {
	for(int i=0;i<3;++i) {
	    if(B.Z[i].MASS!=B.Z[i+1].MASS) return false;
	    if(B.Z[i].ARI!=B.Z[i+1].ARI) return false;
	}
	return(true);
    }

}