import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

/**This class draws the boxes.  Essentially, a box is a
rectangle with some marked points on its boundary. When
there are 2 marked points, they are connected (either by
a segment or a Bezier curve).  When there are 3+ marked
points, they are all connected to the center of the box.
The reason for the complexity in the 2-point case is that
we want the arc to bulge into the box when the two points
are on the same edge.*/

public class BoxRender {


    public static void main(Graphics2D g,Manager M,BoxModel B,int PHASE) {
	if(B.COMPLETE==true) renderComplete(g,M,B,PHASE);
	else renderIncomplete(g,M,B,PHASE);
    }



    public static void renderIncomplete(Graphics2D g,Manager M,BoxModel b,int PHASE) {
	GeneralPath gp=new GeneralPath(); 
        Color[] C=new Color[10];	   
        for(int i=0;i<10;++i) C[i]=M.C.BOX.COLOR.M[i].C;
	gp=b.makeBox();
	gp=M.P.transform(gp);
        g.setColor(C[2]);
	int test=BoxProcess.isCross(b);
	if(test==1) g.setColor(C[3]); 
        if(b.isLit()==true) g.setColor(C[6]);
	if(PHASE==0) g.fill(gp);
	g.setColor(C[4]);  
        if(b.isLit()==true) g.setColor(C[7]);
	if(PHASE==1) g.draw(gp);
	if(PHASE==0) { 
           g.setStroke(new BasicStroke(2));
	   BoxModel B=new BoxModel(b);
	   if(M.C.BOX.BIN.mode==1) B=clean(B);
 	   Complex c=B.center();
	   for(int i=0;i<B.POINTS;++i) {
		 gp.reset();
	         gp.moveTo((float)(B.Z[i].x),(float)(B.Z[i].y));
	         gp.lineTo((float)(c.x),(float)(c.y));  
                 gp=M.P.transform(gp);
	         g.setColor(Color.black); 
                 if(B.HIGHLIGHT[i]==1) g.setColor(C[8]);
                 if(B.HIGHLIGHT[i]==2) g.setColor(C[9]);
	         g.draw(gp);	
	   }
	}
        g.setStroke(new BasicStroke(1));
     }



    public static void renderComplete(Graphics2D g,Manager M,BoxModel b,int PHASE) {
	Color[] C=new Color[10];
	for(int i=0;i<10;++i) C[i]=M.C.BOX.COLOR.M[i].C;
	GeneralPath gp=new GeneralPath();
	int draw=M.C.BOX.DRAW.mode;
	gp=b.makeBox();
	gp=M.P.transform(gp);
        g.setColor(C[0]);
	if(b.POINTS>2) g.setColor(C[1]);
	if(b.isLit()==true) g.setColor(C[6]);
	if(PHASE==0) g.fill(gp);
	g.setColor(C[4]);
	if(b.isLit()==true) g.setColor(C[7]);
	if(PHASE==1) g.draw(gp);
	if(PHASE==0) {
	   g.setStroke(new BasicStroke(2));  
	   BoxModel B=new BoxModel(b);
	   if(M.C.BOX.BIN.mode==1) B=clean(B);
	   for(int i=0;i<B.POINTS;++i) {
	       gp.reset();
               int j=B.partner[i];

	       if((j<B.POINTS)&&(j>i)) {
	         float x0=(float)(B.Z[i].x);
	         float y0=(float)(B.Z[i].y);
	         float x1=(float)(B.Z[j].x);
	         float y1=(float)(B.Z[j].y);
		 Complex z=b.center();
		 float xc=(float)(z.x);
		 float yc=(float)(z.y);
                 gp.moveTo(x0,y0);
	         if(draw==0) gp.lineTo(x1,y1);   
	         if(draw==1) gp.curveTo(x0,y0,xc,yc,x1,y1);   
                 gp=M.P.transform(gp);
                 g.setColor(C[5]);
	         if(B.HIGHLIGHT[i]==1) g.setColor(C[8]);
	         if(B.HIGHLIGHT[j]==1) g.setColor(C[8]);
	         if(B.HIGHLIGHT[i]==2) g.setColor(C[9]);
	         if(B.HIGHLIGHT[j]==2) g.setColor(C[9]);
	         g.draw(gp);
	       }
	   }
	}
	g.setStroke(new BasicStroke(1));  
     }

    public static BoxModel clean(BoxModel A) {
	BoxModel B=new BoxModel(A);
	int N=A.P+A.Q;
	for(int i=0;i<A.POINTS;++i) {
	    B.Z[i]=CrossingModel.discretize(A.Z[i],N);

	    if(Complex.dist(B.Z[i],B.H0[0])<.25/N) {
		B.Z[i].x=B.Z[i].x+0.5/N; 
	    }
	    if(Complex.dist(B.Z[i],B.H0[1])<.25/N) {
		B.Z[i].x=B.Z[i].x-0.5/N;
	    }
            if(Complex.dist(B.Z[i],B.H1[0])<.25/N) {
	       B.Z[i].x=B.Z[i].x+0.5/N;	
	    }
	    if(Complex.dist(B.Z[i],B.H1[1])<.25/N) {
	       B.Z[i].x=B.Z[i].x-0.5/N;	
	    }
	}
	return(B);
    }


}