import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;



public class BoxSubdivision {


    /**This chops off the last member of the list*/
    public static BoxModel[] chop(BoxModel[] BB) {
        int L=BB.length-1;
	BoxModel[] B=new BoxModel[L];
	for(int i=0;i<L;++i) B[i]=new BoxModel(BB[i]);
	return(B);
    }

    /**This works with the DFS search.  It swaps the
       last two boxes on the list if the last box happens
       to be complete already.*/

    public static BoxModel[] expose(BoxModel[] B) {
	int L=B.length;
	if(L<2) return(B);
	BoxModel C1=new BoxModel(B[L-1]);
	BoxModel C2=new BoxModel(B[L-2]);
	if(C1.COMPLETE==true) {
	    B[L-1]=new BoxModel(C2);
	    B[L-2]=new BoxModel(C1);
	}
	return(B);
    }

    /**Depth first search*/

    public static BoxModel[] subdivideDFS(int sub,BoxModel[] BB) {
        int L=BB.length-1;
	BoxModel[] TEMP=subdivide(sub,BB[L]);
	int t=TEMP.length;
	BoxModel[] B=new BoxModel[L+t];
	for(int i=0;i<L;++i) B[i]=new BoxModel(BB[i]);
	for(int i=L;i<t+L;++i) B[i]=new BoxModel(TEMP[i-L]);
	return(B);
    }

    public static BoxModel[] subdivide(int sub,BoxModel B) {
	if(sub==0) return(subdivideGreedy(B));
	return(subdivideSymmetric(B));
    }

    public static BoxModel[] subdivideSymmetric(BoxModel B) {
	double d1=Complex.dist(B.H0[0],B.H0[1]);
	double d2=Complex.dist(B.V0[0],B.V0[1]);
	if(d2<d1-.000000001) return subdivideV(B);
	if(d1<d2-.000000001) return subdivideH(B);
	return subdivideTotal(B);
    }

    public static BoxModel[] subdivideGreedy(BoxModel B) {
	double d1=Complex.dist(B.H0[0],B.H0[1]);
	double d2=Complex.dist(B.V0[0],B.V0[1]);
	if(d2<d1+.000000001) return subdivideVOnce(B);
	return subdivideHOnce(B);
    }


    /**Finds the relevant offset*/


    public static int[] getIntermediate(BoxModel A,double s,double h0,double h1) {
	double t=0.25/(A.P+A.Q);
	if(h1-h0<5*t) return(null);
	int[] a={0,0};
	for(int i=0;i<A.P+A.Q;++i) {
	  double x0=i*s-Math.floor(i*s);
	  double x1=1-x0;
	  int test=0;
	  a[1]=i;
	  if((x0>h0+t)&&(x0<h1-t)) {
	      a[0]=0;
	      ++test;
	  }
	  if((x1>h0+t)&&(x1<h1-t)) {
	      a[0]=1;
	      ++test;
	  }
	  if(test>0) return(a);
	}
	return(null);
    }

    /**subdivide both*/

    public static BoxModel[] subdivideTotal(BoxModel A) {
	BoxModel[] B=subdivideV(A);
	BoxModel[] C=new BoxModel[9];
	int count=0;
	for(int i=0;i<B.length;++i) {
	    BoxModel[] BB=subdivideH(B[i]);
	    for(int j=0;j<BB.length;++j) {
		C[count]=new BoxModel(BB[j]);
		++count;
	    }
	}
	BoxModel[] D=new BoxModel[count];
	for(int i=0;i<count;++i) D[i]=new BoxModel(C[i]);
	return(D);
    }


    /**subdivides horizontally*/

    public static BoxModel[] subdivideH(BoxModel A) {
	BoxModel[] B=subdivideHOnce(A);
	double d0=Complex.dist(B[0].V0[0],B[0].V0[1]);
	double d1=Complex.dist(B[1].V0[0],B[1].V0[1]);
	if(d0>d1) {
	    BoxModel[] C=subdivideHOnce(B[0]);  
            if(C==null) return(B);
	    BoxModel[] D={B[1],C[0],C[1]};
	    return(D);
	}
	else {
            BoxModel[] C=subdivideHOnce(B[1]); 
            if(C==null) return(B);
	    BoxModel[] D={B[0],C[0],C[1]};
	    return(D);
	}
    }



    public static BoxModel[] subdivideHOnce(BoxModel A) {
	double s=MathRational.gap(A.P,A.Q);
        double h0=A.V0[0].y;
	double h1=A.V0[1].y;
	int[] a=getIntermediate(A,s,h0,h1);
	if(a==null) return null;
	double t=a[1]*s;
	t=t-Math.floor(t);
	if(a[0]==1) t=1-t;
	double fill=a[1]*s-Math.floor(a[1]*s);
	BoxModel[] B=new BoxModel[2];
	B[0]=insertH0(A,t,a[1],a[0]+2);
	B[1]=insertH1(A,t,a[1],a[0]+2);
	B[0].AGE=A.AGE+1;
	B[1].AGE=A.AGE+1;
	B[0].TREE[A.AGE]=2;
	B[1].TREE[A.AGE]=3;
	return(B);
    }

    /**subdivides vertically*/

    public static BoxModel[] subdivideV(BoxModel A) {
	BoxModel[] B=subdivideVOnce(A);
	double d0=Complex.dist(B[0].H0[0],B[0].H0[1]);
	double d1=Complex.dist(B[1].H0[0],B[1].H0[1]);
	if(d0>d1) {
	    BoxModel[] C=subdivideVOnce(B[0]);
            if(C==null) return(B);
	    BoxModel[] D={B[1],C[0],C[1]};
	    return(D);
	}
	else {
            BoxModel[] C=subdivideVOnce(B[1]);
	    if(C==null) return(B);
	    BoxModel[] D={B[0],C[0],C[1]};
	    return(D);
	}
    }


    public static BoxModel[] subdivideVOnce(BoxModel A) {
	double s=MathRational.gap(A.P,A.Q);
        double v0=A.H0[0].x-A.LEVEL;
	double v1=A.H0[1].x-A.LEVEL;
	int[] a=getIntermediate(A,s,v0,v1);
	if(a==null) return null;
	double t=a[1]*s;
	t=t-Math.floor(t);
	if(a[0]==1) t=1-t;
	double fill=a[1]*s-Math.floor(a[1]*s);
	BoxModel[] B=new BoxModel[2];
	B[0]=insertV0(A,t,a[1],a[0]);
	B[1]=insertV1(A,t,a[1],a[0]);
	B[0].AGE=A.AGE+1;
	B[1].AGE=A.AGE+1;
	B[0].TREE[A.AGE]=0;
	B[1].TREE[A.AGE]=1;
	return(B);
    }

    /**These routines help with the subdivision process*/



    public static BoxModel insertH1(BoxModel A,double h,int h0,int h1) {
	BoxModel B=reflectV(A);
	B=insertH0(B,h,h0,h1);
	B=reflectV(B);
	return(B);
    }


    public static BoxModel insertH0(BoxModel A,double hh,int h0,int h1) {
	BoxModel B=new BoxModel(A);
	double x=A.H0[0].x;
	double y=A.H0[0].y;
	double h=hh;
	double v=A.H0[1].x;


	B.H0[0]=new Complex(x,y);
	B.H0[1]=new Complex(v,y);
	B.H1[0]=new Complex(x,h);
	B.H1[1]=new Complex(v,h);

	B.V0[0]=new Complex(x,y);
	B.V0[1]=new Complex(x,h);
	B.V1[0]=new Complex(v,y);
	B.V1[1]=new Complex(v,h);

	B.H0[0].MASS=A.H0[0].MASS;
	B.H0[0].ARI=A.H0[0].ARI;
	B.H1[0].MASS=h0;
	B.H1[0].ARI=h1;
	B.V0[0].MASS=A.V0[0].MASS;
	B.V0[0].ARI=A.V0[0].ARI;
	B.V1[0].MASS=A.V1[0].MASS;
	B.V1[0].ARI=A.V1[0].ARI;



	int[] DEP={B.H0[0].MASS,B.H1[0].MASS,B.V0[0].MASS,B.V1[0].MASS};
	int dep=0;
	for(int i=0;i<4;++i) {
	    if(dep<DEP[i]) dep=DEP[i];
	}
	B.DEPTH=dep;
	return(B);
    }


    public static BoxModel insertV1(BoxModel A,double v,int v0,int v1) {
	BoxModel B=reflectH(A);
	B=insertV0(B,v,v0,v1);
	B=reflectH(B);
	return(B);
    }

    public static BoxModel insertV0(BoxModel A,double vv,int v0,int v1) {
	BoxModel B=new BoxModel(A);
	double x=A.V0[0].x;
	double y=A.V0[0].y;
	double h=A.V0[1].y;
	double v=vv+A.LEVEL;;
	B.H0[0]=new Complex(x,y);
	B.H0[1]=new Complex(v,y);
	B.H1[0]=new Complex(x,h);
	B.H1[1]=new Complex(v,h);
	B.V0[0]=new Complex(x,y);
	B.V0[1]=new Complex(x,h);
	B.V1[0]=new Complex(v,y);
	B.V1[1]=new Complex(v,h);

	B.H0[0].MASS=A.H0[0].MASS;
	B.H0[0].ARI=A.H0[0].ARI;
	B.H1[0].MASS=A.H1[0].MASS;
	B.H1[0].ARI=A.H1[0].ARI;
	B.V0[0].MASS=A.V0[0].MASS;
	B.V0[0].ARI=A.V0[0].ARI;
	B.V1[0].MASS=v0;
	B.V1[0].ARI=v1;


	int[] DEP={B.H0[0].MASS,B.H1[0].MASS,B.V0[0].MASS,B.V1[0].MASS};
	int dep=0;
	for(int i=0;i<4;++i) {
	    if(dep<DEP[i]) dep=DEP[i];
	}
	B.DEPTH=dep;
	return(B);
    }




    public static BoxModel reflectH(BoxModel A) {
	BoxModel B=new BoxModel(A);
	B.H0[0]=new Complex(A.H0[1]);
	B.H0[1]=new Complex(A.H0[0]);
	B.H1[0]=new Complex(A.H1[1]);
	B.H1[1]=new Complex(A.H1[0]);

	B.V0[0]=new Complex(A.V1[0]);
	B.V0[1]=new Complex(A.V1[1]);
	B.V1[0]=new Complex(A.V0[0]);
	B.V1[1]=new Complex(A.V0[1]);

	B.H0[0].MASS=A.H0[0].MASS;
	B.H0[0].ARI=A.H0[0].ARI;
	B.H1[0].MASS=A.H1[0].MASS;
	B.H1[0].ARI=A.H1[0].ARI;

	B.V0[0].MASS=A.V1[0].MASS;
	B.V0[0].ARI=A.V1[0].ARI;
	B.V1[0].MASS=A.V0[0].MASS;
	B.V1[0].ARI=A.V0[0].ARI;

	return(B);
    }


    public static BoxModel reflectV(BoxModel A) {
	BoxModel B=new BoxModel(A);
	B.V0[0]=new Complex(A.V0[1]);
	B.V0[1]=new Complex(A.V0[0]);
	B.V1[0]=new Complex(A.V1[1]);
	B.V1[1]=new Complex(A.V1[0]);

	B.H0[0]=new Complex(A.H1[0]);
	B.H0[1]=new Complex(A.H1[1]);
	B.H1[0]=new Complex(A.H0[0]);
	B.H1[1]=new Complex(A.H0[1]);

	B.V0[0].MASS=A.V0[0].MASS;
	B.V0[0].ARI=A.V0[0].ARI;
	B.V1[0].MASS=A.V1[0].MASS;
	B.V1[0].ARI=A.V1[0].ARI;

	B.H0[0].MASS=A.H1[0].MASS;
	B.H0[0].ARI=A.H1[0].ARI;
	B.H1[0].MASS=A.H0[0].MASS;
	B.H1[0].ARI=A.H0[0].ARI;
	return(B);
    }


}