import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;



public class BoxTracer {



    public static int[][] orbit(BoxModel[] B,int COUNT,int number,int choice) {
	if(B[number].POINTS==0) return(null);
	boolean test=false;
	int[] n={number,choice};
	int count=1;
	int[][] X=new int[2*COUNT][3];
	X[0][0]=number;
	X[0][1]=choice;

	while((count<2*COUNT-1)&&(test==false)) {
	    int[] n2=successor(B,COUNT,n[0],n[1]);
	    if(n2==null) {
		successorDebug(B,COUNT,n[0],n[1]);
                return(null);
	    }
            X[count][0]=n2[0];  
            X[count][1]=n2[1];
	    n[1]=partner(B[n2[0]],n2[1]);
	    if(n[1]==-1) return(null);
            X[count][2]=n[1];
	    ++count;
	    n[0]=n2[0];
	    if((n[0]==number)&&(n[1]==choice)) test=true;
	}
	int[][] Y=new int[count][3];
	for(int i=0;i<count;++i) {
             Y[i][0]=X[i][0];
             Y[i][1]=X[i][1];
             Y[i][2]=X[i][2];
	}
	return(Y);
    }
    
    /**This finds the partner point even in the case when it is not
       explicitly determined.*/

    public static int partner(BoxModel B,int choice) {
	if(B.COMPLETE==true) return(B.partner[choice]);
	if(BoxProcess.isCross(B)==1) return(-1);
	int m=B.POINTS;
	int[] A=new int[m];
	for(int i=0;i<m;++i) {
	    for(int j=i+1;j<m;++j) {
		if((B.Z[i].MASS==B.Z[j].MASS)&&(B.Z[i].ARI==B.Z[j].ARI)) {
		    A[i]=1;
		    A[j]=1;
		}
	    }
	}
	for(int i=0;i<m;++i) {
	    if((i!=choice)&&(A[i]==0)) return(i);
	}
	return(-1);
    }


    /**This finds the box that matches along the given point*/
    public static int[] successor(BoxModel[] B,int COUNT,int number,int choice) {
	Complex z=new Complex(B[number].Z[choice]);
	for(int i=0;i<COUNT;++i) {
	    if((i!=number)&&(B[i].POINTS!=0)) {
		for(int j=0;j<B[i].POINTS;++j) {
		   Complex w=new Complex(B[i].Z[j]);
		   if(Complex.dist(z,w)<.0000000001) {
		      int[] I={i,j};
		      return(I);
		   }
		}
	    }
	}
	return(null);
    }


    public static int[] successorDebug(BoxModel[] B,int COUNT,int number,int choice) {
	System.out.println("debug successor");
	System.out.println(number+" "+choice);

	Complex z=new Complex(B[number].Z[choice]);
	z.print();	
            for(int i=0;i<COUNT;++i) {
	    if((i!=number)&&(B[i].POINTS!=0)) {
		for(int j=0;j<B[i].POINTS;++j) {
		   Complex w=new Complex(B[i].Z[j]);
		   if(Complex.dist(z,w)<.0000000001) {
		      int[] I={i,j};
		      return(I);
		   }
		}
	    }
	}
	return(null);
    }


    public static void clean(BoxModel[] B,int COUNT) {
	for(int i=0;i<COUNT;++i) {
	    for(int j=0;j<B[i].POINTS;++j) {
              B[i].HIGHLIGHT[j]=0;
	    }
	}
    }

}