import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    /**This file does the bounce-tracking for the local
       box subdivision rule*/

public class ClusterBounce {

    public static Complex[] main(BoxModel[][] B,Complex[] Z) {
	Complex[] LIST={};
	for(int i=0;i<8;++i) {
	    for(int j=0;j<4;++j) {
		LIST=ListHelp.mergeList(LIST,bounce(B,Z,i,j));
	    }
	}
 	LIST=ListHelp.irredundantList(LIST);
	return(LIST);
    }



    public static Complex[] bounce(BoxModel[][] B,Complex[] Z0,int c1,int c2) {
	Complex[] Z=ClusterSupport.duplicate(Z0);
	Complex[] W=new Complex[2*Z.length];
	int count=0;
	for(int i=0;i<Z.length;++i) {

	    Complex z=bounce(B,Z[i],c1,c2);
	    if(z!=null) {
		W[count]=new Complex(z);
		++count;
	    }
	}
	W=ListHelp.trimList(W,count);
	return(W);
    }

    public static Complex bounce(BoxModel[][] B,Complex Z,int c1,int c2) {
	int p=B[0][0].P;
	int q=B[0][0].Q;
	Complex[][] MIRROR=ClusterSupport.getAri(B);
	Complex[][] TARGET=ClusterMain.getAri(B);
	Complex[][] L={MIRROR[c1],TARGET[c2]};
	return bounce(B,Z,L,p,q);
    }


    public static Complex bounce(BoxModel[][] B,Complex Z0,Complex[][] L,int p,int q) {
	if(Complex.onSegment(Z0,L[0][0],L[0][1])==true) return(null);
	Complex[] LINE1=ClusterSupport.line(Z0,Z0.OCT/2,p,q);
	Complex Z1=Vector.findCross(LINE1[0],LINE1[1],L[0][0],L[0][1]);
	if(Complex.onSegment(Z1,L[0][0],L[0][1])==false) return(null);
	if(BoxCombinatorics.interact(L[0][0].ARI,Z0.OCT)==true) return(null);
	int oct1=BoxCombinatorics.partner(false,L[0][0].ARI,Z0.OCT);
	Complex[] LINE2=ClusterSupport.line(Z1,oct1/2,p,q);
	Complex Z2=Vector.findCross(LINE2[0],LINE2[1],L[1][0],L[1][1]);
	if(Complex.onSegment(Z2,L[1][0],L[1][1])==false) return(null);
	if(BoxCombinatorics.interact(L[1][0].ARI,oct1)==false) return(null);
	Z2.OCT=oct1;
	Z2.CHARGE=Z0.CHARGE;
	Z2.ARI=L[1][0].ARI;
	return(Z2);
    }

}


