import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


/**This file controls the arithmetic graph window.*/



public class ClusterCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Complex SOURCE;
    BoxModel[][] BOX=new BoxModel[3][3];
    BoxModel[][] BOX2=new BoxModel[5][5];
    boolean FULL;
    Point JX;
    GeneralPath RIM;
    ListenSquare CONTROL;
    SelectInteger DOT,TAGS;
    Lever SPEED;
    ControlPanel POINTS,OCT,ARI,SCRATCH;


    public ClusterCanvas() {
        addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);
      	setScales(255,0,255);
        SOURCE=new Complex(0,0);
	JX=new Point(0,0);
	RIM=new GeneralPath();
	CONTROL=new ListenSquare(0,0,440,80);
	DOT=new SelectInteger(5,5,40,20,5,0,10,1);
	TAGS=new SelectInteger(5,35,40,20,8,0,8,1);
	SPEED=new Lever(110,65,5,10);
	FULL=false;
	setPanels();
    }


    public void setPanels() {
	Color[] C0={new Color(200,0,200),Color.white,Color.white,Color.black,Color.red};

	 String[] PointsString={"old","new guess","new check","points"};
	 int[] PointsState={0,1,1};
         POINTS=new ControlPanel(C0,PointsString,PointsState,3);

	 String[] AriString={"old","new","ari"};
	 int[] AriState={1,1};
         ARI=new ControlPanel(C0,AriString,AriState,2);

	 String[] OctString={"old","new","oct"};
	 int[] OctState={0,0};
         OCT=new ControlPanel(C0,OctString,OctState,2);

	 String[] ScratchString={"direct good", "direct bad ","bounce","scratch"};
	 int[] ScratchState={0,0,0};
         SCRATCH=new ControlPanel(C0,ScratchString,ScratchState,3);
    }



    public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(new Color(0,0,50));
      g.fillRect(0,0,getWidth(),getHeight());
      if(FULL==true) {
        g.fillRect(0,0,this.getWidth(),this.getHeight());
        if(ARI.L[0].on==1) ClusterRender.ariOld(g,this);
        if(ARI.L[1].on==1) ClusterRender.ariNew(g,this);
        if(OCT.L[0].on==1) ClusterRender.octOld(g,this);
        if(OCT.L[1].on==1) ClusterRender.octNew(g,this);
        if(POINTS.L[0].on==1) ClusterRender.pointsOld(g,this);
        if(POINTS.L[1].on==1) ClusterRender.pointsGuess(g,this);
        if(POINTS.L[2].on==1) ClusterRender.pointsCheck(g,this);
	ClusterRender.pointsScratch(g,this);
	ClusterRender.zone(g,this);
      }
      drawControls(g);
      g.drawRect(0,0,this.getWidth()-1,this.getHeight()-1);
    }


    public void drawControls(Graphics2D g) {
      CONTROL.w=getWidth()-1; 
      CONTROL.render(g,new Color(110,0,110));
      DOT.render(g,Color.red,Color.white,Color.white);
      TAGS.render(g,Color.red,Color.white,Color.white);
      SPEED.render(g,"speed",new Color(200,0,200));
      g.setColor(Color.white);
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      g.drawString("dot size",70,19);
      g.drawString("tag",70,49);
      POINTS.render(g,260,0,75);
      ARI.render(g,150,0,50);
      OCT.render(g,205,0,50);
      SCRATCH.render(g,340,0,90);
    }

    public void generate() {
      Complex z=new Complex(M.P.SOURCE);
      int depth1=M.C.GRID.DEPTH1.val;
      int depth3=M.C.GRID.DEPTH3.val;
      int level=(int)(Math.floor(z.x));
      int p=M.p();
      int q=M.q();

      BoxModel[] B=BoxGenerate.getBoxModels(level,depth3,p,q);
      for(int i=0;i<B.length;++i) {
	  if(B[i].containsWeak(z)==true) setBoxesMain(B,B[i].INDEX[0],B[i].INDEX[1]);
      }

      B=BoxGenerate.getBoxModels(level,depth1,p,q);
      for(int i=0;i<B.length;++i) {
	  if(B[i].containsWeak(z)==true) setBoxesAux(B,B[i].INDEX[0],B[i].INDEX[1]);
      }
    }


    public void setBoxesMain(BoxModel[] B,int i0,int j0) {
	if(i0==-1) return;
        int count=0;
	for(int i=i0;i<=i0+2;++i) {
	      for(int j=j0;j<=j0+2;++j) {
		  for(int k=0;k<B.length;++k) {
		      if((B[k].INDEX[0]==i)&&(B[k].INDEX[1]==j)) {
			  int i1=i-i0;
			  int j1=j-j0;
			  BOX[i1][j1]=new BoxModel(B[k]); 
                          BoxProcess.assignPointsUncharged(BOX[i1][j1]);
			  ++count;
		      }
		  }
	      }
	}
	if(count<9) FULL=false;
	if(count==9) FULL=true;
	BoxModel b=ClusterSupport.outerEdges(BOX);
	RIM=b.makeBox();
	GraphicsHelp.scaleNicely(this);
    }


    public void setBoxesAux(BoxModel[] B,int i0,int j0) {
	if(i0==-1) return;
        int count=0;
	for(int i=i0;i<=i0+4;++i) {
	      for(int j=j0;j<=j0+4;++j) {
		  for(int k=0;k<B.length;++k) {
		      if((B[k].INDEX[0]==i)&&(B[k].INDEX[1]==j)) {
			  int i1=i-i0;
			  int j1=j-j0;
			  BOX2[i1][j1]=new BoxModel(B[k]); 
                          BoxProcess.assignPoints(BOX2[i1][j1]);
			  ++count;
		      }
		  }
	      }
	}
    }


   public void mouseDragged(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {}
   public void mousePressed(MouseEvent e) {}
   public void mouseReleased(MouseEvent e) {}
   public void mouseEntered(MouseEvent e) {
      requestFocus();
   }

   public void mouseClicked(MouseEvent e) { 
       MouseData J=MouseData.process(e);
       doMouseClick(J.X,J.mode);
       repaint();
   }

   public void mouseMoved(MouseEvent e) {
       try {MouseData J=MouseData.process(e);
	   JX=J.X; }
       catch (Exception ee) {}
   }

   public void doMouseClick(Point X,int mode) { 
       if(CONTROL.inside(X)==1) {
	   DOT.modify(X);
	   TAGS.modify(X);
	   SPEED.process(X);
	   POINTS.toggle(X);
	   ARI.toggle(X);
	   OCT.toggle(X);
	   SCRATCH.toggle(X);
       }
       else{
        if(mode==1)  scaleUp(X,0);
        if(mode==3)  scaleUp(X,1);
       }
	repaint();
   }

    public void keyTyped(KeyEvent e) {

	char ch=e.getKeyChar();
	repaint();
    }
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}
