import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;



public class ClusterClean {


    /**This eliminates redundancies when the point charges are the same,
       and eliminates both points when the charges are opposite.*/

    public static Complex[] main(Complex[] Z,int N) {
	int n=Z.length;
	Complex[] W=new Complex[n];
	int count=0;
	for(int i=0;i<n;++i) {
	    boolean test=false;
	    for(int j=0;j<n;++j) {
		boolean test2=false;
		if((i!=j)&&(Z[i].CHARGE!=Z[j].CHARGE)) test2=true;
		if((i< j)&&(Z[i].CHARGE==Z[j].CHARGE)) test2=true;
		if(test2==true) test2=cancel(Z[i],Z[j],N);
		if(test2==true) test=true;
	    }
	    if(test==false) {
		W[count]=new Complex(Z[i]);
		++count;
	    }
	}
	W=ListHelp.trimList(W,count);
	return(W);
    }

    public static boolean cancel(Complex Z1,Complex Z2,int N) {
	if(Z1.ARI!=Z2.ARI) return(false);
        Complex W1=discretize(Z1,N);
	Complex W2=discretize(Z2,N);
	if(Complex.dist(W1,W2)>.9999/N) return(false);
	return(true);
    }

    public static Complex discretize(Complex Z,int N) {
	Complex W=new Complex(Z);
	if(Z.ARI>1) W.x=discretize(Z.x,N);
        if(Z.ARI<2) W.y=discretize(Z.y,N);
	return(W);
    }


    public static double discretize(double t,int N) {
	double s1=N*t;
	double s2=Math.floor(s1+.5);
	if(Math.abs(s1-s2)<.00000001) {
            return(s2/N);
	}
	s2=Math.floor(s1);
	s2=(s2+.5)/N;
	return(s2);
    }




}
