import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    /**This file does the direct hitting for the
       box subdivision rule*/

public class ClusterDirect {

    public static Complex[] main(BoxModel[][] B,Complex[] Z,boolean interact) {
	Complex[] LIST={};
	for(int j=0;j<4;++j) 
           LIST=ListHelp.mergeList(LIST,direct(B,Z,j,interact));
 	LIST=ListHelp.irredundantList(LIST);
	return(LIST);
    }


    public static Complex[] direct(BoxModel[][] B,Complex[] Z0,int j,boolean interact) {
	Complex[][] TARGET=ClusterMain.getAri(B);
	Complex[] Z=ClusterSupport.duplicate(Z0);
	Complex[] W=new Complex[2*Z.length];
	int count=0;
	for(int i=0;i<Z.length;++i) {
	    Complex z=direct(B,Z[i],TARGET[j],interact);
	    if(z!=null) {
		W[count]=new Complex(z);
		++count;
	    }
	}
	W=ListHelp.trimList(W,count);
	return(W);
    }

    public static Complex direct(BoxModel[][] B,Complex Z0,Complex[] L,boolean interact) {
	int p=B[0][0].P;
	int q=B[0][0].Q;
	Complex[] LINE1=ClusterSupport.line(Z0,Z0.OCT/2,p,q);
	Complex Z1=Vector.findCross(LINE1[0],LINE1[1],L[0],L[1]);
	if(Complex.onSegment(Z1,L[0],L[1])==false) return(null);
	if(BoxCombinatorics.interact(L[0].ARI,Z0.OCT)!=interact) return(null);
	Z1.OCT=Z0.OCT;
	Z1.CHARGE=Z0.CHARGE;
	Z1.ARI=L[0].ARI;
	return(Z1);
    }

}


