import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;


public class ClusterMain {

    public static Complex[] getPointsOld(BoxModel[][] B) {
	Complex[] NEW={};
	Complex[] LIST={};
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		NEW=ListHelp.trimList(B[i][j].Z,B[i][j].POINTS);
		LIST=ListHelp.mergeList(LIST,NEW);
	    }
	}
	LIST=ListHelp.irredundantList(LIST);
	return(LIST);
    }

    public static Complex[][] getLinesOld(ClusterCanvas S) {
	int p=S.BOX[0][0].P;
	int q=S.BOX[0][0].Q;
	Complex[] Z=getPointsOld(S.BOX);
	Complex[][] W=getOct(Z,p,q);
	W=ClusterSupport.trim(S.BOX,W);
	return(W);
    }

    public static Complex[] getPointsNew(ClusterCanvas S) {
	int p=S.BOX[0][0].P;
	int q=S.BOX[0][0].Q;
	Complex[] F=getPointsOld(S.BOX);
	Complex[] X1=ClusterDirect.main(S.BOX,F,true);
	Complex[] Y1=ClusterDirect.main(S.BOX,F,false);
	Complex[] X2=ClusterBounce.main(S.BOX,F);
	Complex[] X3=ListHelp.mergeList(X1,ListHelp.omit(X2,Y1));
	Complex[] X4=ClusterClean.main(X3,p+q);
	return(X4);
    }

    public static Complex[] pointsScratch(int choice,ClusterCanvas S) {
	int p=S.BOX[0][0].P;
	int q=S.BOX[0][0].Q;
	Complex[] F=getPointsOld(S.BOX);
	Complex[] X1=ClusterDirect.main(S.BOX,F,true);
	Complex[] Y1=ClusterDirect.main(S.BOX,F,false);
	Complex[] X2=ClusterBounce.main(S.BOX,F);
	if(choice==0) return(X1);
	if(choice==1) return(Y1);
	if(choice==2) return(X2);
	return(null);
    }


    public static Complex[][] getLinesNew(ClusterCanvas S) {
	int p=S.BOX[0][0].P;
	int q=S.BOX[0][0].Q;
	Complex[] Z=getPointsNew(S);
	Complex[][] W=getOct(Z,p,q);
	W=ClusterSupport.trim(S.BOX,W);
	return(W);
    }


    public static Complex[][] getOct(Complex[] Z0,int p,int q) {
	Complex[][] Z1=new Complex[Z0.length*2][2];
	int count=0;
	for(int i=0;i<Z0.length;++i) {
	    Complex z=Z0[i];
	    int oct0=z.OCT;
            int oct1=BoxCombinatorics.partner(true,z.ARI,oct0); 
            int choice0=oct0/2;
	    int choice1=oct1/2;
	    Z1[count]=ClusterSupport.line(z,choice0,p,q);
            Z1[count][0].ARI=z.ARI; 
            Z1[count][0].CHARGE=z.CHARGE;
	    Z1[count][0].OCT=oct0;  
	    ++count;
            Z1[count]=ClusterSupport.line(z,choice1,p,q);
	    Z1[count][0].OCT=oct1;
	    Z1[count][0].CHARGE=z.CHARGE;
	    Z1[count][0].ARI=z.ARI;
	    ++count;
	}
	Z1=ListHelp.trimList(Z1,count);
	Z1=ListHelp.irredundantList(Z1);
	return(Z1);
    }


    /**This gets the new lines*/

    public static Complex[][] getAri(BoxModel[][] B) {
	Complex[][] Z={getLeft(B),getRight(B),getBot(B),getTop(B)};
	return(Z);
    }

    public static Complex[] getBot(BoxModel[][] B) {
	double x1=B[0][0].H0[0].x;
	double x2=B[2][0].H0[1].x;
	double y1=B[0][0].H0[0].y;
	double y2=B[0][0].H1[0].y;
	double y=2*y2-y1;
	Complex z1=new Complex(x1,y);
	Complex z2=new Complex(x2,y);
	z1.ARI=B[0][0].H1[0].ARI;
	Complex[] Z={z1,z2};
	return(Z);
    }


    public static Complex[] getTop(BoxModel[][] B) {
	double x1=B[0][0].H0[0].x;
	double x2=B[2][0].H0[1].x;
	double y1=B[0][2].H1[0].y;
	double y2=B[0][1].H1[0].y;
	double y=2*y2-y1;
	Complex z1=new Complex(x1,y);
	Complex z2=new Complex(x2,y);
	z1.ARI=B[2][2].H0[0].ARI;
	Complex[] Z={z1,z2};
	return(Z);
    }


    public static Complex[] getLeft(BoxModel[][] B) {
	double y1=B[0][0].V0[0].y;
	double y2=B[0][2].V0[1].y;
	double x1=B[0][0].V0[0].x;
	double x2=B[1][0].V0[0].x;
	double x=2*x2-x1;
	Complex z1=new Complex(x,y1);
	Complex z2=new Complex(x,y2);
	z1.ARI=B[0][0].V1[0].ARI;
	Complex[] Z={z1,z2};
	return(Z);
    }


    public static Complex[] getRight(BoxModel[][] B) {
	double y1=B[0][0].V0[0].y;
	double y2=B[0][2].V0[1].y;
	double x1=B[2][0].V1[0].x;
	double x2=B[1][0].V1[0].x;
	double x=2*x2-x1;
	Complex z1=new Complex(x,y1);
	Complex z2=new Complex(x,y2);
	z1.ARI=B[2][2].V0[0].ARI;
	Complex[] Z={z1,z2};
	return(Z);
    }
}

