import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

    /**These routines are for the scratch canvas.*/

public class ClusterRender {



    /**point drawing routines*/

    public static void pointsOld(Graphics2D g,ClusterCanvas S) {
	GeneralPath gp=new GeneralPath(); 
	Complex[] Z=ClusterMain.getPointsOld(S.BOX);
	for(int i=0;i<Z.length;++i) {  
	   gp=GraphicsHelp.makeDot(Z[i]);
	   gp=S.transform(gp);
	   g.setStroke(new BasicStroke(3));
	   g.setColor(new Color(80,130,255));
	   if(Z[i].CHARGE==1) g.setColor(new Color(255,140,50));
	   g.draw(gp);
	}
	g.setStroke(new BasicStroke(1));
    }


    public static void pointsGuess(Graphics2D g,ClusterCanvas S) {
	GeneralPath gp=new GeneralPath(); 
	Complex[] Z=ClusterMain.getPointsNew(S);
	for(int i=0;i<Z.length;++i) {  
	   gp=GraphicsHelp.makeDot(Z[i]);
	   gp=S.transform(gp);
	   g.setStroke(new BasicStroke(3));
	   g.setColor(new Color(80,130,255));
	   if(Z[i].CHARGE==1) g.setColor(new Color(255,140,50));
	   g.draw(gp);
	}
	g.setStroke(new BasicStroke(1));
    }


    public static void pointsCheck(Graphics2D g,ClusterCanvas S) {
	Complex[] Z=pointsCheck(S.BOX,S.BOX2);
	GeneralPath gp=new GeneralPath();
	Complex[][] L=ClusterMain.getAri(S.BOX);
	int n=S.DOT.val;
	double r=Math.pow(.5,14-n);
	for(int i=0;i<Z.length;++i) {
	    gp=GraphicsHelp.makeCircle(Z[i],r,40);
	    gp=S.transform(gp);
	    g.setColor(new Color(80,130,255));
	    if(Z[i].CHARGE==1) g.setColor(new Color(255,140,50));
	    g.draw(gp);
	}
    }

    public static Complex[] pointsCheck(BoxModel[][] B,BoxModel[][] B2) {
	Complex[][] L=ClusterMain.getAri(B);
	Complex[] Z=new Complex[500];
	int count=0;
	for(int i=0;i<5;++i) {
	    for(int j=0;j<5;++j) {
	       for(int k=0;k<B2[i][j].POINTS;++k) {
		   boolean test=onSegment(B2[i][j].Z[k],L);
		   if(test==true) {
		       Z[count]=new Complex(B2[i][j].Z[k]);
		       ++count;
		   }
	       }
	    }
	}
	int p=B[0][0].P;
	int q=B[0][0].Q;
	Z=ListHelp.trimList(Z,count);
	Z=ClusterClean.main(Z,p+q);
	return(Z);
    }



    public static void pointsScratch(Graphics2D g,ClusterCanvas S) {
	GeneralPath gp=new GeneralPath(); 
	Color[] C={Color.white,Color.green,Color.yellow};
	for(int choice=0;choice<3;++choice) { 
	    if(S.SCRATCH.L[choice].on==1) {
	       Complex[] Z=ClusterMain.pointsScratch(choice,S);
	       int n=S.DOT.val;
	       double r=Math.pow(.5,14-n);		     
  	       for(int i=0;i<Z.length;++i) {  
		  if(choice!=1) {  
                    gp=GraphicsHelp.makeDot(Z[i]);
	            gp=S.transform(gp);
	            g.setStroke(new BasicStroke(3));
	            g.setColor(C[choice]);
	            g.draw(gp);
		  }
		  if(choice==1) { 
                    gp=GraphicsHelp.makeCircle(Z[i],r,4);
		    gp=S.transform(gp);
	            g.setStroke(new BasicStroke(1));
	            g.setColor(C[choice]);
	            g.draw(gp);
		  }
	       }
	    }
	}
        g.setStroke(new BasicStroke(1));
    }
				     



    public static boolean onSegment(Complex Z,Complex[][] L) {
	for(int i=0;i<L.length;++i) {
	    if(Complex.onSegment(Z,L[i][0],L[i][1])==true) return(true);
	}
	return(false);
    }




    /**oct drawing*/

    public static void octOld(Graphics2D g,ClusterCanvas S) {
	GeneralPath gp=new GeneralPath(); 
	Complex[][] Z=ClusterMain.getLinesOld(S);
	for(int i=0;i<Z.length;++i) {
	    gp=GraphicsHelp.toSegment(Z[i]);
	    gp=S.transform(gp);
	    g.setColor(new Color(150,0,0));
	    if(Z[i][0].CHARGE==0) g.setColor(new Color(0,0,150));
	    if(Z[i][0].OCT==S.TAGS.val) g.setColor(Color.white);
	    g.draw(gp);
	}
    }

    public static void octNew(Graphics2D g,ClusterCanvas S) {
	GeneralPath gp=new GeneralPath(); 
	Complex[][] Z=ClusterMain.getLinesNew(S);
	for(int i=0;i<Z.length;++i) {
	    gp=GraphicsHelp.toSegment(Z[i]);
	    gp=S.transform(gp);
	    g.setColor(new Color(150,0,0));
	    if(Z[i][0].CHARGE==0) g.setColor(new Color(0,0,150));
	    if(Z[i][0].OCT==S.TAGS.val) g.setColor(Color.white);
	    g.draw(gp);
	}
    }



    /**ari drawing*/


    public static void ariOld(Graphics2D g,ClusterCanvas S) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		box(g,S,S.BOX[i][j]);
	    }
	}
    }

    public static void box(Graphics2D g,ClusterCanvas S,BoxModel b) {
	GeneralPath gp=new GeneralPath();
	g.setStroke(new BasicStroke(1));
	gp=b.makeBox();
	gp=S.transform(gp);
        g.setColor(Color.black);
	g.fill(gp);
	Color[] COL={new Color(0,150,100),new Color(100,0,250)};
	Complex[][] Z={b.H0,b.H1,b.V0,b.V1};
	for(int i=0;i<4;++i) {
	   gp=GraphicsHelp.toSegment(Z[i]);
	   g.setColor(COL[Z[i][0].ARI%2]);
	   gp=S.transform(gp);
	   g.draw(gp);
	}
	g.setStroke(new BasicStroke(1));
    }


    public static void ariNew(Graphics2D g,ClusterCanvas S) {
  	Color[] COL={new Color(0,150,100),new Color(100,0,250)};
	Complex[][] Z=ClusterMain.getAri(S.BOX);
	for(int i=0;i<4;++i) {
	    GeneralPath gp=GraphicsHelp.toSegment(Z[i]);
  	    gp=S.transform(gp);
	    g.setColor(COL[Z[i][0].ARI%2]);
	    g.draw(gp);
	}
    }


    /**checking the rule*/

    public static void match(Graphics g,ClusterCanvas S) {
	boolean[] test=match(S);
	if(test[0]==false) {
	    g.setColor(new Color(50,120,255));
	    g.fillRect(5,85,20,20);

	}
	if(test[1]==false) {
	    g.setColor(Color.red); 
	    g.fillRect(5,110,20,20);
	}
    }

    public static boolean[] match(ClusterCanvas S) {
	Complex[] Z0=pointsCheck(S.BOX,S.BOX2);
	Complex[] Z1=ClusterMain.getPointsNew(S);
	boolean test1=ListHelp.isSubset(Z0,Z1);
	boolean test2=ListHelp.isSubset(Z1,Z0);
	boolean[] test={test1,test2};
	return(test);
    }

    /**draws the current zone in the cube*/
    public static void zone(Graphics2D g,ClusterCanvas S) {
	int p=S.M.p();
	int q=S.M.q();
	int n1=2*(p+q);
	int n2=S.M.P.JUMP;
	double x=S.BOX[2][0].H0[1].x;
	double y1=S.BOX[0][0].H0[0].y;
	double y2=S.BOX[0][2].H1[0].y;
	double t=1.0*n2/n1;
	double y=(1-t)*y1+t*y2;
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(x),(float)(y));
	gp.lineTo((float)(x+100),(float)(y));
	gp=S.transform(gp);
	g.setColor(Color.white);
	g.draw(gp);
    }


}

