import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;


public class ClusterSupport {


    /**This produces the line with the chosen slope through the point Z.
       The slope depends on p/q.*/

    public static Complex[] line(Complex z,int choice,int p,int q) {
	double s=GridOct.slope(choice,p,q);
	Complex z1=new Complex(z.x-1,z.y-s);
	Complex z2=new Complex(z.x+1,z.y+s);
	Complex[] Z={z1,z2};
	return(Z);
    }


    /**This duplicates the points but switches the tag on the copy*/

    public static Complex[] duplicate(Complex[] Z) {
	Complex[] Z2=new Complex[2*Z.length];
	for(int i=0;i<Z.length;++i) {
	    Z2[2*i+0]=new Complex(Z[i]);
	    Z2[2*i+1]=new Complex(Z[i]);
	    Z2[2*i+1].OCT=BoxCombinatorics.partner(true,Z[i].ARI,Z[i].OCT); 
	}
	return(Z2);

    }

    /**This gets the 8 lines running through the box cluster*/

    public static Complex[][] getAri(BoxModel[][] B) {
	Complex[][] L=new Complex[8][2];

	L[0][0]=B[0][0].H0[0];
	L[0][1]=B[2][0].H0[1];

	L[1][0]=B[0][2].H1[0];
	L[1][1]=B[2][2].H1[1];

	L[2][0]=B[0][0].V0[0];
	L[2][1]=B[0][2].V0[1];

	L[3][0]=B[2][0].V1[0];
	L[3][1]=B[2][2].V1[1];

	L[4][0]=B[0][0].H1[0];
	L[4][1]=B[2][0].H1[1];

	L[5][0]=B[0][1].H1[0];
	L[5][1]=B[2][1].H1[1];

	L[6][0]=B[0][0].V1[0];
	L[6][1]=B[0][2].V1[1];

	L[7][0]=B[1][0].V1[0];
	L[7][1]=B[1][2].V1[1];

	return(L);
    }

    /**mostly used for the purpose of trimming the edges
       in the subdivision study window.*/

    public static BoxModel outerEdges(BoxModel[][] B) {
	BoxModel b=new BoxModel();
	b.H0[0]=new Complex(B[0][0].H0[0]);
	b.H0[1]=new Complex(B[2][0].H0[1]);
	b.H1[0]=new Complex(B[0][2].H1[0]);
	b.H1[1]=new Complex(B[2][2].H1[1]);

	b.V0[0]=new Complex(B[0][0].V0[0]);
	b.V0[1]=new Complex(B[0][2].V0[1]);
	b.V1[0]=new Complex(B[2][0].V1[0]);
	b.V1[1]=new Complex(B[2][2].V1[1]);

	int count=0;
	return(b);
    }

    /**This intersects the lines with the support of the box cluster*/

    public static Complex[][] trim(BoxModel[][] B,Complex[][] Z) {
	Complex[][] W=new Complex[Z.length][2];
	int count=0;
	for(int i=0;i<Z.length;++i) {
	    Complex[] L=trim(B,Z[i]);
	    if(L!=null) {
		W[count]=L;
		++count;
	    }
	}
	W=ListHelp.trimList(W,count);
	return(W);
    }


    /**This intersects a single line with the support of the 
       box cluster*/

    public static Complex[] trim(BoxModel[][] B,Complex[] Z) {
	BoxModel b=outerEdges(B);
	Complex z1=Vector.findCross(Z[0],Z[1],b.H0[0],b.H0[1]);
	Complex z2=Vector.findCross(Z[0],Z[1],b.H1[0],b.H1[1]);
	Complex z3=Vector.findCross(Z[0],Z[1],b.V0[0],b.V0[1]);
	Complex z4=Vector.findCross(Z[0],Z[1],b.V1[0],b.V1[1]);

	Complex[] Z2=new Complex[2];
	int count=0;
	if(Complex.onSegment(z1,b.H0[0],b.H0[1])==true) {
	    Z2[count]=new Complex(z1);
	    ++count;
	}

	if(Complex.onSegment(z2,b.H1[0],b.H1[1])==true) {
	    Z2[count]=new Complex(z2);
	    ++count;
	}

	if((count<2)&&(Complex.onSegment(z3,b.V0[0],b.V0[1])==true)) {
	    Z2[count]=new Complex(z3);
	    ++count;
	}

	if((count<2)&&(Complex.onSegment(z4,b.V1[0],b.V1[1])==true)) {
	    Z2[count]=new Complex(z4);
	    ++count;
	}

	if(count<2) return(null);
	Z2[0].CHARGE=Z[0].CHARGE;
	Z2[0].OCT=Z[0].OCT;
	return(Z2);
    }

}

