import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of complex numbers */

public class Complex {
    double x,y;
    int CHARGE,MASS,ARI,CROSS,OCT,SIDE;
    
    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 
    
    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }
    
    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
	this.CHARGE=z.CHARGE;
	this.MASS=z.MASS;
	this.ARI=z.ARI;
	this.SIDE=z.SIDE;
	this.CROSS=z.CROSS;
	this.OCT=z.OCT;
	this.SIDE=z.SIDE;
    }

    public Complex set(Complex z) {
        x=z.x;
        y=z.y;
        return this;
    }

    public static double norm(Complex z) {
        return Math.sqrt(z.x*z.x+z.y*z.y);
    }

    public static Complex unit(Complex z) {
        double d=z.norm(z);
        return new Complex(z.x/d,z.y/d);
    }

    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }
    

    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }
    

    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }

    public static Complex inverse(Complex z) {
        double d=z.x*z.x+z.y*z.y;
        return new Complex(z.x/d,-z.y/d);
    }
    

    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,inverse(z2));
    }
    
    public static Complex conjugate(Complex z) {
        return new Complex(z.x,-z.y);
    }
    

    public static double dot(Complex a, Complex b) {
        return a.x*b.x+a.y*b.y;
    }
    
    public static double dist(Complex a,Complex b) {
        Complex z=minus(a,b);
        return(norm(z));
    }
    
    
    
    
    public double norm() {
        return Math.sqrt(x*x+y*y);
    }

    public Complex unit() {
        double d=norm();
        return new Complex(x/d,y/d);
    }

    public Complex plus(Complex z) {
        return new Complex(x+z.x, y+z.y);
    }
    

    public Complex minus(Complex z) {
        return new Complex(x-z.x, y-z.y);
    }

    public Complex times(Complex z) {
        return new Complex(x*z.x-y*z.y,
        x*z.y+y*z.x);
    }
    
    

    public Complex inverse() {
        double d=x*x+y*y;
        return new Complex(x/d,-y/d);
    }
    
    public Complex divide(Complex z2) {
        return times(inverse(z2));
    }
    
    
    public Complex conjugate() {
        return new Complex(x,-y);
    }

    public double dot(Complex a) {
        return a.x*x+a.y*y;
    }
    
    public boolean equals(Complex a) {
        return ((a.x==x)&&(a.y==y));
    }
    
    
    public double arg(){
        return Math.atan2(y,x);
    }


    public static double area(Complex z1,Complex z2,Complex z3) {
        Complex[] z=new Complex[5];
        for(int i=1;i<=4;++i) z[i]=new Complex();
        z[1]=Complex.minus(z2,z1);
        z[2]=Complex.minus(z3,z1);
        z[3]=Complex.conjugate(z[2]);
        z[4]=Complex.times(z[1],z[3]);
	return(z[4].y);
    }

    public static double distanceToLine(Complex w,Complex z1,Complex z2) {
	double a=area(w,z1,z2);
	double b=dist(z1,z2);
	if(a<0) a=-a;
	a=a/b;
	return(a);
    }

    public static boolean onLine(Complex w,Complex z1,Complex z2) {
	double d=distanceToLine(w,z1,z2);
	if(d<.0000000001) return(true);
	return(false);
    }

    public static boolean onSegment(Complex w,Complex z1,Complex z2) {
	double d1=dist(w,z1);
	double d2=dist(w,z2);
	double d3=dist(z1,z2);
	if(d1+d2<d3+.00000000001) return(true);
	return(false);
    }

    public static Complex average(Complex z1,Complex z2) {
	Complex w=new Complex(.5*z1.x+.5*z2.x,.5*z1.y+.5*z2.y);
	return(w);
    }

    public static boolean isSeparated(Complex z1,Complex z2,Complex w1,Complex w2) {
	double t1=Complex.area(z1,z2,w1);
	double t2=Complex.area(z1,z2,w2);
	if((t1<-.00000001)&&(t2>.00000001)) return(true);
	if((t2<-.00000001)&&(t1>.00000001)) return(true);
	return(false);
    }


    public Complex reflect(Complex z) {
	Complex w=new Complex(2*x-z.x,2*y-z.y);
	return(w);
    }





    
    public Complex scale(Complex z,double r) {
        Complex w=new Complex();
        w.x=r*x+(1.0-r)*z.x;
        w.y=r*y+(1.0-r)*z.y;
        return(w);
    }


    public void print() {
	System.out.println("Complex: "+this.x+" "+this.y);
    }
}

