import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class ComputeSurvey implements Runnable {
    Manager M;
    int LEVEL;
    int halt;

    public ComputeSurvey() {}

    public ComputeSurvey(Complex z,Manager MM) {  
	this.M=MM;
    }


    public void run() {	
	int mode=M.C.GRAPH.RANGE.mode;
	if(mode==0) runAll();
	if(mode==1) runZero();
	if(mode==2) runNone();
	M.C.repaint();
	M.P.repaint();
    }


    public void runAll() {
	int gap0=M.C.SES.GAP0.val;
	int gap1=M.C.SES.GAP1.val;
	int mode=M.C.GRAPH.SURVEY.mode;
	if(mode==0) survey(0,gap0,gap1);
	if(mode==1) survey(1,gap0,gap1);
    }

    public void runZero() {
	int gap0=M.C.SES.GAP0.val;
	int gap1=M.C.SES.GAP1.val;
	int mode=M.C.GRAPH.SURVEY.mode;
	if(mode==0) surveyZero(0,gap0,gap1);
	if(mode==1) surveyZero(1,gap0,gap1);
    }

    public void runNone() {
	int gap0=M.C.SES.GAP0.val;
	int gap1=M.C.SES.GAP1.val;
	int mode=M.C.GRAPH.SURVEY.mode;
	int depth=M.C.SES.GRID.val;
	MathContinuedFractions.printCFE(gap0,gap1);
	int[] rat=GridGenerator.inverse(mode,gap0,gap1,depth,1000000);
	if(rat!=null)
	MathContinuedFractions.printCFE(rat[0],rat[1]);
	System.out.println("");
    }




    public int random(int k) {
	int A=(int)(Math.floor(k*Math.random()));
	return(A);
    }

    public int[] randomGaps(int N) {
	boolean test=false;
	while(test==false) {
            int n0=1+random(N);
	    int n1=1+random(N);
	    n1=n0+n1;
	    int[] a=MathRational.reduce(n0,n1);
	    if(a[0]>1) return(a);
	}
	return(null);
    }


    public void perfect() {
	halt=1;
	int[][] LIST=new int[10000][2];
	int count=0;
	while(halt==1) {
	    int[] a=randomGaps(50);
	    int mode=1;
            int depth=(int)(2+8*Math.random());
	    int[] C={};
	    if(ListHelp.onList(a,LIST,count)==false) {
	      try {C=surveyRaw(mode,a[0],a[1],depth);}
	      catch(Exception e) {}

	      if(C!=null) {
		int test=content(C);
		if(test==0) {
		    System.out.print(mode+" ");
		    MathContinuedFractions.printCFE(a[0],a[1]);
                    printSpread(C);
		    System.out.println("");
		    LIST[count][0]=a[0];
		    LIST[count][1]=a[1];
		    ++count;
		}
	      }
	    }
	}
    }


    public void surveyZero(int mode,int gap0,int gap1) { 
        int depth=(int)(2+6*Math.random());
	int[][] A=BoxCross.surveySingleZero(mode,gap0,gap1,depth,M);
	if(A==null) System.out.println("no");
	else System.out.println("yes");
    }


    public void survey(int mode,int gap0,int gap1) {
	halt=1;
	System.out.print(mode+" ");
	MathContinuedFractions.printCFE(gap0,gap1);
	while(halt==1) {  
            int depth=(int)(2+4*Math.random());
	    int[] C=surveyRaw(mode,gap0,gap1,depth);
	  if(C!=null) {
	      System.out.println("");
             printSpread(C);
	     halt=0;
	  }
	}
	System.out.println("");
    }

    public int[] surveyRaw(int mode,int gap0,int gap1,int depth) {
	int[][] A=BoxCross.surveySingle(mode,gap0,gap1,depth,M);
	if(A==null) return(null);
	int[] C=getSpread(A,gap1);
	return(C);
    }




    /**analyzing the sequence*/

    public void printSpread(int[] C) {
	if(C[0]==9) {
	    System.out.println("no crosses");
	    return;
	}
	for(int i=1;i<C.length;++i)  {
	    if(C[i]==-1) System.out.print("-");
	    else System.out.print(C[i]);
	}
	System.out.println("");
    }

    public int[] getSpread(int[][] A,int gap1) {
	if(A[0][0]==9) return(A[0]);

	int[] C=new int[gap1/2+1];
	for(int j=0;j<C.length;++j) C[j]=-1;
	for(int j=0;j<A.length;++j) {
	    C[A[j][0]]=A[j][1];
	}
	return(C);
    }

    public int content(int[] C) {
	for(int i=0;i<C.length;++i) {
	    if(C[i]==1) return(1);
	}
	return(0);
    }


}

