import java.awt.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;

/*This class does the basic arithmetic
  of complex numbers */

public class ControlBox {
    ControlColor COLOR;
    ControlPanel BIN,DRAW,TRACE,SUB;
    int X,Y;

    public ControlBox(int x,int y) {
	X=x;
	Y=y;
	setPanels();
    }



    public void setPanels() {
	Color[] C0={new Color(100,0,200),Color.white,Color.white,Color.white,Color.red};


  String[] ColorString={
           "basic",
           "enhanced", 
           "cluster",
           "CROSS",
           "boundary",
           "connections",
           "trace fill",
           "trace draw",
	   "trace(clock)",
	   "trace(c.clock)",
           "colors"};
	 Color[] ColorColor={
	     new Color(0,0,150),
	     new Color(0,0,230),
	     new Color(150,50,250),
	     new Color(255,180,0),
	     new Color(50,100,255),
	     new Color(0,200,200),
	     new Color(0,80,160),
	     new Color(50,100,255),
	     new Color(170,255,0),
	     new Color(255,170,0)};
         COLOR=new ControlColor(C0,ColorString,10,ColorColor);

         String[] MoveString={
            "no",
            "yes",
            "discretize"};
         int[] MoveState={0,1};
         BIN=new ControlPanel(C0,MoveString,MoveState,2);
	 BIN.mode=1;


         String[] TraceString={
            "no",
            "yes",
            "trace orbit"};
         int[] TraceState={0,1};
         TRACE=new ControlPanel(C0,TraceString,TraceState,2);
	 TRACE.mode=1;

         String[] SubString={
            "greedy",
            "symmetric",
            "sub mode"};
         int[] SubState={1,0};
         SUB=new ControlPanel(C0,SubString,SubState,2);
	 SUB.mode=0;

         String[] DrawString={
            "straight",
            "curved",
            "draw style"};
         int[] DrawState={0,1};
         DRAW=new ControlPanel(C0,DrawString,DrawState,2);
	 DRAW.mode=1;
    }


    public void render(Graphics2D g) {
	BIN.render(g,X+90,Y+210,85);
	COLOR.render(g,X,Y+90,85);
	SUB.render(g,X+90,Y+45,85);
	DRAW.render(g,X+90,Y+100,85);
	TRACE.render(g,X+90,Y+155,85);
    }

    public void process(MouseEvent e,Color C) {
	MouseData J=MouseData.process(e);
	COLOR.process(J.X,C);
	BIN.switchMode(J.X);
	DRAW.switchMode(J.X);
	TRACE.switchMode(J.X);
	SUB.switchMode(J.X);
    }

}



