import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This is the class for the main control window.*/


public class ControlCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    ControlMain GRAPH;
    ControlGrid GRID;
    ControlBox BOX;
    SelectColor CS;
    ListenSquare GO,HALT,RESET;
    String PROGRESS="";
    Parameter SES;

    //runnable modules
    AGCompute CAG;
    BoxCompute CBM;
    ComputeSurvey CSV;
    ClusterCompute CC;

    public ControlCanvas addManager(Manager M) {
	ControlCanvas Q=this;
	Q.M=M;
	return(Q);
    }

     public ControlCanvas() {
	 addMouseListener(this);
  	 addMouseMotionListener(this);
 	 addKeyListener(this);
	 GRAPH=new ControlMain(3,3); 
         GRID=new ControlGrid(78,242);
         BOX=new ControlBox(240,173);
	 SES=new Parameter(210,3,"1/2");
	 setStartStop();
	 CS=new SelectColor(M,0,437,419,50);

	 //runnable modules
	 CAG=new AGCompute(); 
	 CBM=new BoxCompute(); 
	 CSV=new ComputeSurvey(); 
	 CC=new ClusterCompute(); 
     }

    public void setStartStop() { 
         RESET=new ListenSquare(360,123,40,22,Color.white);
         GO=   new ListenSquare(360,148,40,22,Color.white);
	 HALT= new ListenSquare(360,173,40,22,Color.white);
	 GO.on=1;	 
         HALT.on=1;
	 RESET.on=1;
    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      GRAPH.render(g);
      SES.render(g); 
      GRID.render(g);
      BOX.render(g);
      drawResetButton(g);
      drawGoButton(g);
      CS.render(g); 
      haltDraw(g);
   }


    /**getting the parameter*/

    public int[] getParameter() {
	int[] x=new int[2];
	x[0]=M.p();
	x[1]=M.q();
	return(x);
    }


    /**the background*/

    public void drawBG(Graphics2D g) {
	g.setColor(Color.black);
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(Color.white);
 	g.drawRect(0,0,getWidth()-1,getHeight()-1);
    }


    /*The halt button -- activated when something is computing*/

  public void haltDraw(Graphics2D g) {
      int test=0;
        if(CAG.halt==1) test=1;
        if(CBM.halt==1) test=1;
        if(CSV.halt==1) test=1;
        if(CC.halt==1) test=1;

      if(test==1) {
	    HALT.render(g,new Color(220,0,0));
            g.setColor(Color.white);
            g.setFont(new Font("Helvetica",Font.PLAIN,15));
	    g.drawString("halt",(int)(HALT.x+3),(int)(HALT.y+15));
      }
  }
    //the GO button

    public void drawGoButton(Graphics2D g) {
       GO.render(g,new Color(200,0,0));
       g.setFont(new Font("Helvetica",Font.PLAIN,15));
       g.setColor(Color.white);	 
       g.drawString("go",(int)(GO.x+6),(int)(GO.y+13));
    }

    public void drawResetButton(Graphics2D g) {
	g.setFont(new Font("Helvetica",Font.PLAIN,14));
	RESET.render(g,new Color(200,0,200));
	g.setColor(Color.white);	 
	g.drawString("reset",(int)(RESET.x+4),(int)(RESET.y+15));
    }

   public void doAction(Point X) {
      if(GO.inside(X)==1) {
	  int mode=GRAPH.CHOICE.mode;
	  if(mode==0) {
	      if(CAG.halt==0) {
	         CAG=new AGCompute(M.P.SOURCE,M);
                 new Thread(CAG).start();
	      }
	  }
	  if(mode==1) {
	      if(CBM.halt==0) {
	        CBM=new BoxCompute(M.P.SOURCE,M);
                new Thread(CBM).start();
	      }
	  }
	  if(mode==2) { 
	      if(CSV.halt==0) {
                CSV=new ComputeSurvey(M.P.SOURCE,M);
                new Thread(CSV).start();
	      }
	  }
	  if(mode==3) { 
	      if(CC.halt==0) {
		  CC=new ClusterCompute(M);
                  new Thread(CC).start();
	      }
	  }
      }
   }

      //halt computations

       public void haltComputations() {
	    CAG.halt=0;  
	    CBM.halt=0;   
	    CSV.halt=0;    
	    CC.halt=0;  
       }


    //set the shape parameter
     public void doReset(MouseEvent e) {
	M.P.orbitcount=0;
	M.P.blockcount=0;
	M.P.crosscount=0;
	M.P.boxcount=0;
     }

    //mouse button action

    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	GRAPH.process(e,CS.C,M);
	GRID.process(e,CS.C,M);
	BOX.process(e,CS.C);
	doAction(J.X);
	if(RESET.inside(J.X)==1) doReset(e);
	if(HALT.inside(J.X)==1) haltComputations();  
	CS.process(e); 
	SES.process(e);
	repaint();
	M.P.repaint();
	//M.F.repaint();
    }


    public void mousePressed(MouseEvent e) {}
   public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }
    public void mouseExited(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {	
        MouseData J=MouseData.process(e);
	repaint();
    }

    public void keyTyped(KeyEvent e) {
	GRAPH.processKey(e);
        SES.processKey(e);
   	repaint();
    }
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

