import java.applet.Applet;
import java.awt.*;
import java.applet.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;

/*This class does the basic arithmetic
  of complex numbers */

public class ControlGrid {
    int X,Y;
    GeneralPath[] OCT=new GeneralPath[8];
    GeneralPath[] ARI=new GeneralPath[4];
    ControlPanelColor MAIN;
    ControlPanel CROSS;
    int[] oct=new int[8];
    int[] ari=new int[4];
    Color[] A=new Color[4];
    ListenSquare ON,OFF;

    SelectInteger DEPTH1,DEPTH2,DEPTH3,DEPTH4;


    SelectInteger OCT_CHOICE;
    SelectInteger ARI_CHOICE;
    ListenSquare SYNC1,SYNC2;


    public ControlGrid(int x,int y) {
	X=x;
	Y=y;
	DEPTH1=new SelectInteger(X+80,Y-53,42,21,1,1,200,1);
	DEPTH2=new SelectInteger(X+100,Y-30,36,18,1,1,200,1);
	DEPTH3=new SelectInteger(X+80,Y+27,42,21,1,1,200,1);
	DEPTH4=new SelectInteger(X+100,Y+50,36,18,1,1,200,1);
	SYNC1=new ListenSquare(X+80,Y-30,15,15);
	SYNC2=new ListenSquare(X+80,Y+50,15,15);

	OCT_CHOICE=new SelectInteger(X+30,Y+170,28,15,0,0,100,1);
	ARI_CHOICE=new SelectInteger(X+30,Y+153,28,15,1,1,100,1);
	A[0]=new Color(0,150,100);
	A[1]=new Color(100,0,255);
	A[2]=new Color(0,150,100);
	A[3]=new Color(100,0,255);


	OFF=new ListenSquare(X-9,Y-20,20,20);
	ON=new ListenSquare(X-9,Y,20,20);
	setShapes();
	setPanels();
    }



    public void setPanels() {
  Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.white,Color.red};


  String[] MainString={"octa(+)",
                       "octa(-)",
                       "dot(+)",
                       "dot(-)",
                       "\u2610 trace",
                       "\u2573 trace",
                      "display"};
	 Color[] MainColor={new Color(0,0,200),
                            new Color(150,0,0),
                            new Color(80,130,255),
                            new Color(255,100,50),
                            Color.black,
                            Color.black};
	 int[] MainState={1,1,1,1,0,0};
         MAIN=new ControlPanelColor(C0,MainString,MainState,6,MainColor);

	 String[] CrossString={"dot","segment","cross style"};
	 int[] CrossState={1,0};
         CROSS=new ControlPanel(C0,CrossString,CrossState,2);
    }


    public void render(Graphics2D g) {

	g.setColor(new Color(0,0,150));
	g.fillRect(X-78,Y-78,235,273);
	g.setColor(Color.white);
	g.drawRect(X-78,Y-78,235,273);

	for(int i=0;i<8;++i) {
	    g.setColor(new Color(0,0,100));
	    if(oct[i]!=0) g.setColor(new Color(255,0,255));
	    g.fill(OCT[i]);
	    g.setColor(Color.white);
	    g.draw(OCT[i]);
	}
	for(int i=0;i<4;++i) {
	    g.setColor(Color.black);
	    if(ari[i]!=0) g.setColor(A[i]);
	    g.fill(ARI[i]);
	    g.setColor(Color.white);
	    g.draw(ARI[i]);
	}
	ON.render(g,new Color(255,0,255));
	OFF.render(g,new Color(0,0,100));

	Color C=new Color(0,0,0,0);
	MAIN.render(g,X-74,Y+80,80);
	CROSS.render(g,X+12,Y+80,75);
	DEPTH1.render(g,new Color(50,100,255),Color.white,Color.white);
	DEPTH2.render(g,new Color(50,100,255),Color.white,C);
	DEPTH3.render(g,new Color(50,100,255),Color.white,Color.white);
	DEPTH4.render(g,new Color(50,100,255),Color.white,C);
	ARI_CHOICE.render(g,new Color(50,100,255),Color.white,Color.white);
	OCT_CHOICE.render(g,new Color(50,100,255),Color.white,Color.white);
	SYNC1.render(g,new Color(50,100,255)); 
	SYNC2.render(g,new Color(50,100,255)); 
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(Color.white);
	g.drawString("\u2610 grid depth",X+76,Y-60);
	g.drawString("\u2573 grid depth",X+76,Y+20);

	g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,16));
	g.drawString("0",X-50,Y+5);
	g.drawString("1",X+45,Y+5);
	g.drawString("2",X-5,Y+50);
	g.drawString("3",X-5,Y-45);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.drawString("7",X+36,Y-36);
	g.drawString("5",X+25,Y-25);
	g.drawString("4",X-44,Y+44);
	g.drawString("6",X-32,Y+32);
	g.drawString("1",X-41,Y-37);
	g.drawString("3",X-30,Y-26);
	g.drawString("2",X+39,Y+43);
	g.drawString("0",X+27,Y+31);
    }


    public void setShapes() {


	AffineTransform AFF1=AffineTransform.getTranslateInstance(X,Y);
	AffineTransform AFF2=AffineTransform.getScaleInstance(70,70);
	GeneralPath[] gp=new GeneralPath[8];
	for(int i=0;i<4;++i) {
	    double t0=2*Math.PI*(4*i+1)/16;
	    double t1=2*Math.PI*(4*i+3)/16;
	    double c0=Math.cos(t0);
	    double s0=Math.sin(t0);
	    double c1=Math.cos(t1);
	    double s1=Math.sin(t1);
	    gp[2*i+0]=new GeneralPath();
	    gp[2*i+0].moveTo((float)(c0),(float)(s0));
	    gp[2*i+0].lineTo((float)(c1),(float)(s1));
	    gp[2*i+0].lineTo((float)(.75*c1),(float)(.75*s1));
	    gp[2*i+0].lineTo((float)(.75*c0),(float)(.75*s0));
	    gp[2*i+0].closePath();
	    gp[2*i+0].transform(AFF2);
	    gp[2*i+0].transform(AFF1);
	    gp[2*i+1]=new GeneralPath();
	    gp[2*i+1].moveTo((float)(.5*c0),(float)(.5*s0));
	    gp[2*i+1].lineTo((float)(.5*c1),(float)(.5*s1));
	    gp[2*i+1].lineTo((float)(.75*c1),(float)(.75*s1));
	    gp[2*i+1].lineTo((float)(.75*c0),(float)(.75*s0));
	    gp[2*i+1].closePath();
	    gp[2*i+1].transform(AFF2);
	    gp[2*i+1].transform(AFF1);
	}
	int[] a={2,0,4,6,1,3,7,5};


	for(int i=0;i<8;++i) OCT[a[i]]=new GeneralPath(gp[i]);

	for(int i=0;i<4;++i) {
	    double t0=2*Math.PI*(4*i-1)/16;
	    double t1=2*Math.PI*(4*i+1)/16;
	    double c0=Math.cos(t0);
	    double s0=Math.sin(t0);
	    double c1=Math.cos(t1);
	    double s1=Math.sin(t1);
	    gp[i]=new GeneralPath();
	    gp[i].moveTo((float)(c0),(float)(s0));
	    gp[i].lineTo((float)(c1),(float)(s1));
	    gp[i].lineTo((float)(.5*c1),(float)(.5*s1));
	    gp[i].lineTo((float)(.5*c0),(float)(.5*s0));
	    gp[i].closePath();
	    gp[i].transform(AFF2);
	    gp[i].transform(AFF1);
	}
	ARI[0]=new GeneralPath(gp[2]);
	ARI[1]=new GeneralPath(gp[0]);
	ARI[2]=new GeneralPath(gp[1]);
	ARI[3]=new GeneralPath(gp[3]);
	for(int i=0;i<4;++i) ari[i]=0;
    }

    public void process(MouseEvent e,Color C,Manager M) {
	MouseData J=MouseData.process(e);
	double x=J.X.x;
	double y=J.X.y;
	for(int i=0;i<8;++i) {
	    if(OCT[i].contains(x,y)==true) {
                oct[i]=1-oct[i];
		System.out.println(i);
	    }
	}
   	for(int i=0;i<4;++i) {
	    if(ARI[i].contains(x,y)==true) {
                if(J.mode!=2) ari[i]=1-ari[i];
		if(J.mode==2) A[i]=C;
	    }
	}
	MAIN.process(J.X,C);
	CROSS.switchMode(J.X);
	setChoices(J.X,M);
	if(SYNC1.inside(J.X)==1) {
             DEPTH1.val=M.C.SES.GRID.val;
             DEPTH3.val=M.C.SES.GRID.val;
	}
	if(SYNC2.inside(J.X)==1) {
	    DEPTH3.val=DEPTH1.val;
	}
	if(ON.inside(J.X)==1) {
	    for(int i=0;i<8;++i) {
		oct[i]=1;
	    }
	}
	if(OFF.inside(J.X)==1) {
	    for(int i=0;i<8;++i) {
		oct[i]=0;
	    }
	}
    }
	

    public void setChoices(Point X,Manager M) {
	int p=M.p();
	int q=M.q();
	int N=(p+q-1)/2;
	DEPTH1.modify(X);
	DEPTH3.modify(X);

	if(DEPTH2.upOrDown(X)==1) {
	    DEPTH1.val=DEPTH1.val+10;
	}
	if(DEPTH2.upOrDown(X)==-1) {
	    DEPTH1.val=DEPTH1.val-10;
	}

	if(DEPTH4.upOrDown(X)==1) {
	    DEPTH3.val=DEPTH3.val+10;
	}
	if(DEPTH4.upOrDown(X)==-1) {
	    DEPTH3.val=DEPTH3.val-10;
	}

	if(DEPTH1.val>N) DEPTH1.val=N;
	if(DEPTH1.val<1) DEPTH1.val=1;
	if(DEPTH3.val>N+1) DEPTH3.val=N+1;
	if(DEPTH3.val<1) DEPTH3.val=1;

	ARI_CHOICE.modify(X);
	OCT_CHOICE.modify(X);
	int d=DEPTH1.val;
	if(ARI_CHOICE.val>d) ARI_CHOICE.val=d;
	if(OCT_CHOICE.val>d-1) OCT_CHOICE.val=d-1;
    }


}



