import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlMain {
    ControlPanelColor BASIC;  
    SelectInteger WIDTH,HEIGHT,LIMIT;
    ControlPanel CHOICE,SCALE;
    ControlPanel STYLE,AG;
    ControlPanel SURVEY,RANGE,CLUSTER;
    ControlPanel ACTION,LOCAL;
    int x,y;

    public ControlMain(int xx,int yy) {
	x=xx;
	y=yy;
	LIMIT=new SelectInteger(x+245,y+180,36,15,16,1,22,1); 
	WIDTH=new SelectInteger(x+245,y+123,36,15,5,1,15,1);   
	HEIGHT=new SelectInteger(x+245,y+143,36,15,5,1,15,1);  
	setPanels();
    }


    public void setPanels() {
  Color[] C0={new Color(80,140,255),Color.white,Color.white,Color.black,Color.red};
	 Color[] C1={new Color(0,180,180),Color.white,Color.white,
                     Color.black,new Color(150,150,150)};

	 //basics
	 String[] BasicString={"marker","domain","fine grid","displays"};
	 Color[] BasicColor={new Color(255,255,0),
                             new Color(255,255,255,100),
                             new Color(255,255,255,50)};
	 int[] BasicState={1,1,0};
         BASIC=new ControlPanelColor(C1,BasicString,BasicState,3,BasicColor);

         String[] Choice1String={"graph","plaid","survey","cluster","plot mode"};
         int[] Choice1State={0,1,0,0};
         CHOICE=new ControlPanel(C1,Choice1String,Choice1State,4);
	 CHOICE.mode=1;

         String[] Graph1String={"basic",
                                "modular",
                                "trace(as)",
                                "block(df)",
                                "graph mode"};
         int[] Graph1State={1,0,0,0};
         AG=new ControlPanel(C1,Graph1String,Graph1State,4);
	 AG.mode=0;

         String[] styleString={"draw","fill","style"};
         int[] styleState={1,0};
         STYLE=new ControlPanel(C1,styleString,styleState,2);
	 STYLE.mode=0;

         String[] surveyString={"<1/3",">1/3","survey"};
         int[] surveyState={1,0};
         SURVEY=new ControlPanel(C1,surveyString,surveyState,2);
	 SURVEY.mode=0;

         String[] rangeString={"all","level 0","empty","range"};
         int[] rangeState={1,0,0};
         RANGE=new ControlPanel(C1,rangeString,rangeState,3);
	 RANGE.mode=0;

         String[] clusterString={"end","mismatch","under","over","halt"};
         int[] clusterState={1,1,0,0};
         CLUSTER=new ControlPanel(C1,clusterString,clusterState,4);
	 CLUSTER.mode=0;


         String[] ActionString={
            "basic",
	    "plaid",
            "recursive",
            "recur+hide",
	    "perfect",
            "plot method"};
         int[] ActionState={1,0,0,0,0};
         ACTION=new ControlPanel(C1,ActionString,ActionState,5);
         ACTION.mode=0;


         String[] LocalString={
            "global",
            "local",
            "plot domain"};
         int[] LocalState={1,0};
         LOCAL=new ControlPanel(C1,LocalString,LocalState,2);
         LOCAL.mode=0;

    }





    public int getLimit() {
	return((int)(Math.pow(2,LIMIT.val)));
    }
    public int getWidthLimit() {
	return((int)(Math.pow(2,WIDTH.val)));
    }
    public int getHeightLimit() {
	return((int)(Math.pow(2,HEIGHT.val)));
    }


    public void renderLimits(Graphics2D g) {
	int opt=getOption();
	renderBasic(g);
	renderBlock(g);
    }


    public void renderBasic(Graphics2D g) {
	LIMIT.render2(g,new Color(255,0,0),Color.white,Color.white);
    }

    public void renderBlock(Graphics2D g) {
	WIDTH.render2(g,new Color(255,0,0),Color.white,Color.white);
	HEIGHT.render2(g,new Color(255,0,0),Color.white,Color.white);
    }

    public int getOption() {
	return(CHOICE.mode);
    }


    public void render(Graphics2D g) {
         BASIC.render(g,x,y+85,80);
	 CHOICE.render(g,x,y,80);


	 if(CHOICE.mode==0) {
            AG.render(g,x+84,y,77);	
            STYLE.render(g,x+84,y+85,76);
	 }


	 if(CHOICE.mode==1) {
            LOCAL.render(g,x+84,y,77);	
            ACTION.render(g,x+84,y+55,76);
	 }


	 if(CHOICE.mode==2) {
            RANGE.render(g,x+84,y,77);
            SURVEY.render(g,x+84,y+70,77);
	 }

	 if(CHOICE.mode==3) {
            CLUSTER.render(g,x+84,y,77);
	 }
	 g.setColor(Color.white);
	 renderLimits(g);
    }

    public void process(MouseEvent e,Color C,Manager MM) {
        MouseData J=MouseData.process(e);
	int test;
        BASIC.process(J.X,C);
	CHOICE.switchMode(J.X);
	if(CHOICE.mode==0) {
	  STYLE.switchMode(J.X);
	  AG.switchMode(J.X);
	}
	if(CHOICE.mode==1) {
	  LOCAL.switchMode(J.X);
	  ACTION.switchMode(J.X);
	}
	if(CHOICE.mode==2) {
   	  SURVEY.switchMode(J.X);
	  RANGE.switchMode(J.X);
	}
	if(CHOICE.mode==3) {
	    CLUSTER.toggle(J.X);
	}

	SURVEY.switchMode(J.X);
        int test2=getOption();
        LIMIT.modify(J.X);
	WIDTH.modify(J.X);
	HEIGHT.modify(J.X);
    }

    public void processKey(KeyEvent e) {}

}

