import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;



public class CrossingModel {


    /**This draws all the crossing points for the model*/

    public static void drawCrosses(Manager M) {
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	Complex[] X=getCrosses(M);
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<X.length;++i) {
	    if(M.C.BOX.BIN.mode==1) X[i]=discretize(X[i],p+q);
	    gp=GraphicsHelp.makeDot(X[i]); 
            M.P.nextCross(X[i]);
	}
	M.P.repaint();   
    }

    /**This gets all the crossing points for the model*/

    public static Complex[] getCrosses(Manager M) {
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	int k=M.C.GRID.DEPTH1.val;
	int level=(int)(Math.floor(M.P.SOURCE.x));
	int jump=M.P.JUMP;
	int[] grid=M.C.GRID.ari;
	Complex[][] Z=getAri(level,k,p,q,grid);
	Complex[][] W=getOct(level,jump,k,p,q);
	Complex[] X=getCross(Z,W,p,q);
	return(X);
    }




    /**These routines get the arithmetic (rectilinear) grid lines.  The
       first routine gets them subject to the choices on the ControlPanel,
       and the second routine gets all the lines.*/


    public static Complex[][] getAri(int level,int k,int p,int q,int[] a) {
	Complex[][] Z=new Complex[0][0];
	for(int j=0;j<4;++j) {
	   if(a[j]==1) {
	       Complex[][] NEW=GridAri.gridList(level,j/2,j%2,k,p,q);
		Z=ListHelp.mergeList(Z,NEW);
	   }
	}
	return(Z);
    }

    public static Complex[][] getAri(int level,int depth,int p,int q) {
	Complex[][] W=new Complex[0][0];
        for(int j=0;j<4;++j) {
	   Complex[][] NEW=GridAri.gridList(level,j/2,j%2,depth,p,q);
	   W=ListHelp.mergeList(W,NEW);
	}
	return(W);
    }


    /**These routines get the hexagrid (slanting) grid lines.  The
       first routine gets them subject to the choices on the ControlPanel,
       and the second routine gets all the lines.*/



    public static Complex[][] getOct(int level,int jump,int depth,int p,int q) {
	Complex[][] W=new Complex[0][0];
	int[] a={1,2,4,7};
        for(int i=0;i<4;++i) {
	    int j=a[i];
	   Complex[][] NEW=GridOct.gridList(level,jump,j/2,j%2,depth,p,q);
	   W=ListHelp.mergeList(W,NEW);
	}
	return(W);
    }



    public static Complex[][] getOct(int level,int jump,int k,int p,int q,ControlPanel H) {
	Complex[][] W=new Complex[0][0];
        for(int j=0;j<8;++j) {
	   if(H.L[j].on==1) {
	       Complex[][] NEW=GridOct.gridList(level,jump,j/2,j%2,k,p,q);
	      W=ListHelp.mergeList(W,NEW);
	   }
	}
	return(W);
    }




    /**This gets all the crossing points for a given set of
       Arithmetic grid lines (Z) and a given set of hexagrid lines (W).
       The points are subjected to cancellation*/

    public static Complex[] getCross(Complex[][] Z,Complex[][] W,int p,int q) {
	return(getCross(Z,W,p,q,true));
    }

    public static Complex[] getCross(Complex[][] Z,Complex[][] W,int p,int q,boolean cancel) {
	Complex[] LIST=new Complex[0];
	for(int i=0;i<Z.length;++i) {
	    Complex[] NEW=getCross(Z[i],W,p,q);
	    NEW=clean(NEW,p+q,cancel);
	    LIST=ListHelp.mergeList(LIST,NEW);
	}
	return(LIST);
    }

    /**This finds all the places where a given arithmetic grid line (Z) is
       crossed by a given set of hexagrid lines (W).*/

    public static Complex[] getCross(Complex[] Z,Complex[][] W,int p,int q) {
    	Complex[] LIST0=new Complex[W.length];
	int count=0;
	for(int j=0;j<W.length;++j) {
	    boolean test=interact(Z,W[j]);
	    if(Complex.dist(W[j][0],W[j][1])<.25/(p+q)) test=false;

	    if(test==true) {
	        Complex X=Vector.findCross(Z[0],Z[1],W[j][0],W[j][1]);
		if(Complex.onSegment(X,Z[0],Z[1])==true) {
	           LIST0[count]=new Complex(X);
	           LIST0[count].CHARGE=W[j][0].CHARGE;
		   LIST0[count].MASS=Z[0].MASS;     
		   LIST0[count].ARI=Z[0].ARI;  
                   LIST0[count].OCT=W[j][0].OCT;
		   LIST0[count].SIDE=Z[0].SIDE; 
		   LIST0[count].CROSS=(LIST0[count].CHARGE+LIST0[count].ARI)%2;

	           ++count;
		}
	    }
	}
	Complex[] LIST=ListHelp.trimList(LIST0,count);
	return(LIST);
    }

    /**This decides when two lines in our model interact*/

    public static boolean interact(Complex[] Z,Complex[] W) {
	if(W[0].MASS>=Z[0].MASS) return(false);
	return BoxCombinatorics.interact(Z[0].ARI,W[0].OCT);
    }


    /**This eliminates redundancies when the point charges are the same,
       and eliminates both points when the charges are opposite.*/

    /**The boolean variable toggles whether the
       charged particles cancel*/

    public static Complex[] clean(Complex[] Z,int N) {
	return clean(Z,N,true);
    }


    public static Complex[] clean(Complex[] Z,int N,boolean cancel) {
	double tol=.00000001;
	int n=Z.length;
	Complex[] W=new Complex[n];
	int count=0;
	for(int i=0;i<n;++i) {
	    boolean test=false;
	    for(int j=0;j<n;++j) {
		boolean test2=false;
		if((cancel==true)&(i!=j)&&(Z[i].CHARGE!=Z[j].CHARGE)) test2=true;
		if((i< j)&&(Z[i].CHARGE==Z[j].CHARGE)) test2=true;
		if(test2==true) test2=cancel(Z[i],Z[j],N);
		if(test2==true) test=true;
	    }
	    if(test==false) {
		W[count]=new Complex(Z[i]);
		++count;
	    }
	}
	W=ListHelp.trimList(W,count);
	return(W);
    }


    public static boolean cancel(Complex Z1,Complex Z2,int N) {
	if(Z1.MASS!=Z2.MASS) return(false);
	if(Z1.ARI!=Z2.ARI) return(false);
        Complex W1=discretize(Z1,N);
	Complex W2=discretize(Z2,N);
	if(Complex.dist(W1,W2)>.9999/N) return(false);
	return(true);
    }

    public static Complex discretize(Complex Z,int N) {
	Complex W=new Complex(Z);
	if(Z.ARI>1) W.x=discretize(Z.x,N);
        if(Z.ARI<2) W.y=discretize(Z.y,N);
	return(W);
    }


    public static double discretize(double t,int N) {
	double s1=N*t;
	double s2=Math.floor(s1+.5);
	if(Math.abs(s1-s2)<.00000001) {
            return(s2/N);
	}
	s2=Math.floor(s1);
	s2=(s2+.5)/N;
	return(s2);
    }




}
