import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class Displays {
    public Displays() {
    }

    public static void fillPeriodBox(Graphics2D g,Manager M) {
          int[] pp=M.C.getParameter();	
          int lim=2*(pp[0]+pp[1]);
	  for(int k=0;k<lim;++k) {
	      GeneralPath gp=periodBox(k);   
	      gp=M.P.transform(gp);
	      g.setColor(Color.black);
	      g.fill(gp);
	  }
    }

    public static void drawPeriodBox(Graphics2D g,Color C,Manager M) {
          int[] pp=M.C.getParameter();
	  int lim=2*(pp[0]+pp[1]);
	  for(int k=0;k<lim;++k) {
	      GeneralPath gp=periodBox(k);   
	      gp=M.P.transform(gp);
	      g.setColor(C);
	      g.setStroke(new BasicStroke(2));
	      g.draw(gp);
	      g.setStroke(new BasicStroke(1));
	  }
    }

    public static GeneralPath periodBox(int k) {
	GeneralPath gp=new GeneralPath();
	double[][] d={{k,0},{k,1},{k+1,1},{k+1,0}};
	for(int i=0;i<4;++i) {
	    if(i==0) gp.moveTo((float)(d[i][0]),(float)(d[i][1]));
	    if(i!=0) gp.lineTo((float)(d[i][0]),(float)(d[i][1]));
	}
	gp.closePath();
	return(gp);
    }

    public static void drawFineGrid(Graphics2D g,Color C,Manager M) {
	int k=(int)(Math.floor(M.P.SOURCE.x));
	GeneralPath gp=new GeneralPath();
	int N=M.p()+M.q();
	for(int i=0;i<N;++i) {
	    float f1=(float)(1.0*i/N);
	    float f2=(float)(k+f1);
	    gp.moveTo(f2,0);
	    gp.lineTo(f2,1);
	    gp.moveTo(k,f1);
	    gp.lineTo(k+1,f1);
	}
	gp=M.P.transform(gp);
	g.setColor(C);
	g.draw(gp);
    }


    public static void drawMarker(Graphics2D g,Color C,Manager M) {
	Complex z=M.P.SOURCE;
	int p=M.p();
	int q=M.q();
	double t=0.5/(p+q);

	GeneralPath gp=new GeneralPath();
	double x=M.P.SOURCE.x;
	double y=M.P.SOURCE.y;
	gp.moveTo(x-t,y-t);
	gp.lineTo(x-t,y+t);
	gp.lineTo(x+t,y+t);
	gp.lineTo(x+t,y-t);
	gp.closePath();
	gp=M.P.transform(gp);
	g.setColor(C);
	g.draw(gp);
    }

}



