import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class GraphicsHelp {


    public static GeneralPath makeDot(Complex z) {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z.x),(float)(z.y));
	gp.lineTo((float)(z.x),(float)(z.y));
	return(gp);
    }

    /**This makes the segments*/
    public static GeneralPath makeDot(Complex z0,int p,int q) {
	Complex z=new Complex(z0);
	double d=0.5/(p+q);
	if(z.x<.00000001) z.x=d;
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z.x),(float)(z.y));
	Complex w=fluxPoint(z,p,q);
	gp.lineTo((float)(z.x+w.x),(float)(z.y+w.y));
	return(gp);
    }


    public static Complex fluxPoint(Complex z,int p,int q) {
	Complex w=new Complex();
	double d=0.5/(p+q);
	if((z.ARI<2)&&(z.CROSS==0)) w=new Complex(-d,0);
	if((z.ARI<2)&&(z.CROSS==1)) w=new Complex(+d,0);
	if((z.ARI>1)&&(z.CROSS==1)) w=new Complex(0,-d);
	if((z.ARI>1)&&(z.CROSS==0)) w=new Complex(0,+d);
	return(w);
    }

    public static GeneralPath toSegment(Complex[] Z) {
        GeneralPath gp=new GeneralPath();
	if(Z==null) return(gp);
	gp.moveTo((float)(Z[0].x),(float)(Z[0].y));
	gp.lineTo((float)(Z[1].x),(float)(Z[1].y));
	return(gp);
    }

    public static GeneralPath makeCircle(Complex z,double r,int n) {
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<n;++i) {
	    double t=2.0*i/n;
	    float c=(float)(z.x+r*Math.cos(Math.PI*t));
	    float s=(float)(z.y+r*Math.sin(Math.PI*t));
	    if(i==0) gp.moveTo(c,s);
	    else gp.lineTo(c,s);
	}
	gp.closePath();
	return(gp);
    }

    /**finding the orientation*/

    public static int getOrientation(BoxModel[] BOX,int[][] x) {
	GeneralPath gp=getOrbitLoop(BOX,x);
	Complex z=getMarker(BOX,x[0]);
	boolean test=gp.contains(z.x,z.y);
	if(test==true) return(1);
	return(0);
    }


    public static GeneralPath getOrbitLoop(BoxModel[] BOX,int[][] x) {
	GeneralPath gp=new GeneralPath();
	for(int j=0;j<x.length;++j) {
	    int a0=x[j][0];
	    int a1=x[j][1];
	    int a2=x[j][2];
	    Complex z1=BOX[a0].Z[a1];
	    Complex z2=BOX[a0].Z[a2];
	    Complex z3=BOX[a0].center();
	    float x1=(float)(z1.x);
	    float x2=(float)(z2.x);
	    float x3=(float)(z3.x);
	    float y1=(float)(z1.y);
	    float y2=(float)(z2.y);
	    float y3=(float)(z3.y);
	    if(j==0) gp.moveTo(x1,y1);
	    if(j!=0) gp.curveTo(x1,y1,x3,y3,x2,y2);
	}
	gp.closePath();
	return(gp);
    }


    public static Complex getMarker(BoxModel[] BOX,int[] x) {
         int a0=x[0];
	 int a1=x[1];
	 Complex z0=BOX[a0].Z[a1];
   	 int p=BOX[a0].P;
	 int q=BOX[a0].Q;
	 Complex I=new Complex(0,1);
  	 Complex z1=fluxPoint(z0,p,q);
	 Complex z2=Complex.plus(z0,Complex.times(z1,I));
	 return(z2);
    }


    /**isolating particular orbits*/


    /**This routine finds the last orbit with the given
       rational parameter and then scales this one nicely.
       If none it found, then nothing happens.*/

    public static void scaleNicely(PictureCanvas P,int p,int q) {
	for(int i=P.orbitcount-1;i>=0;--i) {
	    if((P.RAT[i][0]==p)&&(P.RAT[i][1]==q)) {
		P.SELECT=i;
		scaleNicely(P);
		return;
	    }
	}
    }


    public static void scaleNicely(PictureCanvas P) {
        if(P.SELECT==-1) return;
	AffineTransform[] AA=preFit(P.ORBIT[P.SELECT],10,80,P.getWidth()-20,P.getHeight()-100);
	P.A[0]=AA[0];
	P.A[1]=AA[1];
    }


    /**This is for the scratch canvas*/
    public static void scaleNicely(ClusterCanvas S) {
	int w=S.getWidth();
	int h=S.getHeight();
	AffineTransform[] AA=preFit(S.RIM,30,85,w-60,h-100);
	S.A[0]=AA[0];
	S.A[1]=AA[1];
    }


    /**This routine causes the scaling to change so as to fit the selected
       object to the screen*/

    public static AffineTransform[] preFit(GeneralPath gp,double x,double y,double w,double h) {
	AffineTransform[] AFF=new AffineTransform[2];
	Rectangle2D R0=gp.getBounds2D();
	Rectangle2D.Float R1=(Rectangle2D.Float)(R0);
	double[] t={R1.x,R1.y,R1.x+R1.getWidth(),R1.y+R1.getHeight()};
	 double x1=1.0*(w)/(t[2]-t[0]);
	 double x2=1.0*(h)/(t[3]-t[1]);
	 double sc=x1;
	 if(sc>x2) sc=x2;	 
         AFF[1]=AffineTransform.getScaleInstance(sc,-sc);
	 double cenx=(t[0]+t[2])/2.0;
	 double ceny=(t[1]+t[3])/2.0;
	 double targetx=x+1.0*w/2;
	 double targety=y+1.0*h/2;
	 double xx=targetx-cenx*sc;
	 double yy=targety+ceny*sc;
	 AFF[0]=AffineTransform.getTranslateInstance(xx,yy);
	 return(AFF);
    }


}
