import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

public class GridAri {

    public static void drawGrid(int choice,Graphics2D g,Manager M) {
	int on2=M.C.GRID.MAIN.L[4].on;
	int j=M.C.GRID.ARI_CHOICE.val;
	Color[] C=M.C.GRID.A;

        int k=M.C.GRID.DEPTH1.val;
        int p=M.C.SES.getNumerator();
        int q=M.C.SES.getDenominator();	 
        int level=(int)(Math.floor(M.P.SOURCE.x));
	int choice1=choice/2;
	int choice2=choice%2;
	Complex[][] Z=gridList(level,choice1,choice2,k,p,q);
	for(int i=0;i<Z.length;++i) {	
           GeneralPath gp=GraphicsHelp.toSegment(Z[i]);   
           gp=M.P.transform(gp);
           g.setColor(C[Z[i][0].ARI]);
           g.draw(gp); 
	   if((on2==1)&&(Z[i][0].MASS==j)) {
	       g.setStroke(new BasicStroke(5));
	       g.draw(gp);
	       g.setStroke(new BasicStroke(1));
	   }
	}
    }

    public static Complex[][] gridList(int level,int choice1,int choice2,int k,int p,int q) {
	Complex[][] Z=new Complex[k+1][2];
	for(int i=0;i<=k;++i) {
	    Z[i]=gridListSingle(level,choice1,choice2,i,p,q);
	}
	return(Z);
    }


    /**This returns the kth grid line.  
       choice1 tells which of H/V
       choice2 tells which of the two reflection choices to use*/

    public static Complex[] gridListSingle(int level,int choice1,int choice2,int k,int p,int q) {
	double s=MathRational.gap(p,q);
	double pos=k*s;
	pos=pos-Math.floor(pos);
	if(choice2==1) pos=1-pos;
	Complex[] Z=gridLine(level,choice1,pos);
	Z[0].MASS=k;
	Z[0].ARI=2*choice1+choice2;
	return(Z);
    }


    /**This returns either a horizontal unit segment in the given level
       at the given position.  pos is in (0,1).  choice tells which of H/V
       to return*/

    public static Complex[] gridLine(int level,int choice,double pos) {
	Complex[] H={new Complex(level,pos),new Complex(level+1,pos)};
	if(choice==1) return(H);
	Complex[] V={new Complex(level+pos,0),new Complex(level+pos,1)};
	return(V);
    }




}



