import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

public class GridGenerator {

    public static int[] inverse(int mode,int gap0,int gap1,int depth,int TRY) {
	int count=0;
	boolean test=false;
	int low=gap1*depth;
	while(count<TRY) {
	  ++count;
	  double d1=Math.random();
	  double d2=Math.random();
	  if(mode==0) d1=d1/3;
	  if(mode==1) d1=2*d1/3+1.0/3;
	  double den=low*(1+d2);
	  double num=d1*den;
	  int p=(int)(num);
	  int q=(int)(den);
	  int[] a={p,q};
	  a=MathRational.reduce(a[0],a[1]);
	  if(accept(mode,a,gap0,gap1,depth)==true) return(a);
	}
	return(null);
    }

    public static boolean accept(int mode,int[] a,int gap0,int gap1,int depth) {
	int test=(a[0]*a[1])%2;
	if(test==1) return(false);
        double d=1.0*a[0]/a[1];
	if((mode==0)&&(d>1.0/3)) return false;
	if((mode==1)&&(d<1.0/3)) return false;

	boolean PL=isPlaid(a[0],a[1],depth);
        if(PL==false) return(false);
	int[] g=gaps(a[0],a[1],depth);
	if(g[0]!=gap0) return(false);
	if(g[1]!=gap1) return(false);
	return(true);
    }

    public static int[] gapSequence(int p,int q,int k) {
	double[][] A=BoxGenerate.getOffsets(p,q,k);
	double[] B=new double[A.length-1];
	for(int i=0;i<B.length;++i) B[i]=A[i+1][0]-A[i][0];
	int[] C=new int[B.length];
	for(int i=0;i<C.length;++i) {
	    C[i]=(int)((p+q)*B[i]+.001);
	}
	return(C);
    }


    public static int[] union(int[] A0) {
	int[] A=ListHelp.trimList(A0,A0.length);
	Arrays.sort(A);
	int[] B=new int[A.length];
	B[0]=A[0];
	int count=1;
	for(int i=0;i<A.length;++i) {
	    if(A[i]>B[count-1]) {
		B[count]=A[i];
		++count;
	    }
	}
	B=ListHelp.trimList(B,count);
	return(B);
    }


    public static int[] gaps(int p,int q,int k) {
	int[] A=gapSequence(p,q,k);
	return(union(A));
    }

    public static boolean isPlaid(int[] A) {
	if(isPlaid0(A)==true) return(true);
	if(isPlaid1(A)==true) return(true);
	return(false);
    }

    public static boolean isPlaid0(int[] A) {
	int[] B=union(A);
	for(int i=0;i<A.length;++i) {
	    if((A[i]!=B[0])&&(i%2==0)) return(false);
	    if((A[i]==B[0])&&(i%2!=0)) return(false);
	}
	return(true);
    }

    public static boolean isPlaid1(int[] A) {
	int[] B=union(A);
	for(int i=0;i<A.length;++i) {
	    if((A[i]==B[0])&&(i%2==0)) return(false);
	    if((A[i]!=B[0])&&(i%2!=0)) return(false);
	}
	return(true);
    }

    public static boolean isPlaid(int p,int q,int k) {
	return(isPlaid(gapSequence(p,q,k)));
    }

    public static int[] plaidList(int p,int q) {
	int count=0;
	int N=(p+q-1)/2;
	int[] A=new int[N];
	for(int k=1;k<=N;++k) {
	    boolean test=isPlaid(p,q,k);
	    if(test==true) {
		A[count]=k;
		++count;
	    }
	}
	A=ListHelp.trimList(A,count);
	return(A);
    }


}



