import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class GridOct {


    public static void drawGrid(int choice,Graphics2D g,Manager M) {  
	Color[] C1={M.C.GRID.MAIN.M[0].C,M.C.GRID.MAIN.M[1].C}; 
	Complex[][] W=gridList(choice,M);
	int on3=M.C.GRID.MAIN.L[5].on;
	Color CC=M.C.GRID.MAIN.M[5].C;
	int j=M.C.GRID.OCT_CHOICE.val;

	for(int i=0;i<W.length;++i) {
	    int f1=W[i][0].CHARGE;
	    int on1=M.C.GRID.MAIN.L[f1].on;
	    if(on1==1) {
	       GeneralPath gp=GraphicsHelp.toSegment(W[i]);
	       gp=M.P.transform(gp); 
               g.setColor(C1[f1]);
               g.draw(gp);
	       if((W[i][0].MASS==j)&&(on3==1)) {
		  g.setStroke(new BasicStroke(5));
                  g.draw(gp);
		  g.setStroke(new BasicStroke(1));
	       }
	    }
	}
    }



    /**This just gets a bunch of settings of the main control
       panel and then invokes the method below.*/

    public static Complex[][] gridList(int choice,Manager M) {
	  int k=M.C.GRID.DEPTH3.val;
	  int choice1=choice/2;
	  int choice2=choice%2;
          int p=M.C.SES.getNumerator();
          int q=M.C.SES.getDenominator();
	  int jump=M.P.JUMP;	 
          int level=(int)(Math.floor(M.P.SOURCE.x));
	  return(gridList(level,jump,choice1,choice2,k,p,q));
    }

    /**This gives the list of all grid lines at the given level,
       up to a specified depth*/

    public static Complex[][] gridList(int level,int jump,int choice1,int choice2,int k,int p,int q) {

	int count=0;
	int kk=(k+1)/2;	
        Complex[][] Z0=new Complex[3*k][2];
	for(int j=0;j<k;++j) {
            Complex[][] W=gridListSingle(level,jump,choice1,choice2,j,p,q);
	    if(W!=null) {
	      for(int i=0;i<W.length;++i) {
		Z0[count+i][0]=new Complex(W[i][0]);
		Z0[count+i][1]=new Complex(W[i][1]);
	      }  
            count=count+W.length;
	    }
	}
	Complex[][] Z1=ListHelp.trimList(Z0,count);
	return(Z1);
    }



    /**This gives the list of kth gridlines at the given level.
       Choice1 tells which of the 4 families to use. 
       Choice2 tells which of the 2 reflection choices to use.
       Each line gets 3 tags:
       0. this tells the line number.
       1. this gives the charge of the line.
       2. this gives the type of the line.
    */

    public static Complex[][] gridListSingle(int level,int jump,int choice1,int choice2,int k,int p,int q) {
	int special=gridListTag(level,jump,p,q);
	double slope=slope(choice1,p,q);
	int target=(int)(-level*slope);

	Complex[][] Z0=new Complex[10][2];
	int count=0;
	double s=MathRational.gap(p,q);
	s=(2*k+1)*s;
	int p1=(int)(Math.floor(s));
	s=s-p1;
	int p2=p1+choice2+special;
	if(choice2==1) s=1-s;
	int type=2*choice1+choice2;
        for(int i=target-3;i<=target+3;++i) {
	   Complex[] W=gridLine(level,choice1,s+i,p,q);
	   if(W!=null) {
	      Z0[count][0]=new Complex(W[0]);
	      Z0[count][1]=new Complex(W[1]);
	      Z0[count][0].CHARGE=(i+p2+20000)%2;     //charge
              Z0[count][0].MASS=k;                  //hexline #
	      Z0[count][0].OCT=2*choice1+choice2;  //hexline type
	      Z0[count][0].CHARGE=(i+p2+20000)%2;     //charge
	      ++count;
	   }
	}
	Complex[][] Z1=ListHelp.trimList(Z0,count);
	if(slope(choice1,p,q)>0) Z1=ListHelp.reverseList(Z1);
	return(Z1);
    }

    /***This gives a the normalizing tag for the parity.
        What is going on is that the crossing points have  
        2 charges (as encoded by the parity) and the points
        cancel if they occupy the same space and have 
        opposite charge.*/

    public static int gridListTag(int level,int jump,int p,int q) {
	int L=findJump(p,q);
	int lift=0;
	if((jump>=L)&&(jump<L+p+q)) lift=1;


	double slope=slope(0,p,q);
	int target=(int)(-level*slope);
	double g=MathRational.gap(p,q);
        for(int i=target-3;i<=target+3;++i) {
	   Complex[] W=gridLine(level,0,g+i,p,q);
	   if(W!=null) {
	       return((lift+i)%2);
	   }
	}
	return(0);
    }

    public static int findJump(int p,int q) {
	double s=slope(0,p,q);
	double g=MathRational.gap(p,q);
	int lim=4*p;
	for(int i=-lim;i<0;++i) {
	    double t1=-(g+i)/s;
	    double t2=Math.floor(t1+.5);
	    double t3=Math.abs(t1-t2);
	    if(t3<.0000000001) {
		int n=(int)(t2)-1;
		int m=(n*(q-p))%(p+q);
		return(m);
	    }
	}
	return(0);
    }



    /**The variable level gives the desired unit box.
       The variable choice tells which of the 4 lines to use.
       The variable pos is the offset.
       p/q is the fraction.
       The routine computes the specified line and intersects
       it with the box.*/

    public static Complex[] gridLine(int level,int choice,double pos,int p,int q) {
	double s=slope(choice,p,q);
	double[] d0={-pos/s+0,0};
	double[] d1={-pos/s+1/s,1};
	if((d0[0]<level)&&(d1[0]<level+.0000001)) return(null);
	if((d0[0]>level+0.999999)&&(d1[0]>level+1)) return(null);
	Complex[] Z={new Complex(d0[0],d0[1]),new Complex(d1[0],d1[1])};
	Complex[] W1={new Complex(level,0),new Complex(level,1)};
	Complex[] W2={new Complex(level+1,0),new Complex(level+1,1)};
	Complex V1=Vector.findCross(Z[0],Z[1],W1[0],W1[1]);
	Complex V2=Vector.findCross(Z[0],Z[1],W2[0],W2[1]);
	if(s>0) {
	    if((V1.y>0)&&(V1.y<1)) Z[0]=new Complex(V1);
	    if((V2.y>0)&&(V2.y<1)) Z[1]=new Complex(V2);
	}
	if(s<0) {
	    if((V1.y>0)&&(V1.y<1)) Z[1]=new Complex(V1);
	    if((V2.y>0)&&(V2.y<1)) Z[0]=new Complex(V2);
	}
	return(Z);
    }

    public static double slope(int choice,int p,int q) {
	int[] C={p,q,-p,-q};
	double s=2.0*C[choice]/(p+q);
	return(s);
    }

}



