import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    /**This file does the bounce-tracking for the local
       box subdivision rule*/

public class ClusterBounce {

    public static Complex[] main(BoxModel[][] B,int[] on) {
	Complex[] LIST={};
	Complex[] NEW={};

	for(int choice=0;choice<2;++choice) {

	    if(on[0]==1) {
	       NEW=leftPoints(B);
	       NEW=duplicate(NEW);
	       for(int i=0;i<NEW.length;++i) NEW[i]=bounce(B,NEW[i],choice,0);
	       LIST=ListHelp.mergeList(LIST,NEW);
	    }

	    if(on[1]==1) {
	      NEW=rightPoints(B);
	       NEW=duplicate(NEW);
	       for(int i=0;i<NEW.length;++i) NEW[i]=bounce(B,NEW[i],choice,1);
	      LIST=ListHelp.mergeList(LIST,NEW);
	    }

	    if(on[2]==1) {
	      NEW=bottomPoints(B);
	       NEW=duplicate(NEW);
	       for(int i=0;i<NEW.length;++i) NEW[i]=bounce(B,NEW[i],choice,2);
	       LIST=ListHelp.mergeList(LIST,NEW);
	    }

	    if(on[3]==1) {
	      NEW=topPoints(B);
	       NEW=duplicate(NEW);
	       for(int i=0;i<NEW.length;++i) NEW[i]=bounce(B,NEW[i],choice,3);
	      LIST=ListHelp.mergeList(LIST,NEW);
	    }

	}
 	LIST=ListHelp.irredundantList(LIST);
	return(LIST);
    }


    /**This duplicates the points but switches the tag on the copy*/

    public static Complex[] duplicate(Complex[] Z) {
	Complex[] Z2=new Complex[2*Z.length];
	for(int i=0;i<Z.length;++i) {
	    Z2[2*i+0]=new Complex(Z[i]);
	    Z2[2*i+1]=new Complex(Z[i]);
	    Z2[2*i+1].OCT=BoxCombinatorics.partner(true,Z[i].ARI,Z[i].OCT); 
	}
	return(Z2);
    }

    public static Complex[] leftPoints(BoxModel[][] B) {
	BoxModel[] C={B[0][0],B[0][1],B[0][2]};
	return getPoints(C,1);
    }

    public static Complex[] rightPoints(BoxModel[][] B) {
	BoxModel[] C={B[2][0],B[2][1],B[2][2]};
	return getPoints(C,0);
    }

    public static Complex[] topPoints(BoxModel[][] B) {
	BoxModel[] C={B[0][2],B[1][2],B[2][2]};
	return getPoints(C,2);
    }

    public static Complex[] bottomPoints(BoxModel[][] B) {
	BoxModel[] C={B[0][0],B[1][0],B[2][0]};
	return getPoints(C,3);
    }


    public static Complex[] getPoints(BoxModel[] C,int k) {
	Complex[] LIST={};
	for(int i=0;i<C.length;++i) {
	    LIST=ListHelp.mergeList(LIST,C[i].sidePoints(k));
	}
	return(LIST);
    }

    /**start bounce routines*/

    public static Complex bounce(BoxModel[][] B,Complex Z,int choice,int ari) {
	int p=B[0][0].P;
	int q=B[0][0].Q;
	Complex[][] ARI=ClusterMain.getAri(B);

	if((ari>1)&&(choice==0)) {
	    Complex[][] L={B[0][0].V0,ARI[ari]};
	    return bounce(B,Z,L,p,q,ari);
	}
	if((ari>1)&&(choice==1)) {
            Complex[][] L={B[2][0].V1,ARI[ari]};
	    return bounce(B,Z,L,p,q,ari);
	}
	if((ari<2)&&(choice==0)) {
	    Complex[][] L={B[0][0].H0,ARI[ari]};
	    return bounce(B,Z,L,p,q,ari);
	}
	if((ari<2)&&(choice==1)) {
            Complex[][] L={B[0][2].H1,ARI[ari]};
	    return bounce(B,Z,L,p,q,ari);
	}
	return null;
    }

    public static Complex bounce(BoxModel[][] B,Complex Z,Complex[][] L,int p,int q,int ari) {
	Complex[] V1=ClusterMain.line(Z,Z.OCT/2,p,q);
	Complex Z0=Vector.findCross(V1[0],V1[1],L[0][0],L[0][1]);

	if(ari<2) {
	  double d1=Math.abs(Z.x-Z0.x);
	  double d2=Math.abs(L[1][0].x-Z0.x);
	  double d3=Math.abs(L[1][0].x-Z.x);
	  if(d1+d2>d3+.0000001) return(Z);
	}
	if(ari>1) {
	  double d1=Math.abs(Z.y-Z0.y);
	  double d2=Math.abs(L[1][0].y-Z0.y);
	  double d3=Math.abs(L[1][0].y-Z.y);
	  if(d1+d2>d3+.0000001) return(Z);
	}
	if(isPoint(B,Z0)==true) return(Z);
	int oct1=BoxCombinatorics.partner(false,L[0][0].ARI,Z.OCT);
	Complex[] V2=ClusterMain.line(Z0,oct1/2,p,q);
	Complex Z2=Vector.findCross(V2[0],V2[1],L[1][0],L[1][1]);
	Z2.OCT=oct1;
	Z2.CHARGE=Z.CHARGE;
	Z2.ARI=Z.ARI;
	return(Z2);
    }











    public static boolean reject(BoxModel[][] B,int ari,Complex Z,Complex Z2) {
	boolean test2=isPoint(B,Z2);
	if(test2==false) return(false);
	return(true);
    }


    public static Complex bounceForTop(BoxModel[][] B, Complex Z,int choice) {
	int p=B[0][0].P;
	int q=B[0][0].Q;
	int slope=Z.OCT/2;
	double s1=GridOct.slope(slope,p,q);

	double x1=0;
	int ari=-1;
	if(choice==0) {
            x1=B[0][0].H0[0].x;
            ari=B[0][0].V0[0].ARI;
	}
	if(choice==1) {
            x1=B[2][0].H0[1].x;
            ari=B[2][0].V1[0].ARI;
	}

	double d1=x1-Z.x;
	double y1=Z.y+d1*s1;

	if(reject(B,ari,Z,new Complex(x1,y1))==true) return(Z);

	double s2=0;
	if(s1>0) s2=s1-2;
	if(s1<0) s2=s1+2;

	double Y0=B[0][2].H1[0].y;
	double Y1=B[0][2].H0[0].y;
	double Y2=2*Y1-Y0;
	if(y1>Y1) return(Z);
	if(y1<Y2) return(Z);;
	double d2=Y2-y1;
	double y2=Y2;
	double x2=x1+d2/s2;
	Complex W=new Complex(x2,y2);
	W.CHARGE=Z.CHARGE;
	W.ARI=Z.ARI;
	W.OCT=BoxCombinatorics.partner(false,ari,Z.OCT);
	return(W);
    }


    public static Complex bounceForBottom(BoxModel[][] B, Complex Z,int choice) {
	int p=B[0][0].P;
	int q=B[0][0].Q;
	int slope=Z.OCT/2;
	double s1=GridOct.slope(slope,p,q);

	double x1=0;
	int ari=-1;

	if(choice==0) {
             x1=B[0][0].V0[0].x;
	     ari=B[0][0].V0[0].ARI;
	}

	if(choice==1) {
             x1=B[2][0].V1[0].x;  
             ari=B[2][0].V1[0].ARI;
	}

	double d1=x1-Z.x;
	double y1=Z.y+d1*s1;

	if(reject(B,ari,Z,new Complex(x1,y1))==true) return(Z);

	double s2=0;
	if(s1>0) s2=s1-2;
	if(s1<0) s2=s1+2;

	double Y0=B[0][0].H0[0].y;
	double Y1=B[0][0].H1[0].y;
	double Y2=2*Y1-Y0;
	if(y1<Y1) return(Z);
	if(y1>Y2) return(Z);
	double d2=Y2-y1;
	double y2=Y2;
	double x2=x1+d2/s2;
	Complex W=new Complex(x2,y2);
	W.CHARGE=Z.CHARGE;
	W.ARI=Z.ARI;
	W.OCT=BoxCombinatorics.partner(false,ari,Z.OCT);
	return(W);
    }


    public static Complex bounceForLeft(BoxModel[][] B, Complex Z,int choice) {
	int p=B[0][0].P;
	int q=B[0][0].Q;
	int slope=Z.OCT/2;
	double s1=GridOct.slope(slope,p,q);

	double y1=0;
	int ari=-1;

	if(choice==0) {
           y1=B[0][2].H1[0].y;
           ari=B[0][2].H1[0].ARI;
	}

	if(choice==1) {
            y1=B[0][0].H0[0].y;
            ari=B[0][0].H0[0].ARI;
	}
	double d1=y1-Z.y;
	double x1=Z.x+d1/s1;

	if(reject(B,ari,Z,new Complex(x1,y1))==true) return(Z);

	double s2=-s1;
	double X0=B[0][0].H0[0].x;
	double X1=B[0][2].H0[1].x;
	double X2=2*X1-X0;
	if(x1<X1) return(Z);
	if(x1>X2) return(Z);
	double d2=X2-x1;
	double x2=X2;
	double y2=y1+d2*s2;
	Complex W=new Complex(x2,y2);
	W.CHARGE=Z.CHARGE;
	W.ARI=Z.ARI;
	W.OCT=BoxCombinatorics.partner(false,ari,Z.OCT);
	return(W);
    }


    public static Complex bounceForRight(BoxModel[][] B, Complex Z,int choice) {
	int p=B[0][0].P;
	int q=B[0][0].Q;
	int slope=Z.OCT/2;
	double s1=GridOct.slope(slope,p,q);
	double y1=0;
	int ari=-1;

	if(choice==0) {
            y1=B[0][2].H1[0].y;
            ari=B[0][2].H1[0].ARI;
	}

	if(choice==1) {
           y1=B[0][0].H0[0].y;
           ari=B[0][0].H0[0].ARI;
	}
	double d1=y1-Z.y;
	double x1=Z.x+d1/s1;
	if(reject(B,ari,Z,new Complex(x1,y1))==true) return(Z);
	double s2=-s1;
	double X0=B[2][0].H0[1].x;
	double X1=B[2][0].H0[0].x;
	double X2=2*X1-X0;
	if(x1>X1) return(Z);
	if(x1<X2) return(Z);
	double d2=X2-x1;
	double x2=X2;
	double y2=y1+d2*s2;
	Complex W=new Complex(x2,y2);
	W.CHARGE=Z.CHARGE;
	W.ARI=Z.ARI;
	W.OCT=BoxCombinatorics.partner(false,2,Z.OCT);
	return(W);
    }






    /**Checks if the point already belongs to the model*/

    public static boolean isPoint(BoxModel[][] B,Complex z) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		if(B[i][j].isPoint(z)==true) return(true);
	    }
	}
	return(false);
    }







}


