import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


    /**This file does the bounce-tracking for the local
       box subdivision rule*/

public class ClusterBounce {

    public static Complex[] main(BoxModel[][] B) {
	Complex[] LIST={};
	Complex[] LP=leftPoints(B);
	Complex[] RP=rightPoints(B);
	Complex[] BP=bottomPoints(B);
	Complex[] TP=topPoints(B);
	for(int choice=0;choice<2;++choice) {
	    Complex[][] NEW={LP,RP,BP,TP};
 	    for(int i=0;i<4;++i) {
	       NEW[i]=duplicate(NEW[i]);
	       for(int j=0;j<NEW[i].length;++j) 
                  NEW[i][j]=bounce(B,NEW[i][j],choice,i);
	       LIST=ListHelp.mergeList(LIST,NEW[i]);
	    }
	}
 	LIST=ListHelp.irredundantList(LIST);
	return(LIST);
    }


    /**This duplicates the points but switches the tag on the copy*/

    public static Complex[] duplicate(Complex[] Z) {
	Complex[] Z2=new Complex[2*Z.length];
	for(int i=0;i<Z.length;++i) {
	    Z2[2*i+0]=new Complex(Z[i]);
	    Z2[2*i+1]=new Complex(Z[i]);
	    Z2[2*i+1].OCT=BoxCombinatorics.partner(true,Z[i].ARI,Z[i].OCT); 
	}
	return(Z2);
    }

    /**getting the points which we will bounce off the walls.*/

    public static Complex[] leftPoints(BoxModel[][] B) {
	BoxModel[] C={B[0][0],B[0][1],B[0][2]};
	return getPoints(C,1);
    }

    public static Complex[] rightPoints(BoxModel[][] B) {
	BoxModel[] C={B[2][0],B[2][1],B[2][2]};
	return getPoints(C,0);
    }

    public static Complex[] bottomPoints(BoxModel[][] B) {
	BoxModel[] C={B[0][0],B[1][0],B[2][0]};
	return getPoints(C,3);
    }

    public static Complex[] topPoints(BoxModel[][] B) {
	BoxModel[] C={B[0][2],B[1][2],B[2][2]};
	return getPoints(C,2);
    }

    public static Complex[] getPoints(BoxModel[] C,int k) {
	Complex[] LIST={};
	for(int i=0;i<C.length;++i) {
	    LIST=ListHelp.mergeList(LIST,C[i].sidePoints(k));
	}
	return(LIST);
    }


    /**Here are the wall-bouncing routines*/

    public static Complex bounce(BoxModel[][] B,Complex Z,int choice,int ari) {
	int p=B[0][0].P;
	int q=B[0][0].Q;
	Complex[][] ARI=ClusterMain.getAri(B);

	if((ari>1)&&(choice==0)) {
	    Complex[][] L={B[0][0].V0,ARI[ari]};
	    return bounce(B,Z,L,p,q,1);
	}
	if((ari>1)&&(choice==1)) {
            Complex[][] L={B[2][0].V1,ARI[ari]};
	    return bounce(B,Z,L,p,q,1);
	}
	if((ari<2)&&(choice==0)) {
	    Complex[][] L={B[0][0].H0,ARI[ari]};
	    return bounce(B,Z,L,p,q,0);
	}
	if((ari<2)&&(choice==1)) {
            Complex[][] L={B[0][2].H1,ARI[ari]};
	    return bounce(B,Z,L,p,q,0);
	}
	return null;
    }

    public static Complex bounce(BoxModel[][] B,Complex Z0,Complex[][] L,int p,int q,int c) {
	Complex[] LINE1=ClusterMain.line(Z0,Z0.OCT/2,p,q);
	Complex Z1=Vector.findCross(LINE1[0],LINE1[1],L[0][0],L[0][1]);
	if((c==0)&&(order(Z0.x,Z1.x,L[1][0].x)==false)) return(Z0);
	if((c==1)&&(order(Z0.y,Z1.y,L[1][0].y)==false)) return(Z0);
	if(isPoint(B,Z1)==true) return(Z0);
	int oct1=BoxCombinatorics.partner(false,L[0][0].ARI,Z0.OCT);
	Complex[] LINE2=ClusterMain.line(Z1,oct1/2,p,q);
	Complex Z2=Vector.findCross(LINE2[0],LINE2[1],L[1][0],L[1][1]);
	Z2.OCT=oct1;
	Z2.CHARGE=Z0.CHARGE;
	Z2.ARI=L[1][0].ARI;
	return(Z2);
    }




    public static boolean order(double s1,double s2,double s3) {
	if((s1<=s2)&&(s2<=s3)) return true;
	if((s1>=s2)&&(s2>=s3)) return true;
	return(false);
    }


    /**Checks if the point already belongs to the model*/

    public static boolean isPoint(BoxModel[][] B,Complex z) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		if(B[i][j].isPoint(z)==true) return(true);
	    }
	}
	return(false);
    }

}


