import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class ListHelp {


    /**dealing with lists*/

    public static Complex[] mergeList(Complex[] LIST,Complex[] NEW) {
	Complex[] LIST2=new Complex[LIST.length+NEW.length];
	for(int i=0;i<LIST.length;++i) {
	    LIST2[i]=new Complex(LIST[i]);
	}
	for(int i=0;i<NEW.length;++i) {
	    LIST2[i+LIST.length]=new Complex(NEW[i]);
	}
	return(LIST2);
    }

    public static Complex[][] mergeList(Complex[][] LIST,Complex[][] NEW) {
	Complex[][] LIST2=new Complex[LIST.length+NEW.length][2];
	for(int i=0;i<LIST.length;++i) {
	    LIST2[i][0]=new Complex(LIST[i][0]);
	    LIST2[i][1]=new Complex(LIST[i][1]);
	}
	for(int i=0;i<NEW.length;++i) {
	    LIST2[i+LIST.length][0]=new Complex(NEW[i][0]);
	    LIST2[i+LIST.length][1]=new Complex(NEW[i][1]);
	}
	return(LIST2);
    }


    public static Complex[][] irredundantList(Complex[][] Z) {
	Complex[][] W0=new Complex[Z.length][2];
	int count=0;
	for(int i=0;i<Z.length;++i) {
	    if(onList(Z[i],W0,count)==false) {
		W0[count][0]=new Complex(Z[i][0]);
		W0[count][1]=new Complex(Z[i][1]);
		++count;
	    }
	}
	Complex[][] W1=trimList(W0,count);
	return(W1);
    }



    public static boolean onList(Complex[] Z,Complex[][] LIST,int count) {
	double t=.0000001;
	for(int i=0;i<count;++i) {
	    double d00=Complex.dist(Z[0],LIST[i][0]);
	    double d01=Complex.dist(Z[0],LIST[i][1]);
	    double d10=Complex.dist(Z[1],LIST[i][0]);
	    double d11=Complex.dist(Z[1],LIST[i][1]);
	    if((d00<t)&&(d11<t)) return(true);
	    if((d01<t)&&(d10<t)) return(true);
	}
	return(false);
    }

    public static Complex[] irredundantList(Complex[] Z) {
	Complex[] W0=new Complex[Z.length];
	int count=0;
	for(int i=0;i<Z.length;++i) {
	    if(onList(Z[i],W0,count)==false) {
		W0[count]=new Complex(Z[i]);
		++count;
	    }
	}
	Complex[] W1=trimList(W0,count);
	return(W1);
    }



    public static boolean onList(Complex Z,Complex[] LIST,int count) {
	double t=.0000001;
	for(int i=0;i<count;++i) {
	    double d=Complex.dist(Z,LIST[i]);
	    if((Z.CHARGE==LIST[i].CHARGE)&&(d<t)) return(true);
	}
	return(false);
    }



    public static Complex[][] reverseList(Complex[][] Z0) {
	int count=Z0.length;
	  Complex[][] Z1=new Complex[count][2];
	  for(int i=0;i<count;++i) {
	      Z1[count-1-i][0]=new Complex(Z0[i][0]);
	      Z1[count-1-i][1]=new Complex(Z0[i][1]);
	  }
	  return(Z1);
    }



    public static Complex[][] trimList(Complex[][] Z0,int count) {
	  Complex[][] Z1=new Complex[count][2];
	  for(int i=0;i<count;++i) {
	      Z1[i][0]=new Complex(Z0[i][0]);
	      Z1[i][1]=new Complex(Z0[i][1]);
	  }
	  return(Z1);
    }


    public static Complex[] trimList(Complex[] Z0,int count) {
	  Complex[] Z1=new Complex[count];
	  for(int i=0;i<count;++i) {
	      Z1[i]=new Complex(Z0[i]);
	  }
	  return(Z1);
    }


    public static double[] trimList(double[] d0,int count) {
	  double[] d1=new double[count];
	  for(int i=0;i<count;++i) {
	      d1[i]=d0[i];
	  }
	  return(d1);
    }

    public static int[] trimList(int[] d0,int count) {
	  int[] d1=new int[count];
	  for(int i=0;i<count;++i) {
	      d1[i]=d0[i];
	  }
	  return(d1);
    }

    public static int[][] trimList(int[][] d0,int count) {
	int a=d0[0].length;
	  int[][] d1=new int[count][a];
	  for(int i=0;i<count;++i) {
	      for(int j=0;j<a;++j) {
	      d1[i][j]=d0[i][j];
	      }
	  }
	  return(d1);
    }

    public static int[][] mergeList(int[][] LIST,int[][] NEW) {
	int h=NEW[0].length;
	int[][] LIST2=new int[LIST.length+NEW.length][h];
	for(int i=0;i<LIST.length;++i) {
	    for(int j=0;j<h;++j) LIST2[i][j]=LIST[i][j];
	}
	for(int i=0;i<NEW.length;++i) {
	    for(int j=0;j<h;++j) LIST2[i+LIST.length][j]=NEW[i][j];
	}
	return(LIST2);
    }



    public static boolean isSubset(Complex[] Z1,Complex[] Z2) {
	for(int i=0;i<Z1.length;++i) {
	    if(onList(Z1[i],Z2,Z2.length)==false) return(false);
	}
	return(true);
    }


    public static Complex[] omit(Complex[] X,Complex[] Y) {
	Complex[] Z=new Complex[X.length];
	int count=0;
	for(int i=0;i<X.length;++i) {
	    if(onList(X[i],Y,Y.length)==false) {
		Z[count]=new Complex(X[i]);
		++count;
	    }
	}
	Z=trimList(Z,count);
	return(Z);
    }





    public static void printout(double[] d) {
	for(int i=0;i<d.length;++i) {
	    System.out.println(d[i]);
	}
    }

    public static void printout(int[] d) {
	for(int i=0;i<d.length;++i) {
	    System.out.print(d[i]+" ");
	}
	System.out.println("");
    }

    /**matching triples*/

    public static boolean match(int[] a,int[] b) {
	if((a[0]==b[0])&&(a[1]==b[1])) return(true);
	return(false);
    }

    public static boolean onList(int[] a,int[][] LIST,int count) {
	for(int i=0;i<count;++i) {
	    if(match(a,LIST[i])==true) return(true);
	}
	return(false);
    }

    public static int[][] union(int[][] d0,int count0) {
	int count1=0;
	int h=d0[0].length;
	int[][] d1=new int[count0][h];
	for(int i=0;i<count0;++i) {
	    if(onList(d0[i],d1,count1)==false) {
		for(int j=0;j<h;++j) d1[count1][j]=d0[i][j];
		++count1;
	    }
	}
	d1=trimList(d1,count1);
	return(d1);
    }
}

