public class MathApproximation {

    public MathApproximation() {}


    public static MathRational average(MathRational F1,MathRational F2) {
	MathRational G1=MathRational.reduce(F1);
	MathRational G2=MathRational.reduce(F2);
	MathRational H=new MathRational(G1.p+G2.p,G1.q+G2.q);
	H=MathRational.reduce(H);
	return(H);
    }

    /*
    1 means (nearly) equals left endpoint
    2 means inside
    3 means (nearly) equals right endpoint
    0 means outside
    */


    public static int isInside(double x,MathRational[] F) {
	double f0=1.0*F[0].p/F[0].q;
	double f1=1.0*F[1].p/F[1].q;
	double cutoff=0.000000000000001;
	if(x<f0-cutoff) return(0);
	if(x>f1+cutoff) return(0);
	if(Math.abs(x-f0)<=cutoff) return(1);
	if(Math.abs(x-f1)<=cutoff) return(3);
	return(2);
    }

    public static MathRational[] subdivide0(int k,MathRational[] F) {
	MathRational[] G=new MathRational[2];
	G[0]=new MathRational(0,1);
	G[1]=new MathRational(1,1);
	if(k==0) {
	    G[0]=new MathRational(F[0].p,F[0].q);
	    G[1]=average(F[0],F[1]);
	}

	if(k==1) {
            G[0]=average(F[0],F[1]);
	    G[1]=new MathRational(F[1].p,F[1].q);
	}
	G[0].code=k;
	return(G);
    }

    public static MathRational[] subdivide(double x,MathRational[] F) {
	MathRational[] G1=subdivide0(0,F);
	MathRational[] G2=subdivide0(1,F);
	int test=isInside(x,G2);
	if(test!=0) return(G2);
	return(G1);
    }


    /**the double should be between 0 and 1*/

    public static MathRational approximate0(double x,double tol) {
	MathRational[] F=new MathRational[2];
	int code=0;
	F[0]=new MathRational(0,1);
	F[1]=new MathRational(1,1);
	int count=0;
	double test=1.0;
	while((count<500)&&(test>tol)) {
	    ++count;
              F=subdivide(x,F);	
              double f0=1.0*F[0].p/F[0].q;
              double f1=1.0*F[1].p/F[1].q;
	      test=Math.abs(f0-f1);
	}

	MathRational G=average(F[0],F[1]);
	double d1=1.0*G.p/G.q-x;
	if(d1>0) return(F[0]);
	return(F[1]);
    }



    public static int[] approximate(double x,double tol) {
	double x1=Math.floor(x);
	double x2=x-x1;
	int[] I=new int[2];

	if(Math.abs(x2)<.00000001) {
	    I[0]=(int)(x1);
	    I[1]=1;
	    return(I);
	}
	if(Math.abs(x2)>1-.00000001) {
	    I[0]=(int)(x1+1);
	    I[1]=1;
	    return(I);
	}

	MathRational F=approximate0(x2,tol);
	I[0]=(int)(x1*F.q+F.p);
	I[1]=F.q;
	return(I);
    }



}
