

public class MathContinuedFractions {

    public static int[] cfe(int[] P) {
	if(P[0]<P[1]) return(cfe1(P));
        int k=P[0]/P[1];
	int[] Q={P[0]-k*P[1],P[1]};
	int[] list=cfe1(Q);
	list[0]=k;
	return(list);
    }

    /*continued fraction, for number in (0,1)*/

    public static int[] cfe1(int[] P) {
	int[] X={P[0],P[1]};
	int[] list=new int[100];
	int count=0;
	while(X[0]>0) {
	    list[count]=cfe0(X);
	    ++count;
	    X=gauss(X);
	}
	int[] list2=new int[count+1];
	list2[0]=0;
	for(int i=0;i<count;++i) list2[i+1]=list[i];
	return(list2);
    }

    /**the gauss map*/

    public static double gauss(double x) {
	double y=1/x-Math.floor(1/x);
	return(y);
    }


    public static int[] gauss(int[] P) {
	int p=P[0];
	int q=P[1];
	double a=1.0*q/p;
	double b=Math.floor(a);
	int q1=p;
	int p1=(int)(q-b*p+.00000001);
	int[] X={p1,q1};
	return(X);
    }

    public static int cfe0(int[] P) {
	int p=P[0];
	int q=P[1];
	double a=1.0*q/p;
	double b=Math.floor(a);
	int B=(int)(b);
	return(B);
    }

    /*This checks if all cfe coeffs are <=k.*/

    public static boolean cfeSmall(int[] P,int k) {
	int[] list=cfe(P);
	for(int i=0;i<list.length;++i) {
	    if(list[i]>k) return(false);
	}
	return(true);
    }

    /**continued fraction to fraction*/

    public static long[] toFraction(int[] a) {
	int n=a.length;
        long[] h=new long[n+2];
	long[] k=new long[n+2];
	h[0]=0;
	h[1]=1;
	k[0]=1;
	k[1]=0;
	for(int i=0;i<n;++i) {
	    h[i+2]=a[i]*h[i+1]+h[i];
	    k[i+2]=a[i]*k[i+1]+k[i];
	}
	long[] b={h[n+1],k[n+1]};
	return(b);
    }

    public static void printCFE(int gap0,int gap1) {
	System.out.print(gap0+"/"+gap1+"| ");
        int[] pp={gap0,gap1};
	pp=cfe(pp);
	for(int i=0;i<pp.length;++i) System.out.print(pp[i]+":");
	System.out.print(" ");
    }

}
