

import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class MathModular {



    /**These routines compute the even modular sequence of an even rational.
       The even modular sequence works like this.  Each even rational
       a1/b1 has a unique even a0/b0 which is Farey related. That is:

          a0/b0  ~  a1/b1   and   a0<a1

       The modular predecessor of a1/a1 is defined to be p/q
       where 

            1. a0<q<a1 
            2. a0/b0 ~ p/q 
            3. p/q-a0/b0  and a1/b1-b0/b0 have the same sign.

      If no such fraction exists, then the modular predecessor is defined to
      be a0/b0.  Each even rational has a unique predecessor and infinitely
      many possible successors.  The first routine picks a successor based
      on auxiliary data and the second routine pics THE predecessor.*/


    public static int[] modularSuccessor(int choice,int n,int a,int b) {
	int zoop=(a*b)%2;
	if(zoop==1) return(null);
	int[] c0=MathRational.RMINUS(a,b);
	int[] c1=MathRational.RPLUS(a,b);
	int[]c2={0,0};
	int sign=(c0[0]*c0[1])%2;
	if(choice==0) {c2[0]=c0[0];c2[1]=c0[1];}
	if(choice==1) {c2[0]=c1[0];c2[1]=c1[1];}
	return(modularSuccessor(n,a,b,c2));
    }

    public static int[] modularSuccessor(int n,int a,int b,int[] c) {
	int zoop=(a*b)%2;
	if(zoop==1) return(null);
	int parity=(c[0]*c[1])%2;
	int n1=2*n;
	if(parity==1) --n1;
	int p=n1*a+c[0];
	int q=n1*b+c[1];
	int[] P={p,q};
	return(P);
    }

    public static int[] modularPredecessor(int p,int q) {
	int sign=(p*q)%2;
	if(sign==1) return(null);
	int[] a=MathRational.evenPredecessor(p,q);
	int s=compare(p,q,a[0],a[1]);
	if(s==-1) s=0;
	return(modularPredecessor(s,p,q));
    }

    public static int[] modularPredecessor(int choice,int p,int q) {
	int sign=(p*q)%2;
	if(sign==1) return(null);
	int[] a=MathRational.evenPredecessor(p,q);
	boolean test=false;
	int n=0;
	int[] d={a[0],a[1]};
	int count=0;
	while((count<100)&&(test==false)) {
	    int[] c=modularSuccessor(choice,n,a[0],a[1]);
	    if((c[1]>a[1])&&(c[1]<q)) {
		d[0]=c[0];
		d[1]=c[1];
		++count;
	    }
	    ++n;
	    if(c[1]==q) test=true;
	}
	if(count>90) {
	    d[0]=1;
	    d[1]=2;
	}
	return(d);
    }

    public static int[] modularValue(int p,int q) {
	int[] a=MathRational.evenPredecessor(p,q);
	int s=compare(p,q,a[0],a[1]);
	if(s==-1) s=0;
	return(modularValue(s,p,q));
    }

    public static int[] modularValue(int choice,int p,int q) {
	int[] a=MathRational.evenPredecessor(p,q);
	boolean test=false;
	int n=0;
	int[] d={a[0],a[1]};
	while(test==false) {
	    int[] c=modularSuccessor(choice,n,a[0],a[1]);
	    if((c[1]>a[1])&&(c[1]<q)) {
		d[0]=c[0];
		d[1]=c[1];
	    }
	    ++n;
	    if(c[1]==q) {
		int[] X={choice,n-1};
		return(X);
	    }
	}
	int[] B={0,0};
	return(B);
    }




    public static int compare(int a,int b,int c,int d) {
	if(a*d>b*c) return(1);
	return(-1);
    }



    public static MathRational[] getModularSequence(int a,int b) {
	int s=(a*b)%2;
	if(s==1) return(null);
	int p=a;
	int q=b;
	MathRational[] R=new MathRational[100];
	int count=0;
	int len=0;
        while((count<100)&&(q>1)) { 
	    R[count]=new MathRational(p,q);
	    int[] x=modularPredecessor(p,q);
	    p=x[0];
	    q=x[1];  
            ++count;
	}
	if(count>98) return(null);
	MathRational[] R2=new MathRational[count];
	for(int i=0;i<count;++i) R2[i]=new MathRational(R[i].p,R[i].q);
	return(R2);
    }




}
