import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class MathRational {
    public int p;  //numerator
     public int q;  //denominator
    public int code;
   public  int level;

    public MathRational(int p,int q) {
	this.p=p;
	this.q=q;
	this.code=0;
	this.level=0;
    }

    public MathRational() {}


    /*This first routine implements the extended Euclidean algorithm.
      This is to say that program takes integers a,b and finds not
      only g=gcd(a,b) but also integers c,d such that ac+bd=g.  I 
      originally had programmed my own version of the Euclidean algorithm,
      but I lifted this algorithm from the internet.  The algorithm is
      taken from Donald Knuth's book of algorithms.*/


public static int[] GCDe(int a,int b) {

  int u,v,g;
  int u1,v1,g1;
  int t1,t2,t3;
  int q;
  u  = 1;  
  v  = 0;  
  g  = a;
  u1 = 0;  
  v1 = 1;  
  g1 = b;
  while (g1 != 0) {
    q = g/g1; 
    t1 = u - q*u1;   
    t2 = v - q*v1;   
    t3 = g - q*g1;
    u  = u1;   
    v  = v1;    
    g  = g1;
    u1 = t1;    
    v1 = t2;    
    g1 = t3;
  }
  int[] x={u,v,g};
  return(x);
}


    /*This just computes the greatest common divisor, without the coefficients.*/

    public static int GCD(int a,int b) {
	int[] x=GCDe(a,b);
	return(x[2]);
    }


    public static MathRational reduce(MathRational F) {
	int k=GCD(F.p,F.q);
	MathRational G=new MathRational(F.p/k,F.q/k);
	return(G);
    }

    public static int[] reduce(int a,int b) {
	int c=GCD(a,b);
	int[] d={a/c,b/c};
	return(d);
    }






    /*In the notation of the monograph, these routines compute A+ and A-, the two
      simpler rationals that are Farey related to A=a/b.*/


    public static int[] RMINUS(int a,int b) {

	if(a==1) {
	    int[] x={0,1};
	    return(x);
	}

	int[] d=GCDe(a,b);
	d[1]=-d[1];
	int t=(int)(Math.floor(1.0*d[0]/b));
	d[0]=d[0]-t*b;
	d[1]=d[1]-t*a;
	int[] e={d[1],d[0]};
	return(e);
    }


    public static int[] RPLUS(int a,int b) {

	int[] x = RMINUS(a,b);
	int[] y={a-x[0],b-x[1]};
	return(y);
    }

    //for even rationals

    public static int[] oddPredecessor(int a,int b) {
	int[] d1=RPLUS(a,b);
	int[] d2=RMINUS(a,b);
	int test=(d1[0]*d1[1])%2;
	if(test==1) return(d1);
	return(d2);
    }

    public static int[] evenPredecessor(int a,int b) {
	int[] d1=RPLUS(a,b);
	int[] d2=RMINUS(a,b);
	int test=(d1[0]*d1[1])%2;
	if(test==1) return(d2);
	return(d1);
    }

    public static int[] sameType(int a,int b) {
	int test1=(a*b)%2;
	int[] d1=RPLUS(a,b);
	int[] d2=RMINUS(a,b);
	int test2=(d1[0]*d1[1])%2;
	if(test2!=test1) return(d2);
	return(d1);
    }

    public static int[] oppositeType(int a,int b) {
	int test1=(a*b)%2;
	int[] d1=RPLUS(a,b);
	int[] d2=RMINUS(a,b);
	int test2=(d1[0]*d1[1])%2;
	if(test2==test1) return(d2);
	return(d1);
    }


    public static int gap0(int p,int q) {
	int[] a=MathRational.oppositeType(p,q);
	return (a[0]+a[1])/2;
    }

    public static double gap(int p,int q) {
	double d=1.0*gap0(p,q)/(p+q);
	System.out.println("gap "+d);
	return d;

    }


    public static int getInverse(int p,int q) {
	for(int i=0;i<p+q;++i) {
	    int test=((q-p)*i)%(p+q);
	    if(test==1) return(i);
	}
	return(1);
    }



    /**plaid subdivision*/
    public static int[] layerToFraction(int[] y) {
	for(int i=0;i<y[0]/2;++i) {
	    int c=GCD(i,y[0]-i);
	    if(c==1) {
		int g=gap0(i,y[0]-i);
		if(g==y[1]) {
		    int[] P={i,y[0]-i};
		    return(P);
		}
	    }
	}

	return null;
    }

    public static int[] fractionToLayer(int[] x) {
	int r=x[0]+x[1];
	int s=gap0(x[0],x[1]);
	int[] R={r,s};
	return(R);
    }

    public static void printPlaid(int[] a) {
	System.out.println("plaid sequence");
	int[][] c=plaidSequence(a);
	int b0=a[1];
	int b1=a[0]-2*a[1];

	for(int i=0;i<c.length;++i) {
	    int a0=c[i][0];
	    int a1=c[i][1];   
            int a2=a0-2*a1;
	    boolean test=false;
	    if((i==0)||(a0==b0)||(a0==b1)) test=true;
	    if(test==false) System.out.print(" ");
	    if(test==true) System.out.print("*");

            System.out.print(a0+"   "+a1+" "+a2+" "+a1+"   ");
	    int[] p=layerToFraction(c[i]);
	    if(p!=null) {
	        double d=1.0*p[0]/p[1];
	        System.out.println(p[0]+"/"+p[1]+"  "+d);
	    }
	    else System.out.println(" odd");
	}
    }


    public static int[][] plaidSequence(int[] a) {
	int[][] c=new int[a[0]][2];
        int count=0;
	c[0][0]=a[0];
	c[0][1]=a[1];
	count=1;
	boolean test=true;
	while(test==true) {
	    int[] d=derive(c[count-1]); 
	    c[count][0]=d[0];
	    c[count][1]=d[1];
	    if(d[0]<2) test=false;
            ++count;  
	}
	c=ListHelp.trimList(c,count);
	return(c);
    }
 


    public static int[] derive(int[] a) {
	int[] b={a[0]-a[1],a[1]};
	if(b[1]>1.0*b[0]/2) b[1]=b[0]-b[1];
	return(b);
    }


    public static MathRational[] getEvenSequence(int a,int b) {
	int s=(a*b)%2;
	if(s==1) return(null);
	int p=a;
	int q=b;
	MathRational[] R=new MathRational[100];
	int count=0;
	int len=0;
        while((count<100)&&(q>1)) { 
	    R[count]=new MathRational(p,q);
	    int[] x=evenPredecessor(p,q);
	    p=x[0];
	    q=x[1];  
            ++count;
	}
	if(count>98) return(null);
	MathRational[] R2=new MathRational[count];
	for(int i=0;i<count;++i) R2[i]=new MathRational(R[i].p,R[i].q);
	return(R2);
    }

}
