import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This is the class for the main control window.*/


public class ModularCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    MathRational[] RAT=new MathRational[500];
    ListenSquare[] SCALE=new ListenSquare[500];
    Lever EDGE;
    SelectInteger STEP;

    int COUNT=0;
    int SPOT=0;
    ListenSquare CONTROL;


     public ModularCanvas() {
	 addMouseListener(this);
  	 addMouseMotionListener(this);
 	 addKeyListener(this);
	 setScales(50,150,200);
	 CONTROL=new ListenSquare(0,0,0,24);
	 for(int i=0;i<500;++i) SCALE[i]=new ListenSquare(100+12*i,0,12,12);
	 EDGE=new Lever(0,0,1,2);
	 STEP=new SelectInteger(40,0,40,20,1,1,12,1);
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      setModularSequence();
      renderList(g);
      drawControls(g);
   }

    public void drawControls(Graphics2D g) {
	CONTROL.w=this.getWidth();
	CONTROL.render(g,new Color(0,0,255));
	STEP.render(g,Color.red,Color.white,Color.white);
	EDGE.render(g,"",Color.red);
	int s=STEP.val;
        for(int i=0;i<COUNT;++i) {
	     Color C=new Color(180,0,180);
	     if(i%s==0) C=new Color(100,0,100);
	     if(i==SPOT) C=new Color(255,255,0);
             SCALE[i].render(g,C);
	}
	int p=1;
	int q=2;
	try{
	  p=RAT[SPOT].p;
	  q=RAT[SPOT].q;
	}
	catch(Exception e) {}
    }


    public void setModularSequence() {
	int p=M.p();
	int q=M.q();
	if(p>=q) return;
	int c=MathRational.GCD(p,q);
	if(c>1) return;

	if((p*q)%2==1) {
	    COUNT=0;
            return;
	}
	MathRational[] R=MathRational.getEvenSequence(p,q);
	COUNT=R.length;
	for(int i=0;i<COUNT;++i) RAT[i]=new MathRational(R[i].p,R[i].q);
    }

    /**the background*/

    public void drawBG(Graphics2D g) {
	g.setColor(Color.black);
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(Color.white);
 	g.drawRect(0,0,getWidth()-1,getHeight()-1);
	GeneralPath gp=new GeneralPath();
	gp.moveTo(0,0);
	gp.lineTo(1,0);
	gp=transform(gp);
	g.setColor(new Color(60,70,80));
	g.draw(gp);
	edge(0,g,0,1,1,1,Color.yellow);
    }

    public void renderList(Graphics2D g) {
	for(int i=0;i<COUNT-1;++i) {
	    edge(1,g,RAT[i].p,RAT[i].q,RAT[i+1].p,RAT[i+1].q,new Color(255,0,255));
	}
	for(int i=0;i<COUNT-1;++i) {
	    for(int j=i+1;j<COUNT;++j) {
		renderPair(g,RAT[i].p,RAT[i].q,RAT[j].p,RAT[j].q);
	    }
	}
	for(int i=0;i<COUNT;++i){
	    renderPoint(g,RAT[i]);
	}
    }


    public void renderPair(Graphics2D g,int a1,int b1,int a2,int b2) {
	int k=a1*b2-a2*b1;
	if(k<0) k=-k;
	if(k==1) edge(0,g,a1,b1,a2,b2,new Color(0,255,255));
    }

    public void renderPoint(Graphics2D g,MathRational X) {
	Color C=Color.red;
	if(X.p%2==0) C=new Color(50,100,255);
	if(X.q%2==0) C=new Color(0,150,0);
	renderPoint(g,X.p,X.q,C);
    }


    public void renderPoint(Graphics2D g,int p,int q,Color C) {
	double d=1.0*p/q;
	Integer P=new Integer(p);
	Integer Q=new Integer(q);
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(d-5),-15);
	gp.lineTo((float)(d+5),-15);
	gp.reset();
	double r=1.0/(32*q*q);
	if(r>.001) r=.001;
	fillPoint(g,new Complex(d,0),r,C,32);
    }


    public void edge(int ss,Graphics2D g,int a1,int b1,int a2,int b2,Color C) {
	if(EDGE.val==0) edge0(ss,g,a1,b1,a2,b2,C);
	if(EDGE.val==1) edge1(ss,g,a1,b1,a2,b2,C);
    }
 

    public void edge0(int ss,Graphics2D g,int a1,int b1,int a2,int b2,Color C) {
	double d1=1.0*a1/b1;
	double d2=1.0*a2/b2;
	double d3=.5*d1+.5*d2;
	double r=Math.abs(d3-d1);
	GeneralPath gp=new GeneralPath();
	if(ss==0) {
	    gp.moveTo(d1,0);
	    gp.lineTo(d3,r);
	    gp.lineTo(d2,0);
	}
	else {
	    gp.moveTo(d1,0);
	    gp.lineTo(d3,-r);
	    gp.lineTo(d2,0);
	}
	gp=transform(gp);
	g.setColor(C);
	g.draw(gp);
    }


    public void edge1(int ss,Graphics2D g,int a1,int b1,int a2,int b2,Color C) {
	double d1=1.0*a1/b1;
	double d2=1.0*a2/b2;
	double d3=.5*d1+.5*d2;
	double r=Math.abs(d3-d1);
	GeneralPath gp=new GeneralPath();
	int[] a={0,256};
	if(ss==1) {
	    a[0]=256;
	    a[1]=512;
	}
	for(int i=a[0];i<=a[1];++i) {
	    double t=1.0*i/512;
	    double c=d3+r*Math.cos(2*Math.PI*t);
	    double s= 0+r*Math.sin(2*Math.PI*t);
	    if(i==a[0]) gp.moveTo((float)(c),(float)(s));
	    if(i!=a[0]) gp.lineTo((float)(c),(float)(s));
	}
	gp=transform(gp);
	g.setColor(C);
	g.draw(gp);
    }




    public void doScaling(Point X) {
	for(int i=0;i<COUNT;++i) {
	    if(SCALE[i].inside(X)==1) {
		SPOT=i;
		doScale();
	    }
	}
    }

    public void doScale() {
	int p1=RAT[SPOT+0].p;
	int q1=RAT[SPOT+0].q;
	int p2=0;
	int q2=1;
	try{
	   p2=RAT[SPOT+1].p;
	   q2=RAT[SPOT+1].q;
	}
	catch(Exception e) {}
	double a1=1.0*p1/q1;
	double a2=1.0*p2/q2;
	double w=Math.abs(a1-a2);
	double a=Math.min(a1,a2);
	double s=200/w;
	a=50-a*s;
	setScales(a,150,s);
	System.out.println(p1+" "+q1);
	GraphicsHelp.scaleNicely(M.P,p1,q1);
    }


    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e); 
	if(CONTROL.inside(J.X)==0) {
           if(J.mode==1)  scaleUp(J.X,0);
           if(J.mode==3)  scaleUp(J.X,1);
	}
	else {
	    doScaling(J.X); 
            EDGE.process(J.X);
	    STEP.modify(J.X);
	}
	repaint();
	M.P.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

   public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }
    public void mouseExited(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {	
    }

    public void keyTyped(KeyEvent e) {
	char c=e.getKeyChar();
	if(c=='q') setScales(50,250,400);
	repaint();
    }
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

