import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Parameter {
    int x,y;
    String HISTORY;
    boolean ACTIVE;
    ListenSquare MAIN,TEXT,FRACTION,CF,QI,REDUCE,RIM;
    ListenSquare RANDOM,ASSIGN,PLAID1,PLAID2;
    SelectInteger GRID;
    SelectIntegerKeyboard GAP0,GAP1,TERM,RAND;
    Color COLOR;
    String S;

    public Parameter(int xx,int yy,String s) {
	this.x=xx;
	this.y=yy;
	this.S=s;
	TEXT=new ListenSquare(x,y,400,40);
	ACTIVE=false;
	COLOR=Color.blue;
	TERM=new SelectIntegerKeyboard(x+3,y+42,40,16,5);
	RAND=new SelectIntegerKeyboard(x+47,y+82,40,16,200);
	GAP1=new SelectIntegerKeyboard(x+47,y+63,33,16,34);
	GAP0=new SelectIntegerKeyboard(x+83,y+63,33,16,21);
	GRID=new SelectInteger(x+120,y+62,30,16,3,1,50,1);

	FRACTION=new ListenSquare(x,y+20,45,18);
	REDUCE=new ListenSquare(x+47,y+20,45,18);
	QI=new ListenSquare(x+95,y+20,44,18);
	CF=new ListenSquare(x+141,y+20,30,18);
        RIM=new ListenSquare(x+173,y+20,27,18);
	MAIN=new ListenSquare(x,y,415,40);
        PLAID1=new ListenSquare(x+121,y+42,38,18);
        PLAID2=new ListenSquare(x+161,y+42,39,18);
        RANDOM=new ListenSquare(x,y+82,45,18);
        ASSIGN=new ListenSquare(x+47,y+42,69,18);
	HISTORY="";
    }


    public void render(Graphics2D g) {

	drawBG(g);
	g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.drawString(S,x+5,y+15);
	RAND.render(g,new Color(150,0,0),Color.black,Color.white,Color.white);
	TERM.render(g,new Color(200,0,200),Color.black,Color.white,Color.white);
	GAP0.render(g,new Color(0,150,150),Color.black,Color.white,Color.white);
	GAP1.render(g,new Color(0,150,150),Color.black,Color.white,Color.white);
	GRID.render(g,new Color(0,140,140),Color.white,Color.white);
	QI.render(g,new Color(0,0,150));
	CF.render(g,new Color(0,0,150));
	RIM.render(g,new Color(0,0,150));
	FRACTION.render(g,new Color(200,0,200));
	REDUCE.render(g,new Color(0,0,150));
	PLAID1.render(g,new Color(0,140,140));
	PLAID2.render(g,new Color(0,140,140));
	RANDOM.render(g,new Color(150,0,0));
	ASSIGN.render(g,new Color(0,140,140));

	g.setColor(Color.white);
	g.drawString("cfe",(int)(CF.x+5),(int)(CF.y+13));
	g.drawString("rim",(int)(RIM.x+5),(int)(RIM.y+13));
	g.drawString("plaid",(int)(PLAID1.x+5),(int)(PLAID1.y+13));
	g.drawString("plaid",(int)(PLAID2.x+5),(int)(PLAID2.y+13));
	g.drawString("random",(int)(RANDOM.x+5),(int)(RANDOM.y+13));
	g.drawString("qi mem",(int)(QI.x+5),(int)(QI.y+13));
	g.drawString("fraction",(int)(FRACTION.x+5),(int)(FRACTION.y+13));
	g.drawString("reduce",(int)(REDUCE.x+5),(int)(REDUCE.y+13));
	g.drawString("cross vals",(int)(ASSIGN.x+5),(int)(ASSIGN.y+13));
    }

    public void drawBG(Graphics2D g) {
	g.setColor(Color.blue);
	g.fillRect(x,y,205,100);
	g.setColor(Color.white);
	g.drawRect(x,y,205,100);
    }

    public void activate(Point X) {
	ACTIVE=false;
	if(TEXT.inside(X)==1) ACTIVE=true;
    }


    /**This decides if we are looking at
       0. a rational
       1. a quadratic irrational
       2. a continued fraction expansion.
       This isn't a very smart routine; it just
       looks for one characteristic feature.
       The routine returns -1 if there is more
       than one characteristic.*/

    public int classify() {
	int c0=countChar(S,'*');
	int c1=countChar(S,':');
	int c2=countChar(S,'/');
	int c3=countChar(S,'(');
	int c4=countChar(S,')');
	if(c3!=c4) return(-1);
	if(c1>0) return(2);
	if(c3>0) return(1);
	if(c0>0) return(3);
	return(0);
    }

    public int[] interpretFraction() {
	return(interpretFraction(S));
    }

    public int[] interpretFraction(String U) {
	int k=U.indexOf("/");
	if(k==-1) {
	    U=U.replace(" ","");
	    Integer I=new Integer(U);
	    int[] a={I.intValue(),1};
	    return(a);
	}
	String T1=U.substring(0,k);
	String T2=U.substring(k+1,U.length());
	Integer I1=new Integer(T1);
	Integer I2=new Integer(T2);
	int[] I={I1.intValue(),I2.intValue()};
	return(I);
    }


    public int[] interpretCFE() {
	int[] y=interpretSEQ(':');
	return(y);
    }


    public int[] interpretLayer() {
	int[] y=interpretSEQ('*');
	return(MathRational.layerToFraction(y));
    }

    public int[] interpretSEQ(char u) {
	int count=1;
	int[] x=new int[50];
	x[0]=-1;
	int s=S.length();
	if(S.charAt(s-1)==u) S=S.substring(0,s-1);
	for(int i=0;i<s;++i) {
	    if(S.charAt(i)==u) {
		x[count]=i;
		++count;
	    }
	}
	x[count]=s;

	int[] y=new int[count];
	for(int i=0;i<count;++i) {
	    String T=S.substring(x[i]+1,x[i+1]);
	    Integer t=new Integer(T);
	    y[i]=t.intValue();
	}
	return(y);
    }



    public int[] interpretQI() {
	int k1=S.indexOf("+");
	int k2=S.indexOf("(");
	int k3=S.indexOf(")");
	String S1=S.substring(0,k1);
	String S2=S.substring(k1+1,k2);
	String S3=S.substring(k2+1,k3);

	S1=S1.replace(" ","");
	S2=S2.replace(" ","");
	S3=S3.replace(" ","");

	int[] a1=interpretFraction(S1);
	int[] a2=interpretFraction(S2);
	Integer b=new Integer(S3);
	int a3=b.intValue();
	int[] c={a1[0],a1[1],a2[0],a2[1],a3};
	return(c);
    }

    public int[] convertQItoFraction() {
       int[] a=interpretQI();
       double d=1.0*a[0]/a[1]+1.0*a[2]/a[3]*Math.sqrt(a[4]);
       d=d-Math.floor(d);
       double tol=Math.pow(.1,TERM.val);
       MathRational P=MathApproximation.approximate0(d,tol);
       int[] p={(int)(P.p),(int)(P.q)};
       return(p);
    }


    public int countChar(String T,char x) {
	int count=0;
	int n=T.length();
	for(int i=0;i<n;++i) {
	    char ch=T.charAt(i);
	    if(ch==x) ++count;
	}
	return(count);
    }

    public boolean convert(Point X) {
	int c=classify();

	if(CF.inside(X)==1) {
	    if(c==0) fractionToCFE();
	    if(c==1) qiToCFE();
	}

	if(FRACTION.inside(X)==1) {
	    if(c==1) qiToFraction();
	    if(c==2) cfeToFraction();  
	    if(c==3) layerToFraction();
	}

	if(QI.inside(X)==1) {
	    if(HISTORY.length()>0) S=new String(HISTORY);
	}

	return(true);
    }

    public boolean layerToFraction() {
	int[] a=interpretLayer();
	acceptFraction(a);
	return(true);
    }

    public boolean cfeToFraction() {
	int[] a=interpretCFE();
	long[] b=MathContinuedFractions.toFraction(a);
	acceptFraction(b);
	return(true);
    }

    public boolean qiToFraction() {
       int[] a=interpretQI();
       double d=1.0*a[0]/a[1]+1.0*a[2]/a[3]*Math.sqrt(a[4]);
       d=d-Math.floor(d);
       double tol=Math.pow(.1,TERM.val);
       MathRational P=MathApproximation.approximate0(d,tol);
       long[] p={P.p,P.q};	
       HISTORY=new String(S);
       acceptFraction(p);
       return(true);
    }



    public boolean fractionToCFE() {
       int[] a=interpretFraction();
       if(a[0]<=0) return(false);
       if(a[1]<=0) return(false);
       int[] b=MathContinuedFractions.cfe(a);
       acceptCFE(b);
       return(true);
    }

    public boolean qiToCFE() {
       int[] a=interpretQI();
       double d=1.0*a[0]/a[1]+1.0*a[2]/a[3]*Math.sqrt(a[4]);
       d=d-Math.floor(d);
       double tol=Math.pow(.1,TERM.val);
       int[] p=MathApproximation.approximate(d,tol);
       int[] b=MathContinuedFractions.cfe(p);   
       HISTORY=new String(S);
       acceptCFE(b);
       return(true);
    }



    public void acceptCFE(int[] a) {
	acceptSEQ(a,":");
    }

    public boolean acceptSEQ(int[] a,String u) {
	if(a.length==1) return(false);
         String T="";
	 for(int i=0;i<a.length;++i) {
	    Integer A=new Integer(a[i]);
	    if(i<a.length-1) T=T+A.toString()+u;
	    else{T=T+A.toString();}
	 }
	 S=new String(T);
	 if(S.length()>35) S=S.substring(0,35);
	 return(true);
    }



    public boolean acceptFraction(int[] b) {
	long[] c={b[0],b[1]};
	acceptFraction(c);
	return(true);
    }

    public boolean acceptFraction(long[] b) {
	if(b[0]<=0) return(false);
	if(b[1]<=0) return(false);
	Long b0=new Long(b[0]);
	Long b1=new Long(b[1]);
	S=b0.toString()+"/"+b1.toString();
	return(true);
    }



    public void reduce() {
	int[] x=interpretFraction();
        int s=MathRational.GCD(x[0],x[1]);
	x[0]=x[0]/s;
	x[1]=x[1]/s;
	acceptFraction(x);
    }



    public void getRim() {
	int[] x=interpretFraction();
	int[] R=MathRational.fractionToLayer(x);
	Integer r0=new Integer(R[1]);
	Integer s0=new Integer(R[0]);
	S=s0.toString()+"*"+r0.toString();
	MathRational.printPlaid(R);
    }


    public void assign() {
	int[] x=getFraction();
	GAP0.val=x[0];
	GAP1.val=x[1];
    }



    public void getRandom() {
	boolean test=false;
	int[] a={};
	while(test==false) {
	      int c=(int)(RAND.val*Math.random());
	      int b=(int)(RAND.val*Math.random());
	      if((b>0)&&(c>b)) {
	        a=MathRational.reduce(b,c);
	        if((a[0]*a[1])%2==0) {
		    test=true;
		}
	      }
	}
	Integer A0=new Integer(a[0]);
	Integer A1=new Integer(a[1]);
	S=A0.toString()+"/"+A1.toString();
	return;
    }

    public void getPlaid(int mode) {
	int gap0=GAP0.val;
	int gap1=GAP1.val;
	int depth=GRID.val;
	int TRY=100000;
        int[] a=GridGenerator.inverse(mode,gap0,gap1,depth,TRY);
	if(a!=null) {
	    Integer A0=new Integer(a[0]);
	    Integer A1=new Integer(a[1]);
	    S=A0.toString()+"/"+A1.toString();
	}
	return;
    }

    public double getParameter() {
	int c=classify();

	if(c==0) {
	    int[] b=interpretFraction();
	    double y=1.0*b[0]/b[1]; 
	    return(y);
	}

	if(c==1) { 
            int[] a=interpretQI();
            double y=1.0*a[0]/a[1]+1.0*a[2]/a[3]*Math.sqrt(a[4]);
	    return(y);
	}

	if(c==2) {
	   int[] a=interpretCFE();
	   long[] b=MathContinuedFractions.toFraction(a);
	   double y=1.0*b[0]/b[1];
	   return(y);
	}
	return(.5);
    }

    public int getNumerator() {
	int[] a=getFraction();
	return(a[0]);
    }

    public int getDenominator() {
	int[] a=getFraction();
	return(a[1]);
    }

    public int getInverse() {
	int p=getNumerator();
	int q=getDenominator();
	return(MathRational.getInverse(p,q));
    }


    public int[] getFraction() {
	int q=classify();
	if(q==0) return(interpretFraction());
	if(q==1) return(convertQItoFraction());
	if(q==2) {
	   int[] a=interpretCFE();
	   long[] b=MathContinuedFractions.toFraction(a);
	   int[] c={(int)(b[0]),(int)(b[1])};
	   return(c);
	}
	if(q==3) {
	    int[] c=interpretLayer();
	    if(c!=null) return(c);
	}
	int[] a={1,2};
	return(a);
    }



    /*testing whether the selector is used*/

    public boolean inside(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(MAIN.inside(J.X)==1) return(true);
	return(false);
    }

    public boolean inside(Point X) {
	if(MAIN.inside(X)==1) return(true);
	return(false);
    }

    public int plaidInside(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(PLAID1.inside(J.X)==1) return(1);
	if(PLAID2.inside(J.X)==1) return(0);
	return(0);
    }


    public void setIntegerEntries(Point X) {
	GAP0.on=0;
	GAP1.on=0;
	TERM.on=0;
	RAND.on=0;
	if(GAP0.inside(X)==1) GAP0.on=1;
	if(GAP1.inside(X)==1) GAP1.on=1;
	if(TERM.inside(X)==1) TERM.on=1;
	if(RAND.inside(X)==1) RAND.on=1;
    }



    public void process(MouseEvent e) {
	MouseData J=MouseData.process(e);
	activate(J.X);
	if(ASSIGN.inside(J.X)==1) assign();
	GRID.modify(J.X);
	setIntegerEntries(J.X);  
        if(RANDOM.inside(J.X)==1) getRandom();
	try {
             convert(J.X);
	     if(REDUCE.inside(J.X)==1) reduce();
	     if(PLAID1.inside(J.X)==1) getPlaid(0);
	     if(PLAID2.inside(J.X)==1) getPlaid(1);
	     if(RIM.inside(J.X)==1) getRim();
	}
        catch(Exception ee) {}
    }


    public boolean processKey(KeyEvent e) {
	if(GAP0.on==1) GAP0.modify(e);
	if(GAP1.on==1) GAP1.modify(e);
	if(TERM.on==1) TERM.modify(e);
	if(RAND.on==1) RAND.modify(e);
	if(ACTIVE==false) return(false);
	int n=S.length();

	char ch=e.getKeyChar();

        if(isDigit(ch)==true) S=S+ch;

	int val=0;
	val=(int)(ch-'/');
	if(val==0) S=S+"/";

	val=(int)(ch-'(');
	if(val==0) S=S+"(";

	val=(int)(ch-':');
	if(val==0) S=S+":";

	val=(int)(ch-'*');
	if(val==0) S=S+"*";

	val=(int)(ch-')');
	if(val==0) S=S+")";

	val=(int)(ch-'+');
	if(val==0) S=S+"+";

	val=(int)(ch-'-');
	if(val==0) S=S+"-";

	val=(int)(ch-' ');
	if(val==0) S=S+" ";


        if (ch==KeyEvent.VK_BACK_SPACE) {
	    if(n>0) S=S.substring(0,n-1);
        }

        if (ch==KeyEvent.VK_DELETE) {
            S="1/2";
        }
	if(S.length()>50) S=S.substring(0,n-1);
	return(true);

    }

    public boolean isDigit(char ch) {
        int val=(int)(ch-'0');
        if ((val>=0)&&(val<=9)) {
	    return(true);
	}
	return(false);
    }


}





