import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


/**This file controls the arithmetic graph window.*/



public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Complex SOURCE;
    AGCompute CAG;
    BoxCompute CBM;
    Point JX;
    SelectIntegerKeyboard[] I=new SelectIntegerKeyboard[5];
    ListenSquare[] L=new ListenSquare[3];  
    SelectInteger[] IS=new SelectInteger[5];
    int WRAP;
    int JUMP;
    DoubleEntry DX,DY;
    ListenSquare MOVE;

    Color[] ORBITCOLOR=new Color[10000];
    GeneralPath[] ORBIT=new GeneralPath[10000];
    int[] STYLE=new int[10000];
    int[][] RAT=new int[10000][2];

    Color[] BLOCKCOLOR=new Color[200000];
    GeneralPath[] BLOCK=new GeneralPath[200000];

    Complex[] CROSS=new Complex[100000];

    BoxModel[] BOX=new BoxModel[100000];


    int SELECT=-1;
    int crosscount=0;
    int orbitcount=0;
    int blockcount=0;
    int boxcount=0;

    public PictureCanvas() {
        addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);
        SOURCE=new Complex(0,0);
	L[0]=new ListenSquare(0,0,80,60,Color.white); L[0].on=1;
	setScales(10,488,420);
	DX=new DoubleEntry(5,20,".0");
	DY=new DoubleEntry(90,20,".0");
	MOVE=new ListenSquare(175,20,20,20);
	WRAP=0;
	JUMP=0;
    }

    public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);

      //background
      g.setColor(new Color(0,150,150));
      g.fillRect(0,0,this.getWidth(),this.getHeight());
      fillPeriodBox(g);
      drawBoxes(g);  
      drawLines(g); 
      drawBlocks(g);
      drawOrbits(g);
      drawCrossings(g); 
      drawMarker(g);
      drawPeriodBox(g);
      drawFineGrid(g);
      drawControls(g);
      g.drawRect(0,0,this.getWidth()-1,this.getHeight()-1);
    }


    public void drawControls(Graphics2D g) {
	L[0].w=getWidth()-1;
	L[0].render(g,new Color(200,0,200));
        g.setFont(new Font("Helvetica",Font.PLAIN,12));	
	g.setColor(Color.white);
        g.drawString("origin (o)",75,53);
        g.drawString("reset (p)",5,53);
        g.drawString("delete (r)",230,13);
        g.drawString("fit (t)",230,33);
        g.drawString("recolor (y)",230,53);

        g.drawString("jump zone + (j,q)",320,33);
        g.drawString("jump zone - (k,w)",320,53);
	Double x=new Double(SOURCE.x);
	Double y=new Double(SOURCE.y);
	String sx=x.toString();
	String sy=y.toString();
	if(sx.length()>12) sx=sx.substring(0,11);
	if(sy.length()>12) sy=sy.substring(0,11);
	g.drawString(sx,5,13);
	g.drawString(sy,90,13);
	DX.render(g);
	DY.render(g);
	MOVE.render(g,Color.blue);
	Integer J=new Integer(JUMP);
	g.drawString("zone "+J.toString(),320,13);
    }




    /**These are all the auxilliary markings.*/

    public void drawLines(Graphics2D g) {
	for(int i=0;i<8;++i) {
	   if(M.C.GRID.oct[i]==1) GridOct.drawGrid(i,g,M);
	}
	for(int i=0;i<4;++i) {
           if(M.C.GRID.ari[i]==1) GridAri.drawGrid(i,g,M); 
	}
    }

    public void drawMarker(Graphics2D g) {
       if(M.C.GRAPH.BASIC.L[0].on==1) {
         Color C=M.C.GRAPH.BASIC.M[0].C;
         Displays.drawMarker(g,C,M);
       }
    }

    public void fillPeriodBox(Graphics2D g) { 
         if(M.C.GRAPH.BASIC.L[1].on==1) {
	    Displays.fillPeriodBox(g,M);
	 }
    }	

    public void drawPeriodBox(Graphics2D g) { 
	if(M.C.GRAPH.BASIC.L[1].on==1) {
            Color C=M.C.GRAPH.BASIC.M[1].C;
            Displays.drawPeriodBox(g,C,M);
	}
    }

    public void drawFineGrid(Graphics2D g) {
      if(M.C.GRAPH.BASIC.L[2].on==1) {
	Color C=M.C.GRAPH.BASIC.M[2].C;
	Displays.drawFineGrid(g,C,M);
      }
    }



    /**main plotting routines*/

    public void drawBlocks(Graphics2D g) {
	int thickness=1;
	GeneralPath gp2=new GeneralPath();

	GeneralPath gp=new GeneralPath();
	for(int i=0;i<blockcount;++i) {
	  g.setColor(BLOCKCOLOR[i]);
	  gp=new GeneralPath(BLOCK[i]);
          gp=transform(gp);
	  g.setColor(BLOCKCOLOR[i]);
	  g.draw(gp);
	}
    }

    public void drawBoxes(Graphics2D g) {
	for(int i=0;i<boxcount;++i) {
	    BoxRender.main(g,M,BOX[i],0);
	}
	for(int i=0;i<boxcount;++i) {
	    BoxRender.main(g,M,BOX[i],1);
	}
    }

    public void drawOrbits(Graphics2D g) {
	int thickness=1;
	GeneralPath gp2=new GeneralPath();

	GeneralPath gp=new GeneralPath();
	for(int i=0;i<orbitcount;++i) {
	  g.setColor(ORBITCOLOR[i]);
	  gp=new GeneralPath(ORBIT[i]);
          gp=transform(gp);

	  if(STYLE[i]==0) {
	     g.setColor(ORBITCOLOR[i]);
	     g.draw(gp);
	  }

	  if(STYLE[i]==1) {
	     g.setColor(ORBITCOLOR[i]);
	     g.fill(gp);
	     g.setColor(Color.white);
	     g.draw(gp);
	  }
	}
    }

    public void drawCrossings(Graphics2D g) {
	int p=M.p();
	int q=M.q();
	int on2=M.C.GRID.MAIN.L[2].on;
	int on3=M.C.GRID.MAIN.L[3].on;
	int on4=M.C.GRID.MAIN.L[4].on;
	int num=M.C.GRID.ARI_CHOICE.val;
	Color C=new Color(0,0,0,0);
	Color C0=M.C.GRID.MAIN.M[2].C;
	Color C1=M.C.GRID.MAIN.M[3].C;
	GeneralPath gp=new GeneralPath();
	int style=M.C.GRID.CROSS.mode;
	for(int i=0;i<crosscount;++i) {	
	    if((on2==0)&&(CROSS[i].CHARGE==0)) g.setColor(C);
	    if((on3==0)&&(CROSS[i].CHARGE==1)) g.setColor(C);
	    if((on2==1)&&(CROSS[i].CHARGE==0)) g.setColor(C0);
	    if((on3==1)&&(CROSS[i].CHARGE==1)) g.setColor(C1);
	    if((on4==1)&&(CROSS[i].MASS!=num)) g.setColor(C);
	    if(style==0) gp=GraphicsHelp.makeDot(CROSS[i]);
	    if(style==1) gp=GraphicsHelp.makeDot(CROSS[i],p,q);
            gp=transform(gp);
            if(style==0) g.setStroke(new BasicStroke(3));
            if(style==1) g.setStroke(new BasicStroke(1));
	    if((on4==1)&&(CROSS[i].MASS==num)) g.setStroke(new BasicStroke(5));
	    g.draw(gp);
	}
        g.setStroke(new BasicStroke(1));
    }



    /**Processing a newly selected cursor point*/

    public Complex getPoint(Point X) {
        Complex z=unTransform(X);
	return(z);
    }

    public void selectPoint(Point X) {
	Complex z=getPoint(X);
	int test=-1;
	for(int i=0;i<orbitcount;++i) {
	    if(ORBIT[i].intersects(z.x,z.y,1,1)==true) test=i;
	}
	if(test!=-1) SELECT=test;
	SOURCE=new Complex(z);
    }

    public void playBoxes() {
	BoxTracer.clean(BOX,boxcount);
	if(M.C.BOX.TRACE.mode==0) return;
	for(int i=0;i<boxcount;++i) {
	    int choice=BOX[i].contains(SOURCE);
	    if(choice>=0) traceOrbit(i,choice);
	}
    }

    public void traceOrbit(int i,int choice) {
	int[][] x=BoxTracer.orbit(BOX,boxcount,i,choice);
	if(x==null) return;
	int orient=GraphicsHelp.getOrientation(BOX,x);

 	for(int j=0;j<x.length;++j) {
	    int a0=x[j][0];
	    int a1=x[j][1];
	    int a2=x[j][2];
	    BOX[a0].HIGHLIGHT[a1]=1+orient;
	    BOX[a0].HIGHLIGHT[a2]=1+orient;
	}
    }



    /**Adding newly computed objects to lists of objects*/

    public void nextOrbit(GeneralPath X,int style,int p,int q,int pp,int qq) {
       GeneralPath Y=AGTransforms.inverseMap(p,q,X);
       ORBIT[orbitcount]=new GeneralPath(Y);
       STYLE[orbitcount]=style;
       ORBITCOLOR[orbitcount]=M.C.CS.C;
       RAT[orbitcount][0]=pp;
       RAT[orbitcount][1]=qq;
       ++orbitcount;
    }

    public void nextBlock(GeneralPath X,int p,int q) {
       GeneralPath Y=AGTransforms.inverseMap(p,q,X);
       BLOCK[blockcount]=new GeneralPath(Y);
       BLOCKCOLOR[blockcount]=M.C.GRAPH.BASIC.M[0].C;
       ++blockcount;
    }

    public void nextCross(Complex X) {
	CROSS[crosscount]=new Complex(X);
       ++crosscount;
    }

    public void nextBox(BoxModel X) {
	BOX[boxcount]=X;
        ++boxcount;
    }
    /**Done with the acquiring routines*/


    /**Some keyboard commands*/
    public void recolorCurrent() {
	if(SELECT!=-1) ORBITCOLOR[SELECT]=M.C.CS.C;
    }

    public void toOrigin() {
	SOURCE=new Complex(0,0);
	int a=this.getWidth();
	int b=this.getHeight()-80;
	if(a>b) a=b;
	setScales(10,a+68,a);
	WRAP=0;
	JUMP=0;
    }

    public void doOrbit(boolean erase) {
	if(erase==true) orbitcount=0;
	if(boxcount>0) {
	    for(int i=0;i<boxcount;++i) {
		int test=BOX[i].contains(SOURCE);
		if(test>=0) {
		    SOURCE=new Complex(BOX[i].Z[test]);
		}
	    }
	}
	forceGo(0,2);
    }
    public void doBlock(boolean erase) {
	if(erase==true) blockcount=0;
	forceGo(0,3);
    }

    public void jump1(int k) {
	int J=M.C.SES.getInverse();
	jump(k,J); 
        M.C.CBM=new BoxCompute(SOURCE,M);
           new Thread(M.C.CBM).start();
    }

    public void jump2(int k) {
	jump(k,1);
    }

    public void doMove() {
	double x=0;
	double y=0;
	try{
	  x=DX.value();
	  y=DY.value();
	}
	catch(Exception e) {}
	SOURCE=new Complex(x,y);
	double xx=A[0].getTranslateX();
	double yy=A[0].getTranslateY();
	double s=A[1].getScaleX();
	double x0=Math.floor(x);
	A[0]=AffineTransform.getTranslateInstance(xx-s*x0,yy);
	WRAP=(int)(Math.floor(x+.5));
    }

    public void jump(int k,int J) {
	double x=A[0].getTranslateX();
	double y=A[0].getTranslateY();
	int p=M.p();
	int q=M.q();
	int lim=2*(p+q);
	double s=A[1].getScaleX();
	int JJ=k*J;
	if(WRAP+k*J>=lim) JJ=k*J-lim;
	if(WRAP+k*J<=0) JJ=k*J+lim;
	double x1=s*JJ;
	WRAP=WRAP+JJ;
	A[0]=AffineTransform.getTranslateInstance(x-x1,y);
	SOURCE.x=SOURCE.x+JJ;
	crosscount=0;
	blockcount=0;
 	JUMP=JUMP+k;
	JUMP=(JUMP+10000*(p+q))%(2*p+2*q);
	CrossingModel.drawCrosses(this.M);
    }


    /**mouse events */
   public void mouseDragged(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {}
   public void mousePressed(MouseEvent e) {}
   public void mouseReleased(MouseEvent e) {}
   public void mouseEntered(MouseEvent e) {
      requestFocus();
   }

   public void mouseClicked(MouseEvent e) { 
       MouseData J=MouseData.process(e);
       doMouseClick(J.X,J.mode);
   }

   public void mouseMoved(MouseEvent e) {
       try {MouseData J=MouseData.process(e);
	   JX=J.X; }
       catch (Exception ee) {}
   }


   public void doMouseClick(Point X,int mode) { 
        int test=L[0].inside(X);
	if(test==1) {
	    DX.activate(X);
	    DY.activate(X);
	    if(MOVE.inside(X)==1) doMove();
	    repaint();
	    M.P.repaint();
	    M.S.repaint();
            return;
	}
        if(mode==1)  scaleUp(X,0);
        if(mode==3)  scaleUp(X,1);
	if(mode==2) {
	     selectPoint(X);
	     playBoxes();
	}
	repaint();
	M.C.repaint();
	doTest();
   }


    public void doTest() {
	int p=M.C.SES.getNumerator();
	int q=M.C.SES.getDenominator();
	double x=(p+q)*SOURCE.x;
	double y=(p+q)*SOURCE.y;

	double f0=Torus.f0(p,q,x,y);
	double F0=Torus.convert(p,q,f0);
	double f1=Torus.f1(p,q,x,y);
	double F1=Torus.convert(p,q,f1);

	double p0=Torus.P0(p,q,x,y);
	double P0=Torus.convert(p,q,p0);
	double q0=Torus.Q0(p,q,x,y);
	double Q0=Torus.convert(p,q,q0);
	double p1=Torus.P1(p,q,x,y);
	double P1=Torus.convert(p,q,p1);
	double q1=Torus.Q1(p,q,x,y);
	double Q1=Torus.convert(p,q,q1);


	System.out.println("domain "+x+" "+y);
	System.out.println("range: ");
	System.out.println("INFY      "+F0);
	System.out.println("ZERO      "+F1);
	System.out.println("01::+2p/(p+q) "+P0);
	System.out.println("45::-2p/(p+q) "+P1);
	System.out.println("23::+2q/(p+q) "+Q0);
	System.out.println("67::-2q/(p+q) "+Q1);

	double test1=P0+P1-F1;
	double test2=Q0+Q1-F1;
	double test3=-P0+Q1-F0;
	double test4=+P1-Q0-F0;

	System.out.println(test1);
	System.out.println(test2);
	System.out.println(test3);
	System.out.println(test4);
    }


/**done with mouse events*/


/**key events */

    public void keyTyped(KeyEvent e) {

	if(DX.ACTIVE==true) DX.processKey(e);
	if(DY.ACTIVE==true) DY.processKey(e);
	char ch=e.getKeyChar();
	int test=0;

	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(ch=='v') forceGo(1,0);

	if(test>0) doMouseClick(JX,test);

	if(ch=='a') doOrbit(true);
	if(ch=='s') doOrbit(false);
	if(ch=='d') doBlock(true);
	if(ch=='f') doBlock(false);

	if(ch=='r') {
	    if(SELECT!=-1) ORBIT[SELECT].reset();
	}
	if(ch=='t') GraphicsHelp.scaleNicely(this);
	if(ch=='y') recolorCurrent();

	if(ch=='j') jump1(+1);
	if(ch=='k') jump1(-1);
	if(ch=='q') jump2(+1);
	if(ch=='w') jump2(-1);
	if(ch=='o') toOrigin();
	if(ch=='p') {
               orbitcount=0;
               blockcount=0;
	       crosscount=0;
	       boxcount=0;
	}

	if(ch=='g') M.S.generate();
	repaint();
	M.S.repaint();
    }
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

    public void forceGo(int i,int j) {
	M.C.GRAPH.CHOICE.forceMode(i);
	M.C.repaint();
	if(i==0) { 
           M.C.GRAPH.AG.forceMode(j);
           M.C.CAG=new AGCompute(SOURCE,M);
           new Thread(M.C.CAG).start();
	}
	if(i==1) {
           M.C.CBM=new BoxCompute(SOURCE,M);
           new Thread(M.C.CBM).start();
	}
	M.C.repaint();
	M.S.repaint();
    }

}
