import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of complex numbers */

public class Complex {
    double x,y;
    
    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 
    
    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }
    
    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
    }

    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }
    
    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }
    
    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }

    public static Complex inverse(Complex z) {
        double d=z.x*z.x+z.y*z.y;
        return new Complex(z.x/d,-z.y/d);
    }
    
    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,inverse(z2));
    }
    
    public static Complex conjugate(Complex z) {
        return new Complex(z.x,-z.y);
    }
    
    public double norm() {
        return Math.sqrt(x*x+y*y);
    }

    public static double area(Complex z1,Complex z2,Complex z3) {
        Complex[] z=new Complex[5];
        for(int i=1;i<=4;++i) z[i]=new Complex();
        z[1]=Complex.minus(z2,z1);
        z[2]=Complex.minus(z3,z1);
        z[3]=Complex.conjugate(z[2]);
        z[4]=Complex.times(z[1],z[3]);
	double a=Math.abs(z[4].y);
	return(a);
    }

    public void print() {
	System.out.println("Complex: "+this.x+" "+this.y);
    }
}

