import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    AffineTransform A;

    Color COLOR;

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(50,750,700);
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawSquare(g);
      drawMe(g);
   }



    public void drawSquare(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
       gp.moveTo(0,0);
       gp.lineTo(1,0);
       gp.lineTo(1,(float)(1));
       gp.lineTo(0,(float)(1));
       gp.closePath();
       gp=transform(gp);
       g.setColor(Color.red);
       g.draw(gp);
    }


    public void drawMe(Graphics2D g) {

	for(int i=2;i<800;++i) {
	    for(int j=i+1;j<800;++j) {
		int[] a=MathRational.reduce(i,j);
		if((a[0]*a[1])%2==0) {
		    GeneralPath gp=makePoint(a);
		    g.setColor(Color.white);
		    gp=transform(gp);
		    g.draw(gp);
		}
	    }
	}
    }


    public GeneralPath makePoint(int[] a) {
	int[] b=MathRational.oppositeType(a[0],a[1]);
	double x=2.0*a[0]/(a[0]+a[1]);
 	double y=1.0*(b[0]+b[1])/(a[0]+a[1]);
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(x),(float)(y));
	gp.lineTo((float)(x),(float)(y));
	return(gp);
    }

    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	if(J.mode==1) scaleUp(J.X,-1);
	if(J.mode==3) scaleUp(J.X,1);
	repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
     } 

}

