

import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class MathRational {
    public int p;  //numerator
     public int q;  //denominator
    public int code;
   public  int level;

    public MathRational(int p,int q) {
	this.p=p;
	this.q=q;
	this.code=0;
	this.level=0;
    }

    public MathRational() {}


    /*This first routine implements the extended Euclidean algorithm.
      This is to say that program takes integers a,b and finds not
      only g=gcd(a,b) but also integers c,d such that ac+bd=g.  I 
      originally had programmed my own version of the Euclidean algorithm,
      but I lifted this algorithm from the internet.  The algorithm is
      taken from Donald Knuth's book of algorithms.*/


public static int[] GCDe(int a,int b) {

  int u,v,g;
  int u1,v1,g1;
  int t1,t2,t3;
  int q;
  u  = 1;  
  v  = 0;  
  g  = a;
  u1 = 0;  
  v1 = 1;  
  g1 = b;
  while (g1 != 0) {
    q = g/g1; 
    t1 = u - q*u1;   
    t2 = v - q*v1;   
    t3 = g - q*g1;
    u  = u1;   
    v  = v1;    
    g  = g1;
    u1 = t1;    
    v1 = t2;    
    g1 = t3;
  }
  int[] x={u,v,g};
  return(x);
}


    /*This just computes the greatest common divisor, without the coefficients.*/

    public static int GCD(int a,int b) {
	int[] x=GCDe(a,b);
	return(x[2]);
    }


    public static MathRational reduce(MathRational F) {
	int k=GCD(F.p,F.q);
	MathRational G=new MathRational(F.p/k,F.q/k);
	return(G);
    }

    public static int[] reduce(int a,int b) {
	int c=GCD(a,b);
	int[] d={a/c,b/c};
	return(d);
    }






    /*In the notation of the monograph, these routines compute A+ and A-, the two
      simpler rationals that are Farey related to A=a/b.*/


    public static int[] RMINUS(int a,int b) {

	if(a==1) {
	    int[] x={0,1};
	    return(x);
	}

	int[] d=GCDe(a,b);
	d[1]=-d[1];
	int t=(int)(Math.floor(1.0*d[0]/b));
	d[0]=d[0]-t*b;
	d[1]=d[1]-t*a;
	int[] e={d[1],d[0]};
	return(e);
    }


    public static int[] RPLUS(int a,int b) {

	int[] x = RMINUS(a,b);
	int[] y={a-x[0],b-x[1]};
	return(y);
    }

    public static int[] sameType(int a,int b) {
	int test1=(a*b)%2;
	int[] d1=RPLUS(a,b);
	int[] d2=RMINUS(a,b);
	int test2=(d1[0]*d1[1])%2;
	if(test2!=test1) return(d2);
	return(d1);
    }

    public static int[] oppositeType(int a,int b) {
	int test1=(a*b)%2;
	int[] d1=RPLUS(a,b);
	int[] d2=RMINUS(a,b);
	int test2=(d1[0]*d1[1])%2;
	if(test2==test1) return(d2);
	return(d1);
    }


    public static double gap(int p,int q) {
	int[] a1=MathRational.oppositeType(p,q);
	double r=.5*(a1[0]+a1[1])/(p+q);
	int k=(int)(r);
	int k2=(k*p)%(p+q);
	System.out.println("test "+k2);
	return(r);
    }

}
