import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of vectors */


public class Vector {
    double[] x=new double[3];
    public Vector(){}

    public Vector(Complex z) {
	x[0]=z.x;
	x[1]=z.y;
	x[2]=1.0;
    }
    public Vector(Vector V) {
	for(int i=0;i<3;++i) x[i]=V.x[i];
    }

    public Vector(double xx,double yy) {
	x[0]=xx;
	x[1]=yy;
	x[2]=1.0;
    }

    public double dist(Vector V1,Vector V2) {
	Vector W1=V1.normalize();
	Vector W2=V2.normalize();
	double xx=W1.x[0]-W2.x[0];
	double yy=W1.x[1]-W2.x[1];
	double d=xx*xx+yy*yy;
	d=Math.sqrt(d);
	return(d);
    }


    public int between(Vector V1,Vector V2,Vector V3) {
	double d1=dist(V1,V2);
	double d2=dist(V2,V3);
	double d3=dist(V1,V3);
	if(d1+d2-d3<.00000000001) return(1);
	return(0);
    }

    public static double dot(Vector v,Vector w) {
	return(v.x[0]*w.x[0]+v.x[1]*w.x[1]+v.x[2]*w.x[2]);
    }

    public static Vector cross(Vector v,Vector w) {
	Vector X=new Vector();
	X.x[0]=v.x[1]*w.x[2]-w.x[1]*v.x[2];
	X.x[1]=v.x[2]*w.x[0]-w.x[2]*v.x[0];
	X.x[2]=v.x[0]*w.x[1]-w.x[0]*v.x[1];
	return(X);
    }

    public static Vector plus(Vector v1,Vector v2) {
	Vector w=new Vector();
	for(int i=0;i<3;++i) {
	    w.x[i]=v1.x[i]+v2.x[i];
	}
	return(w);
    }

    public Vector normalize() {
	Vector W=new Vector();
	W.x[0]=this.x[0]/this.x[2];
	W.x[1]=this.x[1]/this.x[2];
	W.x[2]=1;
	return(W);
    }

    public static double tripleProduct(Vector v1,Vector v2,Vector v3) {
	return(dot(cross(v1,v2),v3));
    }

    public Complex  toComplex() {
	return(new Complex(x[0]/x[2],x[1]/x[2]));
    }

    public static Vector findCross(Vector v1,Vector v2,Vector v3,Vector v4) {
	Vector v5=cross(v1,v2);
	Vector v6=cross(v3,v4);
	Vector v7=cross(v5,v6);
	return(v7);
    }

    public static Complex findCross(Complex z1,Complex z2,Complex z3,Complex z4) {
	Vector v1=new Vector(z1);
	Vector v2=new Vector(z2);
	Vector v3=new Vector(z3);	
        Vector v4=new Vector(z4);
	Vector v5=findCross(v1,v2,v3,v4);
	return(v5.toComplex());
    }


    public static boolean  checkCross(Vector V1,Vector V2,Vector V3,Vector V4) {
	Vector W1=V1.normalize();
	Vector W2=V2.normalize();
	Vector W3=V3.normalize();
	Vector W4=V4.normalize();

	if(V1.between(V3,V1,V4)==1) return(true);
	if(V1.between(V3,V2,V4)==1) return(true);
	if(V1.between(V1,V3,V2)==1) return(true);
	if(V1.between(V1,V4,V2)==1) return(true);

	double o1=Vector.tripleProduct(W1,W2,W3);
	double o2=Vector.tripleProduct(W1,W2,W4);
	double o3=Vector.tripleProduct(W1,W3,W4);
	double o4=Vector.tripleProduct(W2,W3,W4);

	if(Math.abs(o1)<.00000000001) return(false);
	if(Math.abs(o2)<.00000000001) return(false);
	if(Math.abs(o3)<.00000000001) return(false);
	if(Math.abs(o4)<.00000000001) return(false);

	if(o1*o2>0) return(false);
	if(o3*o4>0) return(false);
	return(true);
    }


    public static boolean checkCross(Complex z1,Complex z2,Complex z3,Complex z4) {
	Vector v1=new Vector(z1);
	Vector v2=new Vector(z2);
	Vector v3=new Vector(z3);	
        Vector v4=new Vector(z4);
	return checkCross(v1,v2,v3,v4);
    }


}




