import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of complex numbers */

public class Complex {
    double x,y;
    
    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 
    
    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }
    
    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
    }

    public Complex set(Complex z) {
        x=z.x;
        y=z.y;
        return this;
    }

    public static double norm(Complex z) {
        return Math.sqrt(z.x*z.x+z.y*z.y);
    }

    public static Complex unit(Complex z) {
        double d=z.norm(z);
        return new Complex(z.x/d,z.y/d);
    }

    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }
    

    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }
    

    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }

    public static Complex inverse(Complex z) {
        double d=z.x*z.x+z.y*z.y;
        return new Complex(z.x/d,-z.y/d);
    }
    

    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,inverse(z2));
    }
    
    public static Complex conjugate(Complex z) {
        return new Complex(z.x,-z.y);
    }
    

    public static double dot(Complex a, Complex b) {
        return a.x*b.x+a.y*b.y;
    }
    
    public static double dist(Complex a,Complex b) {
        Complex z=minus(a,b);
        return(norm(z));
    }
    
    
    
    
    public double norm() {
        return Math.sqrt(x*x+y*y);
    }

    public Complex unit() {
        double d=norm();
        return new Complex(x/d,y/d);
    }

    public Complex plus(Complex z) {
        return new Complex(x+z.x, y+z.y);
    }
    

    public Complex minus(Complex z) {
        return new Complex(x-z.x, y-z.y);
    }

    public Complex times(Complex z) {
        return new Complex(x*z.x-y*z.y,
        x*z.y+y*z.x);
    }
    
    

    public Complex inverse() {
        double d=x*x+y*y;
        return new Complex(x/d,-y/d);
    }
    
    public Complex divide(Complex z2) {
        return times(inverse(z2));
    }
    
    
    public Complex conjugate() {
        return new Complex(x,-y);
    }

    public double dot(Complex a) {
        return a.x*x+a.y*y;
    }
    
    public boolean equals(Complex a) {
        return ((a.x==x)&&(a.y==y));
    }
    
    
    public double arg(){
        return Math.atan2(y,x);
    }


    public static int  isPositivelyOriented(Complex z1,Complex z2,Complex z3) {
        Complex[] z=new Complex[5];
        for(int i=1;i<=4;++i) z[i]=new Complex();
        z[1]=Complex.minus(z2,z1);
        z[2]=Complex.minus(z3,z1);
        z[3]=Complex.conjugate(z[2]);
        z[4]=Complex.times(z[1],z[3]);
	if(z[4].y<0) return(1);
	return(0);
    }


    /**triangle area**/
   public static double area(Complex z1,Complex z2,Complex z3) {
         double a;
         Complex[] z=new Complex[5];
         z[1]=minus(z2,z1);
         z[2]=minus(z3,z1);
         z[3]=conjugate(z[2]);
         z[4]=times(z[1],z[3]);
         a=-.5*z[4].y;
         return(a);
     }

    public static boolean contains(Complex[] Z,Complex w) {
	double[] d=new double[3];
	for(int i=0;i<3;++i) {
	    d[i]=area(w,Z[i%3],Z[(i+1)%3]);
	}
	for(int i=0;i<3;++i) {
	    if(d[i]*d[(i+1)%3]<0) return(false);
	}
	return(true);
    }

   public static double nearness(Complex z1,Complex z2,Complex w) {
 	double d1=dist(z1,z2);
 	double d2=dist(w,z1);
 	double d3=dist(w,z2);
 	double d=(d2+d3)/d1;
 	if(d>1.01) return(100);
 	double a1=area(z1,z2,w);
 	a1=Math.abs(a1);
 	double a2=dist(z1,z2);
 	return(a1/a2);
     }

    public Complex scale(Complex z,double r) {
        Complex w=new Complex();
        w.x=r*x+(1.0-r)*z.x;
        w.y=r*y+(1.0-r)*z.y;
        return(w);
    }


    /**ortho projection of z onto the segment w1 w2**/

    public static Complex retract(Complex w1,Complex w2,Complex z0) {
	Complex w=Complex.minus(w2,w1);
	Complex z=Complex.minus(z0,w1);
	z=Complex.divide(z,w);
	z.y=0;
	z=Complex.times(z,w);
	z=Complex.plus(z,w1);
	return(z);
    }


    public static Complex pow(Complex z,int k) {
	Complex w=new Complex(1,0);
	for(int i=0;i<k;++i) w=times(w,z);
	return(w);
    }

    public static Complex cr(Complex a,Complex b,Complex c,Complex d) {
	Complex ab=minus(a,b);
	Complex cd=minus(c,d);
	Complex ac=minus(a,c);
	Complex bd=minus(b,d);
	Complex abcd=times(ab,cd);
	Complex acbd=times(ac,bd);
	Complex w=divide(abcd,acbd);
	return(w);
    }



    /**tests if two line segments intersect*/

    public static boolean intersect(Complex z1,Complex z2,Complex w1,Complex w2) {
	double a1=area(z1,z2,w1);
	double a2=area(z1,z2,w2);
	if(a1*a2>0) return(false);
	double b1=area(w1,w2,z1);
	double b2=area(w1,w2,z2);
	if(b1*b2>0) return(false);
	return(true);
    }

    /**tests if the segments strictly intersect, with a tolerance**/
    public static boolean intersectStrict(Complex z1,Complex z2,Complex w1,Complex w2,double tol) {
	Complex zz1=new Complex();
	Complex zz2=new Complex();
	Complex ww1=new Complex();
	Complex ww2=new Complex();
	zz1.x=(1-tol)*z1.x+tol*z2.x;
	zz1.y=(1-tol)*z1.y+tol*z2.y;
	zz2.x=(1-tol)*z2.x+tol*z1.x;
	zz2.y=(1-tol)*z2.y+tol*z1.y;
	ww1.x=(1-tol)*w1.x+tol*w2.x;
	ww1.y=(1-tol)*w1.y+tol*w2.y;
	ww2.x=(1-tol)*w2.x+tol*w1.x;
	ww2.y=(1-tol)*w2.y+tol*w1.y;
	return(intersect(zz1,zz2,ww1,ww2));
    }


    /**tests if a line segment crosses the boundary of a triangle**/

    public static boolean intersect(Complex z1,Complex z2,Complex z3,Complex w1,Complex w2) {
	if(intersect(z1,z2,w1,w2)==true) return(true);
	if(intersect(z2,z3,w1,w2)==true) return(true);
	if(intersect(z3,z1,w1,w2)==true) return(true);
	return(false);
    }


    public void print() {
	System.out.println("Complex: "+this.x+" "+this.y);
    }
}

