import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



class ControlCanvas extends Canvas implements MouseMotionListener,MouseListener {
    Manager M;
    int history;
    double speed;
    SelectInteger NUMBER;
    Lever SPEED,TEST,SENSE,PLOT,MOUSE;
    ListenSquare RESET;
    Animator ANN;  
    ControlPanelColor DISPLAY;
    SelectColor SC;
    boolean INIT=false;
    Vector SOURCE;
    ListenSquare ON,OFF,EXPORT;

    ControlCanvas() {
	history=-1;
	addMouseListener(this);
	addMouseMotionListener(this);

	ON=new ListenSquare(0,0,30,15);
	OFF=new ListenSquare(30,0,40,15);
	EXPORT=new ListenSquare(80,0,50,15);
	ON.on=1;
	OFF.on=1;
	EXPORT.on=1;

	NUMBER=new SelectInteger(100,40,40,20,5,3,40,1);
	RESET=new ListenSquare(0,40,40,20);RESET.on=1;
	ANN=new Animator();
	SC=new SelectColor(0,250,300,50);
	TEST=new Lever(4,100,0,6);

	MOUSE=new Lever(100,100,0,4);
	SPEED=new Lever(4,220,12,24);
	SENSE=new Lever(4,180,12,24);
	PLOT=new Lever(4,140,14,24);

	setPanels();
    }




    public void setPanels() {
	Color[] C0={Color.blue,Color.white,Color.blue,Color.white,Color.black};
	Color[] DisplayColor={
	    new Color(255,100,0),
            new Color(230,230,230),Color.black,
            new Color(210,210,210),Color.black,
            new Color(255,255,255),Color.black,
            Color.blue};


	String[] DisplayString={
              "bg",
              "out","out edge",
              "in","in edge",
              "poly","poly edge",
              "plot"};

	int[] DisplayState={1,1,1,1,1,1,1,1};
        DISPLAY=new ControlPanelColor(C0,DisplayString,DisplayState,8,DisplayColor);
    }







    public void paint(Graphics gfx) {
      Graphics2D g=(Graphics2D) gfx;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);

      drawButtons(g);
    }



    public void drawButtons(Graphics2D g) {
	g.fillRect(0,0,getWidth(),getHeight());
	RESET.render(g,Color.blue);
	NUMBER.render(g,Color.red,Color.white,Color.white);
	DISPLAY.render(g,210,5,85);
	SC.render(g);
	SPEED.render(g,"speed",Color.blue); 
	SENSE.render(g,"plot sensitivity",Color.blue); 
	MOUSE.render(g,"mouse emulator",new Color(0,160,0));
	PLOT.render(g,"# plotted points",Color.blue); 
	TEST.render(g,"CM choice",Color.blue);   

        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.setColor(Color.white);
	g.drawString("# of points",(int)(NUMBER.x),(int)(NUMBER.y-5));
	g.drawString("plot reset",(int)(RESET.x),(int)(RESET.y-5));
	if(ANN.HALT==true) {
	    ON.render(g,new Color(0,190,0));
	    g.drawString("go",5,11);
	    }
	if(ANN.HALT==false) {
	    OFF.render(g,Color.red);
	    g.drawString("stop",35,11);
	}
        EXPORT.render(g,Color.blue);
        g.drawString("export",85,11);
    }

    public void reset() {
	M.P.COUNT=0;
    }



 public void mouseExited(MouseEvent e) { }

    public void changeNumber(Point p) {
        NUMBER.modify(p);
	if(NUMBER.isModified(p)==1) {
	    M.P.COUNT=0;
	    M.P.number=NUMBER.val+1;
	}

    }


 public void mouseReleased(MouseEvent e) {}
 public void mousePressed(MouseEvent e) {
     startIt();
     M.P.repaint();
 }
 public void mouseEntered(MouseEvent e) {}
 public void mouseDragged(MouseEvent e) {
 }
 public void mouseMoved(MouseEvent e) {}



 public void mouseClicked(MouseEvent e) {
     e.consume();
     SC.process(e);
     Point p= new Point();
     p.x=e.getX();
     p.y=e.getY();
     int test=0;
     changeNumber(p);
     TEST.process(p);
     SPEED.process(p);
     SENSE.process(p);;
     MOUSE.process(p);
     PLOT.process(p);
     if(ON.inside(p)==1) startIt();
     if(OFF.inside(p)==1) stopIt();
     if(EXPORT.inside(p)==1) M.P.export();
     DISPLAY.process(p,SC.C);
     if(RESET.inside(p)==1) reset();
     repaint();
 }



    public void startIt() {
	if(ANN.HALT==true) {
	  ANN=new Animator(this.M);
          new Thread(ANN).start();
	}
    }

    public void stopIt() {
	ANN.HALT=true;
    }


}



