import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;


class Matrix {
    Vector x,y,z;

    public Matrix() {
	this.x=new Vector();
	this.y=new Vector();
	this.z=new Vector();
    }

    public static Matrix translate(double d) {
	double c=Math.sqrt(1/(1-d*d));
	double s=d*c;
	Matrix t=new Matrix();
	t.x=new Vector(c,0,s);
	t.y=new Vector(0,1,0);
	t.z=new Vector(s,0,c);
	return(t);
    }

    public static Matrix rotate(double c,double s) {
	Matrix t=new Matrix();
	t.x=new Vector(c,s,0);
	t.y=new Vector(-s,c,0);
	t.z=new Vector(0,0,1);
	return(t);
    }


    public Vector act(Vector v) {
       Vector w=new Vector();
       w.x=w.dot(x,v);
       w.y=w.dot(y,v);
       w.z=w.dot(z,v);
       w.x=w.x/w.z;
       w.y=w.y/w.z;
       w.z=1;
       return(w);
    }


    public Polyvector act(Polyvector P) {
	Polyvector Q=new Polyvector(P.n);
	for(int i=1;i<=P.n;++i) {
	    Q.v[i]=act(P.v[i]);
	}
	return(Q);
    }


    public static Polyvector specialTransform(Polyvector P,Vector V) {
	double x=V.x;
	double y=V.y;
	double d=Math.sqrt(x*x+y*y);
	Matrix m1=translate(d);
	double c=1;
	double s=0;
	if(d>.000001) {
	    c=x/d;
	    s=-y/d;
	}
	Matrix m2=rotate(c,s);
	Matrix m3=rotate(c,-s);
	Polyvector Q=m3.act(P);
	Q=m1.act(Q);
	Q=m2.act(Q);
	return(Q);
    }

}

